<?php
$main_title = get_field('project_title', 'option');
$desc = get_field('project_desc', 'option');
?>
<section class="project-section" id="project">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 col-md-7 mx-auto text-center">
                <?php
                if ($main_title != '') {
                    ?>
                    <h2 class="main-heading wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo $main_title; ?>
                    </h2>
                <?php } ?>
                <?php if ($desc != '') { ?>
                    <p class="section_desc wow fadeInUp" data-wow-delay="0.5s">
                        <?php echo $desc; ?>
                        <span class="accent-color">.</span>
                    </p>
                <?php } ?>
            </div>
        </div>
    </div>
    <div class="container-fluid px-0">
        <div class="row g-0">
            <?php
            $args = array(
                'post_type' => 'project',
                'posts_per_page' => '8',
                'meta_query' => array(
                    array(
                        'key' => 'selected_project',
                        'compare' => '=',
                        'value' => '1'
                    )
                )
            );
            $query = new WP_Query($args);
            if ($query->have_posts()):
                $i = 0.25;
                while ($query->have_posts()) : $query->the_post();
                    ?>
                    <div class="project-col col-6 col-md-3">
                        <div class="project-item position-relative">
                            <a href="<?php echo get_the_permalink(); ?>" class="project-inner">
                                <figure>
                                    <?php the_post_thumbnail('project-img'); ?>
                                </figure>
                                <div class="project-content">
                                    <h3><?php echo get_the_title(); ?></h3>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php
                endwhile;
            endif;
            ?>
        </div>
    </div>
</section>
