<?php
$title = get_field('blog_title', 'option');
$blog_link = get_field('blog_link', 'option');
?>
<section class="blog-section" id="blog">
    <div class="container">
        <div class="row">
            <div class="col-12 blog-head text-center mb-5">
                <h2 class="main-heading wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo $title; ?>
                </h2>
            </div>

            <?php
            $args = array(
                'post_type' => 'post',
                'posts_per_page' => '3',
                'meta_query' => array(
                    array(
                        'key' => 'is_home',
                        'compare' => '=',
                        'value' => '1'
                    )
                )
            );
            $query = new WP_Query($args);
            if ($query->have_posts()):
                $i = 0.25;
                while ($query->have_posts()) : $query->the_post();
                    echo '<div class="col-12 col-sm-6 col-lg-4 blog-item wow fadeInUp" data-wow-delay="' . $i . 's">';
                    echo get_template_part('templates/card/blog', 'card');
                    echo '</div>';
                    $i += 0.25; endwhile;
            endif;
            ?>

            <?php if ($blog_link != '') {
                echo '<div class="col-12 all-button text-center">';
                echo '<a href="' . $blog_link . '" class="theme-button">همه مقالات <i class="icon-arrow-left"></i></a>';
                echo '</div>';
            } ?>
        </div>
    </div>
</section>
