<?php
get_header();
?>

<div class="single-page pt-0">
    <?php
    if (have_posts()) :
        while (have_posts()) : the_post();
            ?>
            <?php
            $images = get_field('project_gallery');
            if ($images): ?>
                <div class="container-fluid">
                    <div class="row">
                        <div class="swiper-container swiper-project col-12 p-0">
                            <div class="swiper-wrapper">
                                <?php foreach ($images as $image): ?>
                                    <div class="swiper-slide">
                                            <img
                                                    src="<?php echo esc_url($image['sizes']['large']); ?>"
                                                    alt="<?php echo esc_attr($image['alt']); ?>"/>

                                    </div>
                                <?php endforeach; ?>

                            </div>
                            <!-- If we need navigation buttons -->
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>

                            <div class="col-11 col-md-7 col-lg-5 project-sidebar">
                                <div class="sidebar">
                                    <h1 class="single-title text-start wow fadeInUp" data-wow-delay="0.25s">
                                        <?php echo get_the_title(); ?>
                                    </h1>
                                    <?php
                                    $plocation = get_field('plocation');
                                    $client = get_field('client');
                                    $duration = get_field('duration');
                                    $provider = get_field('provider');
                                    $start_date = get_field('start_date');
                                    $project_status = get_field('project_status');
                                    $location = get_field('location');

                                    echo '<ul>';
                                    if ($plocation != '') {
                                        echo '<li><span><i class="icon-map"></i>محل پروژه</span>' . $plocation . '</li>';
                                    }
                                    if ($client != '') {
                                        echo '<li><span><i class="icon-user"></i>کارفرما</span>' . $client . '</li>';
                                    }
                                    if ($duration != '') {
                                        echo '<li><span><i class="icon-clock"></i>مدت پیمان</span>' . $duration . '</li>';
                                    }
                                    if ($provider != '') {
                                        echo '<li><span><i class="icon-user"></i>پیمانکار</span>' . $provider . '</li>';
                                    }
                                    if ($start_date != '') {
                                        echo '<li><span><i class="icon-date"></i>تاریخ شروع</span>' . $start_date . '</li>';
                                    }
                                    if ($project_status) {
                                        echo '<li><span><i class="icon-status"></i>وضعیت پروژه</span>' . $project_status['label'] . '</li>';
                                    }
                                    if ($location) {
                                        echo '<li><span><i class="icon-map"></i>موقعیت مکانی</span>' . $location['label'] . '</li>';
                                    }
                                    echo '</ul>';
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="container-lg my-5">
                <div class="row">
                    <div class="col-12 col-lg-8 mx-auto">
                        <?php if (has_post_thumbnail() && !$images) { ?>
                            <div class="single-thumbnail text-center mb-5">
                                <?php the_post_thumbnail('large'); ?>
                            </div>
                        <?php } ?>
                        <h4 class="single-title text-start wow fadeInUp" data-wow-delay="0.25s">
                            <?php echo get_the_title(); ?>
                        </h4>
                        <article class="post-single" itemscope="itemscope" itemtype="http://schema.org/Article">
                            <div class="default-editor"><?php the_content(); ?></div>
                        </article>
                    </div>
                </div>
            </div>
        <?php
        endwhile;
    endif;
    ?>
</div>
</div>
<?php get_footer(); ?>
