<?php

class Selected_Products extends \Elementor\Widget_Base
{


	public function get_name()
	{
		return 'product-select';
	}

	public function get_title()
	{
		return __('selected products', 'denver');
	}

	public function get_icon()
	{
		return 'eicon-product-related';
	}

	public function get_categories()
	{
		return ['elementor-widget-be-shop'];
	}
	public function get_script_depends()
	{
		return ['elementor-hello-world'];
	}

	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
	{
		$this->start_controls_section(
			'section_content',
			[
				'label' => __('General', 'denver'),
			]
		);
		$this->add_control(
			'post_type',
			[
				'label' => __('post type', 'denver'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'product',
				'options' => [
					'product'  => __('product', 'denver'),
					'post' => __('post', 'denver'),
					'page' => __('page', 'denver'),
				],
			]
		);
		$this->add_control(
			'grid_style',
			[
				'label' => __('Grid Style', 'denver'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__('Layout 1', 'denver'),
					'2' => esc_html__('Layout 2', 'denver'),
					'3' => esc_html__('Layout 3', 'denver'),
					'4' => esc_html__('Layout 4', 'denver'),
					'5' => esc_html__('Layout 5', 'denver'),
					'6' => esc_html__('Layout 6', 'denver'),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __('Title', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Edible and drinkable',
			]
		);
		$this->add_control(
			'title_self',
			[
				'label' => __('title self', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'تــــخــــفـــــیــــف تـــا',
			]
		);
		$this->add_control(
			'title_self_discount',
			[
				'label' => __('self discount', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '34%',
			]
		);
		$this->add_control(
			'title_show_more',
			[
				'label' => __('title show more', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'View all offers',
			]
		);
		$this->add_control(
			'more_link',
			[
				'label' => __('more Link', 'denver'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'denver'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'countdown',
			[
				'label' => __('countdown', 'denver'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'denver'),
				'label_off' => __('Hide', 'denver'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_add_to_cart',
			[
				'label' => __('add to cart', 'denver'),
			]
		);
		$this->add_control(
			'title_add_to_cart',
			[
				'label' => __('Title', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('add to cart', 'denver'),
			]
		);
		$this->add_control(
			'cart_tools',
			[
				'label' => __('add to cart', 'denver'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '2',
				'options' => [
					'1' => esc_html__('hid', 'denver'),
					'2' => esc_html__('cart', 'denver'),
					'3' => esc_html__('cart advanced', 'denver'),
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_Icon',
			[
				'label' => __('Icon', 'denver'),
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => __('Icon', 'denver'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_Image',
			[
				'label' => __('Image', 'denver'),
			]
		);
		$this->add_control(
			'image_covering',
			[
				'label' => __('Choose Image', 'denver'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label' => __('Choose Image desktop ', 'denver'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'bg_image', // Actually its `image_size`
				'label' => __('Image Resolution', 'denver'),
				'default' => 'full',
				'condition' => [
					'bg_image[id]!' => '',
				],
				'separator' => 'none',
			]

		);
		$this->add_control(
			'bg_image_mobile',
			[
				'label' => __('Choose Image mobile', 'denver'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'bg_image_mobile', // Actually its `image_size`
				'label' => __('Image Resolution', 'denver'),
				'default' => 'full',
				'condition' => [
					'bg_image[id]!' => '',
				],
				'separator' => 'none',
			]

		);
		$this->end_controls_section();
		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'denver'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_title',
			[
				'label' => __('Title', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('List Title', 'denver'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'post_id',
			[
				'label' => __('post id', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '34',
			]
		);
		$repeater->add_control(
			'code_self',
			[
				'label' => __('code self', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'code self : AV10',
			]
		);
		$repeater->add_control(
			'code_self_time',
			[
				'label' => __('time self', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'code self : AV10',
			]
		);
		$repeater->add_control(
			'icon_item',
			[
				'label' => __('Icon', 'denver'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'icon_item_time',
			[
				'label' => __('icon item time', 'denver'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'image_brand',
			[
				'label' => __('Choose Image brand', 'denver'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'description',
			[
				'label' => __('Description', 'denver'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Description', 'denver'),
			]
		);
		$repeater->add_control(
			'website_link',
			[
				'label' => __('Link', 'denver'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'denver'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __('Repeater List', 'denver'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __('Title #1', 'denver'),
						'list_content' => __('Item content. Click the edit button to change this text.', 'denver'),
					],
					[
						'list_title' => __('Title #2', 'denver'),
						'list_content' => __('Item content. Click the edit button to change this text.', 'denver'),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style2',
			[
				'label' => __('Style', 'denver'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'background_color',
			[
				'label' => __('background color', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_1',
			[
				'label' => __('Title Color', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#E7DFDF',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_2',
			[
				'label' => __('Title Color 2', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#E7DFDF',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_3',
			[
				'label' => __('Title Color 3', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#E7DFDF',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_4',
			[
				'label' => __('color show more', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#E7DFDF',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_5',
			[
				'label' => __('color show more mobile', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#212121',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style',
			[
				'label' => __('Style self', 'denver'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'description_color',
			[
				'label' => __('description color', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#4a5f73;',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'background_color_code_self',
			[
				'label' => __('background color code self', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#f5f6f7',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'color_code_self',
			[
				'label' => __('color code self', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#43486a;',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'self_time_color',
			[
				'label' => __('self time color', 'denver'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#737373',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{ ?>
		<script>
			$('.owl-carousel.focarousel5').owlCarousel({
				rtl: true,
				loop: false,
				margin: 0,
				dots: false,
				navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
				nav: true,
				responsive: {
					0: {
						items: 2,
						nav: false,
					},
					600: {
						items: 3,
						nav: false,
					},
					1000: {
						items: 5
					}
				}
			});
			$('.owl-carousel.trcarousel').owlCarousel({
				rtl: true,
				loop: false,
				margin: 0,
				dots: false,
				navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
				nav: true,
				responsive: {
					0: {
						items: 2,
						nav: false,
					},
					600: {
						items: 3,
						nav: false,
					},
					1000: {
						items: 4
					}
				}
			});
			$('.owl-carousel.focarousel').owlCarousel({
				rtl: true,
				loop: false,
				margin: 0,
				dots: false,
				navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
				nav: true,
				responsive: {
					0: {
						items: 2,
						nav: false,
					},
					600: {
						items: 3,
						nav: false,
					},
					1000: {
						items: 4
					}
				}
			});
		</script>
		<?php
		$settings = $this->get_settings_for_display();
		$grid_style = $settings['grid_style'];
		$cart_tools = $settings['cart_tools'];
		$bg_image = '';
		$bg_image_mobile = '';
		// background image
		if (!empty($settings['bg_image']['id'])) {
			$bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
		} elseif (!empty($settings['bg_image']['url'])) {
			$bg_image = $settings['bg_image']['url'];
		}
		$this->add_render_attribute('background_image', 'style', [
			'background-image: url(' . $bg_image . ');',
		]);
		// background image mobile
		if (!empty($settings['bg_image_mobile']['id'])) {
			$bg_image_mobile = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image_mobile']['id'], 'bg_image_mobile', $settings);
		} elseif (!empty($settings['bg_image_mobile']['url'])) {
			$bg_image_mobile = $settings['bg_image_mobile']['url'];
		}
		$this->add_render_attribute('background_image_mobile', 'style', [
			'background-image: url(' . $bg_image_mobile . ');',
		]);
		if ($settings['list']) {

			if (6 == $grid_style) {

				include(__DIR__ . '/template/product-select/layout-6.php');
			} elseif (5 == $grid_style) {

				include(__DIR__ . '/template/product-select/layout-5.php');
			} elseif (4 == $grid_style) {

				include(__DIR__ . '/template/product-select/layout-4.php');
			} elseif (3 == $grid_style) {

				include(__DIR__ . '/template/product-select/layout-3.php');
			} elseif (2 == $grid_style) {

				include(__DIR__ . '/template/product-select/layout-2.php');
			} else {

				include(__DIR__ . '/template/product-select/layout-1.php');
			}
			wp_reset_postdata();
		?>

<?php

		}
	}
}
