<?php
class Amazon_Cat_Slid extends \Elementor\Widget_Base {
	public function get_name() {
		return 'amazon-cat-slid';
	}

	public function get_title() {
		return __( 'amazon cat slid', 'denver' );
	}

	public function get_icon() {
		return 'eicon-product-images';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}

	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {

		$this->start_controls_section(
			'differ_content',
			[
				'label' => __( 'Grid', 'denver' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'grid_style',
			[
			  'label' => __( 'Grid Style', 'denver' ),
			  'type' => \Elementor\Controls_Manager::SELECT,
			  'default' => '1',
			  'options' => [
			  '1' => esc_html__( 'Layout 1', 'denver' ),
			  ],
			]
			);
     $this->end_controls_section();
		 $this->start_controls_section(
		  'content_section',
		  [
			'label' => __( 'slider images', 'denver' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		  ]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'denver' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'denver' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
		  'ama_image',
		  [
			'label' => __( 'Choose Image slider', 'denver' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
			  'url' => \Elementor\Utils::get_placeholder_image_src(),
			],
		  ]
		);
		$repeater->add_control(
		  'website_link',
		  [
			'label' => __( 'Link', 'denver' ),
			'type' => \Elementor\Controls_Manager::URL,
			'placeholder' => __( 'https://your-link.com', 'denver' ),
			'show_external' => true,
			'default' => [
			  'url' => '',
			  'is_external' => true,
			  'nofollow' => true,
			],
		  ]
		);
		$this->add_control(
		  'list',
		  [
			'label' => __( 'Repeater List', 'denver' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
			  [
				'list_title' => __( 'Title #1', 'denver' ),
				'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
			  ],
			  [
				'list_title' => __( 'Title #2', 'denver' ),
				'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
			  ],
			],
			'title_field' => '{{{ list_title }}}',
		  ]
		);

        $this->end_controls_section();
        $this->start_controls_section(
            'content_section_cat',
            [
              'label' => __( 'slider catgory', 'denver' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
          );
          $repeater = new \Elementor\Repeater();
          $repeater->add_control(
              'list_title_cat', [
                  'label' => __( 'Title', 'denver' ),
                  'type' => \Elementor\Controls_Manager::TEXT,
                  'default' => __( 'List Title' , 'denver' ),
                  'label_block' => true,
              ]
          );
          $repeater->add_control(
            'list_title_cat_two', [
                'label' => __( 'Title more', 'denver' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'see more' , 'denver' ),
                'label_block' => true,
            ]
        );
          $repeater->add_control(
            'ama_image_cat',
            [
              'label' => __( 'Choose Image slider', 'denver' ),
              'type' => \Elementor\Controls_Manager::MEDIA,
              'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
              ],
            ]
          );
          $repeater->add_control(
            'website_link_cat',
            [
              'label' => __( 'Link', 'denver' ),
              'type' => \Elementor\Controls_Manager::URL,
              'placeholder' => __( 'https://your-link.com', 'denver' ),
              'show_external' => true,
              'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
              ],
            ]
          );
          $repeater->add_control(
            'my_plugin_product_grid_product_filter',
            [
                'label' => esc_html__( 'Filter By', 'denver' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'recent',
                'options' => [
                    'recent' => esc_html__( 'Recent Products', 'denver' ),
                    'featured' => esc_html__( 'Featured Products', 'denver' ),
                    'best_selling' => esc_html__( 'Best Selling Products', 'denver' ),
                    'sale' => esc_html__( 'Sale Products', 'denver' ),
                    'top_rated' => esc_html__( 'Top Rated Products', 'denver' ),
                    'mixed_order' => esc_html__( 'Mixed order Products', 'denver' ),
                ],
            ]
        );
        $repeater->add_control(
          'my_plugin_product_grid_products_count',
          [
             'label'   => __( 'Products Count', 'denver' ),
             'type'    => \Elementor\Controls_Manager::SELECT,
             'default' => '1',
             'options' => [
                '1' => esc_html__( 'Layout 1', 'denver' ),
                '2' => esc_html__( 'Layout 2', 'denver' ),
                '3' => esc_html__( 'Layout 3', 'denver' ),
                '4' => esc_html__( 'Layout 4', 'denver' ),
                ],
          ]
        );

        $repeater->add_control(
            'my_plugin_product_grid_categories',
            [
                'label' => esc_html__( 'Product Categories', 'denver' ),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => my_plugin_taxonomy_list(),
            ]
        );

        $repeater->add_control(
            'custom_order',
            [
                'label' => esc_html__( 'Custom order', 'denver' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'orderby',
            [
                'label' => esc_html__( 'Orderby', 'denver' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'          => esc_html__('None','denver'),
                    'ID'            => esc_html__('ID','denver'),
                    'date'          => esc_html__('Date','denver'),
                    'name'          => esc_html__('Name','denver'),
                    'title'         => esc_html__('Title','denver'),
                    'comment_count' => esc_html__('Comment count','denver'),
                    'rand'          => esc_html__('Random','denver'),
                ],
                'condition' => [
                    'custom_order' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'order',
            [
                'label' => esc_html__( 'order', 'denver' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC'  => esc_html__('Descending','denver'),
                    'ASC'   => esc_html__('Ascending','denver'),
                ],
                'condition' => [
                    'custom_order' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'list_cat',
            [
              'label' => __( 'Repeater List', 'denver' ),
              'type' => \Elementor\Controls_Manager::REPEATER,
              'fields' => $repeater->get_controls(),
              'default' => [
                [
                  'list_title' => __( 'Title #1', 'denver' ),
                  'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
                ],
                [
                  'list_title' => __( 'Title #2', 'denver' ),
                  'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
                ],
                [
                    'list_title' => __( 'Title #3', 'denver' ),
                    'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
                ],
                [
                    'list_title' => __( 'Title #4', 'denver' ),
                    'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
                ],
                
              ],
              'title_field' => '{{{ list_title }}}',
            ]
          );
  
          $this->end_controls_section();
          $this->start_controls_section( 
            'content_section_h',
            [
              'label' => __( 'option slide', 'denver' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
          );
            $this->add_control(
              'autoplay_ama',
              [
                'label' => __( 'auto play', 'denver' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'true', 'denver' ),
                'label_off' => __( 'false', 'denver' ),
                'return_value' => 'yes',
                'default' => 'yes',
              ]
            );
            $this->add_control(
              'autoplayTimeout',
              [
                'label' => __( 'auto play Time out', 'denver' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 5,
                'max' => 10000,
                'step' => 5,
                'default' => 5000,
              ]
            );
            $this->add_control(
              'navext_ama',
              [
                'label' => __( 'nav', 'denver' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'true', 'denver' ),
                'label_off' => __( 'false', 'denver' ),
                'return_value' => 'yes',
                'default' => 'yes',
              ]
            );
          $this->end_controls_section();
          $this->start_controls_section(
            'section_style',
            [
              'label' => __( 'Style self', 'denver' ),
              'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
          );
          $this->add_control(
            'background_color',
            [
              'label' => __( 'background color', 'denver' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#fff;',
              'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
              ],
              'selectors' => [
                '{{WRAPPER}} .title' => 'color: {{VALUE}}',
              ],
            ]
          );
          $this->add_control(
            'description_color',
            [ 
              'label' => __( 'color title post', 'denver' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#212121;',
              'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
              ],
              'selectors' => [
                '{{WRAPPER}} .title' => 'color: {{VALUE}}',
              ],
            ]
          );
          $this->add_control(
            'background_color_code_self',
            [
              'label' => __( 'color see more', 'denver' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#212121',
              'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
              ],
              'selectors' => [
                '{{WRAPPER}} .title' => 'color: {{VALUE}}',
              ],
            ]
          );


          $this->end_controls_section();
       
	}


	protected function render() { 

        $settings = $this->get_settings_for_display();
        $grid_style = $settings['grid_style'];
        $autoplayTimeout = $settings['autoplayTimeout'];

		$bg_image = ''; ?>
    <script>
jQuery(document).ready(function (e) {
    e(".owl-two.owl-carousel").owlCarousel({
        items: 1,
        rtl: !0,
        lazyLoad: !0,
        autoWidth: !1,
        navText: <?php if ( 'yes' === $settings['navext_ama'] ) { ?>
           ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>']
           <?php
        }else{
          echo 'false';
        } ?>,
        nav: !0,
        dots: false,
        autoplay: <?php if ( 'yes' === $settings['autoplay_ama'] ) {
          echo 'true';
        }else{
          echo 'false';
        } ?>,
        autoplayTimeout: <?php echo $autoplayTimeout ; ?>,
        loop: !0,
        responsive: {
            0: {
                items: 1,
                nav: !1
            },
            600: {
                items: 1,
                nav: !1
            },
            1000: {
                items: 1
            }
        }
    }), e(".owl-carousel.focarouselas").owlCarousel({
        rtl: !0,
        loop: !1,
        margin: 0,
        dots: !1,
        navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
        nav: !0,
        responsive: {
            0: {
                items: 1,
                nav: !1
            },
            600: {
                items: 3,
                nav: !1
            },
            1000: {
                items: 4
            }
        }
    })
});
</script>

        <section style="background-color: unset;margin-top: -20px;" class="margin-top-50 flex landing-hero"<?php echo $this->get_render_attribute_string( 'background_image' ); ?>>
        <div class="amazon-cat-slid">
        <?php if ( $settings['list'] ) { ?>
				<div class="amazon--slid">
					<div class="owl-two owl-carousel owl-theme sec-promotions" style=" width: 100%;">
						<?php foreach (  $settings['list'] as $item ) { ?>
							<div class="swiper-container">
								<div class="swiper-wrapper">
									<a href="<?php echo $item['website_link']['url']; ?>" class="woo-product-box-item-link wo-main-slider__slide swiper-slide">
									<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'ama_image' ); ?>
									</a>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
    <?php } ?>
    <div class="col-12">
	   <div class="container">
			<div class="row">
            <?php if ( $settings['list_cat'] ) { 
                foreach (  $settings['list_cat'] as $item ) { 
                ?>
                <div class="col-12 col-sm-6 col-md-4 col-lg-3 margin_a10">
                    <div class="amazon_cat_cart">
                        <article class="amazon_box">
                            <header>
                                <h2 style="color:<?php echo $settings['description_color']; ?>"><?php echo $item['list_title_cat']; ?></h2>
                            </header>
                            <div class="cardui-body">
                                    <div>
                                    <?php
                              $product_type       = $item['my_plugin_product_grid_product_filter'];
                              $per_page           = $item['my_plugin_product_grid_products_count'];
                              $custom_order_ck    = $item['custom_order'];
                              $orderby            = $item['orderby'];
                              $order              = $item['order'];
                              $producttab          = $this->get_settings_for_display('producttab');
                      // WooCommerce Category
                      $args = array(
                          'post_type'             => 'product',
                          'post_status'           => 'publish',
                          'ignore_sticky_posts'   => 1,
                          'posts_per_page'        => $per_page,
                      );
                      if ( ! empty( $item['bg_image']['id'] ) ) {
                          $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src( $item['bg_image']['id'], 'bg_image', $item );
                        } elseif ( ! empty( $item['bg_image']['url'] ) ) {
                          $bg_image = $item['bg_image']['url'];
                        }
                        $this->add_render_attribute( 'background_image', 'style', [
                          'background-image: url(' . $bg_image . ');',
                          ] );
                      switch( $product_type ){

                          case 'sale':
                              $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
                          break;

                          case 'featured':
                              $args['tax_query'][] = array(
                                  'taxonomy' => 'product_visibility',
                                  'field'    => 'name',
                                  'terms'    => 'featured',
                                  'operator' => 'IN',
                              );
                          break;

                          case 'best_selling':
                              $args['meta_key']   = 'total_sales';
                              $args['orderby']    = 'meta_value_num';
                              $args['order']      = 'desc';
                          break;

                          case 'top_rated':
                              $args['meta_key']   = '_wc_average_rating';
                              $args['orderby']    = 'meta_value_num';
                              $args['order']      = 'desc';
                          break;

                          case 'mixed_order':
                              $args['orderby']    = 'rand';
                          break;

                          default: /* Recent */
                              $args['orderby']    = 'date';
                              $args['order']      = 'desc';
                          break;
                      }

                      // Custom Order
                      if( $custom_order_ck == 'yes' ){
                          $args['orderby'] = $orderby;
                          $args['order'] = $order;
                      }

                      $get_product_categories = $item['my_plugin_product_grid_categories']; // get custom field value
                      $product_cats = str_replace(' ', '', $get_product_categories);

                      if ( "0" != $get_product_categories) {
                          if( is_array($product_cats) && count($product_cats) > 0 ){
                              $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                              $args['tax_query'][] = array(
                                  array(
                                      'taxonomy' => 'product_cat',
                                      'terms' => $product_cats,
                                      'field' => $field_name,
                                      'include_children' => false
                                  )
                              );
                          }
                      }

                      $products = new \WP_Query( $args );
                      if ( $producttab == 'yes' ) { 
                              $m=0;
                              if( is_array( $product_cats ) && count( $product_cats ) > 0 ){

                                  // Category retrive
                                  $catargs = array(
                                      'orderby'    => 'name',
                                      'order'      => 'ASC',
                                      'hide_empty' => true,
                                      'slug'       => $product_cats,
                                  );
                                  $prod_categories = get_terms( 'product_cat', $catargs);

                                  foreach( $prod_categories as $prod_cats ){
                                      $m++;
                                      $field_name = is_numeric( $product_cats[0] ) ? 'term_id' : 'slug';
                                      $args['tax_query'] = array(
                                          array(
                                              'taxonomy' => 'product_cat',
                                              'terms' => $prod_cats,
                                              'field' => $field_name,
                                              'include_children' => false
                                          ),
                                      );
                                      if( 'featured' == $product_type ){
                                          $args['tax_query'][] = array(
                                              'taxonomy' => 'product_visibility',
                                              'field'    => 'name',
                                              'terms'    => 'featured',
                                              'operator' => 'IN',
                                          );
                                      }
                                  }
                              }
                          };
                      if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ):
                              $j=0;
                              foreach( $product_cats as $cats ):
                                  $j++;
                                  $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                                  $args['tax_query'] = array(
                                      array(
                                          'taxonomy' => 'product_cat',
                                          'terms' => $cats,
                                          'field' => $field_name,
                                          'include_children' => false
                                      )
                                  );
                                  if( 'featured' == $product_type ){
                                      $args['tax_query'][] = array(
                                          'taxonomy' => 'product_visibility',
                                          'field'    => 'name',
                                          'terms'    => 'featured',
                                          'operator' => 'IN',
                                      );
                                  }
                                  $products = new \WP_Query( $args );

                                  if( $products->have_posts() ):
                                  ?>
                              <?php endif; endforeach;?>
                          <?php else:?>
                          <?php 			
                          $k=1;
                          if( $products->have_posts() ):
                              while( $products->have_posts() ): $products->the_post(); ?>
                                  <a class="<?php
                                  if( 2 == $per_page ):
                                          echo 'per_page_2';
                                      elseif( 3 == $per_page ):
                                          echo 'per_page_3';
                                      elseif( 4 == $per_page ):
                                          echo 'per_page_4';
                                  endif;
                                  ?>" href="<?php echo get_permalink() ?>"><?php the_post_thumbnail( 'medium_large' ); ?></a>
                                  <?php
                                $k++; endwhile; wp_reset_postdata();
                                wp_reset_postdata();
                              endif;
                        endif;
                                ?>                                   
                            </div>
                            </div>
                            <footer>
                                <a style="color:<?php echo $settings['background_color_code_self']; ?>" href="<?php echo $item['website_link_cat']['url']; ?>"><?php echo $item['list_title_cat_two']; ?></a>
                            </footer>
                        </article>
                    </div>
                </div>

                <?php
                }
             } ?>

			</div>
    </div>
    </div>
        </div>
        </section>
		<?php
        
	}

}