import requests
import json
import environ
from mysgi_middleware.settings.base import BASE_DIR
import os
from .models import EtsPeriods, EtsWorkingYears
from django.db import transaction
from khayyam import JalaliDate
from datetime import datetime
from io import BytesIO
import base64


env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))


class ETS:
    
    def __init__(self, personnel_code):
        self.personnel_code = personnel_code
        

    def ets_login(self):
        response = requests.post(url=env('ETS_API_URL')+'/api/Auth/LoginForApi', headers={'Content-Type': 'application/json','Accept': 'application/json'}, json={'Username': self.personnel_code,'Password': '2','CaptchaText': 'string','IsFromLocalStorage': True,'LoginType': 0,'IsFromMobile': True,'Otp': 'string'})
        res = response.json()
        if res['Message'] == "ورود با موفقیت انجام شد":
            last =dict()
            ets_access = res['Data']['AuthInfo']['AccessToken']
            ets_refresh = res['Data']['AuthInfo']['RefreshToken']
            ets_system_id = res['Data']['UserInfo']['BusinessPartnerId']
            last['ets_access'] = ets_access
            last['ets_refresh'] = ets_refresh
            last['ets_bpid'] = ets_system_id
            return True, last
        else:
            return False, None


    def get_calender(self):
        ans, res = self.ets_login()
        if ans:
            last_ans = res
            headers = {
                'Accept': 'application/json',
                'apiKey': res['ets_access'],
                'Authorization': 'ETSBearer '+res['ets_access']
            }
            current_working_year = EtsWorkingYears.objects.get(is_default=True)
            current_working_id = str(current_working_year.id)
            print(JalaliDate.today().day)
            if JalaliDate.today().day > 20:
                period = "دوره "+str(JalaliDate.today().month + 1)
            else:
                period = "دوره "+str(JalaliDate.today().month)
            current_period = EtsPeriods.objects.filter(working_year_id=current_working_id, name=period).values_list('id', flat=True)
            print(current_period[0])
            response = requests.get(url=env('ETS_API_URL')+'/api/DailyCalculationInfo/GetDailyCalculationShowData?employeeId='+str(res["ets_bpid"])+'&periodId='+str(current_period[0]), headers=headers)
            datas = response.json()
            last_ans['datas'] = datas
            return True, last_ans
        else:
            return False, "Authorization Error"


    def update_working_year(self):
        
        ans,res = self.ets_login()
        if ans:
            headers = {
                'Accept': 'application/json',
                'apiKey': res['ets_access'],
                'Authorization': 'ETSBearer '+res['ets_access']
            }
            response = requests.get(url=env('ETS_API_URL')+'/api/DailyCalculationInfo/GetWorkingYears?employeeId='+str(115), headers=headers)
            data = response.json()
            data = data['Data']
            try:
                with transaction.atomic():
                    for one_year in data:
                        if EtsWorkingYears.objects.filter(id=one_year['Id']).count() == 0:
                            working_obj = EtsWorkingYears.objects.create(id=one_year['Id'], name=one_year['Name'], is_default=one_year['IsDefultYear'])
                            periods = one_year['Periods']
                            for one_period in periods:
                                EtsPeriods.objects.create(id=one_period['Id'], name=one_period['Name'], working_year_id=working_obj.id)
                return [True, 'داده ها وارد شد']
            except Exception as e:
                transaction.rollback()
                return [False, 'ارور رخ داده است']
        else:
            return False, "Authorization Error"

    
    def get_periods(self):
        ans, res = self.ets_login()
        if ans:
            last_ans = res
            headers = {
                'Accept': 'application/json',
                'apiKey': res['ets_access'],
                'Authorization': 'ETSBearer '+res['ets_access']
            }
            response = requests.get(url=env('ETS_API_URL')+'/api/DailyCalculationInfo/GetWorkingYears?employeeId='+str(res["ets_bpid"]), headers=headers)
            datas = response.json()
            last_ans['datas'] = datas
            return True, last_ans
        else:
            return False, "Authorization Error"
    

    def get_archives(self, start_date, end_date, req_state):
        ans, res = self.ets_login()
        if ans:
            last_ans = res
            headers = {
                'Accept': 'application/json',
                'apiKey': res['ets_access'],
                'Authorization': 'ETSBearer '+res['ets_access']
            }
            
            if req_state is None:
                # url = env('ETS_API_URL')+'/api/IORequest/GetIoSheetsArchive?employeeId='+str(res["ets_bpid"])+'&fromDate='+str(start_date)+'&toDate='+str(end_date)
                url = "http://172.16.20.162:8095/api/IORequest/GetIoSheetsArchive?employeeId=166&fromDate=2024%2F06%2F25&toDate=2024%2F07%2F15&requestState=0"
                print(url)
                params = {
                    'employeeId': res["ets_bpid"],
                    'fromDate': str(start_date),
                    'toDate': str(end_date),
                }
                response = requests.get(
                    url=url,
                    headers=headers,
                    # params=params
                )
            else:
                params = {
                    'employeeId': res["ets_bpid"],
                    'fromDate': str(start_date),
                    'toDate': str(end_date),
                    'requestState': req_state
                }
                response = requests.get(
                    url=url,
                    headers=headers,
                    params=params
                )
            if response.status_code == 200:
                datas = response.json()
                last_ans['datas'] = datas['Data']
                return True, last_ans
            else:
                return False, "Error On Getting Datas"
            
        else:
            return False, "Authorization Error"


    def add_io_request(self, validated_data, personnel_code, request):
        ans, res = self.ets_login()
        if ans:
            last_ans = res
            if validated_data['request_type'] == 'true' or validated_data['request_type'] == True:
                reqtype = 1
            else:
                reqtype = 0

            # Get today's date in the required format
            today_date = validated_data['request_datetime'].strftime('%Y/%m/%d %H:%M')

            url = env('ETS_API_URL')+'/api/IORequest/AddIoSheet'
            headers = {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'apiKey': res['ets_access'],
                'Authorization': 'ETSBearer '+res['ets_access']
            }

            data = {
                "IoRecordRegistrationId": 0,
                "DateTime": today_date,
                "Type": reqtype,
                "Description": validated_data["request_description"],
                "RequestReason": validated_data["request_reason"],
                "PersistBy": 0,
                "PersistByMe": True,
                "AttachmentImageBase64": validated_data["attachments"],
                "Employees": [
                    {
                        "Key": res['bpid'],
                        "Value": str(personnel_code)
                    }
                ]
            }
            response = requests.post(url, headers=headers, data=json.dumps(data))
            if response.status_code == 200:
                datas = response.json()
                last_ans['datas'] = datas['Message']
                return True, last_ans
            else:
                return False, "Error On Getting Datas"
        else:
            return False, "Authorization Error"


    def edit_io_request(self, validated_data, personnel_code, request, id):
        ans, res = self.ets_login()
        if ans:
            last_ans = res
            if validated_data['request_type'] == 'true' or validated_data['request_type'] == True:
                reqtype = 1
            else:
                reqtype = 0

            # Get today's date in the required format
            today_date = validated_data['request_datetime'].strftime('%Y/%m/%d %H:%M')

            url = env('ETS_API_URL')+'/api/IORequest/ModifyIoSheet'
            headers = {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'apiKey': res['ets_access'],
                'Authorization': 'ETSBearer '+res['ets_access']
            }

            data = {
                "IoRecordRegistrationId": id,
                "DateTime": today_date,
                "Type": reqtype,
                "Description": validated_data["request_description"],
                "RequestReason": validated_data["request_reason"],
                "PersistBy": 0,
                "PersistByMe": True,
                "AttachmentImageBase64": validated_data["attachments"],
                "Employees": [
                    {
                        "Key": res['bpid'],
                        "Value": str(personnel_code)
                    }
                ]
            }
            response = requests.post(url, headers=headers, data=json.dumps(data))
            if response.status_code == 200:
                datas = response.json()
                last_ans['datas'] = datas['Message']
                return True, last_ans
            else:
                return False, "Error On Getting Datas"
        else:
            return False, "Authorization Error"


