<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class VOD_VIDEO_ADMIN
{

    public static function GetList($token, $folderid)
    {
        /**
         *   دریافت لیست ویدئوها براساسفولدر
         * 
         *   ورودی : 
         *              string Token
         *              string folderid
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    data   : اطلاعات دامنه کاربر
         */
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];

        if (VOD_FOLDERS_ADMIN::UserCanAccessToFolder($uid, $folderid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید", "code" => "302"];
        }


        //         0-waiting for download
        // 1-downloading
        // 2-downloded
        // 3-pending for convert
        // 4- converting
        // 5-converted
        $sql = "SELECT vvid as VideoID,vv_name as VideoName,vv_framerate as FrameRate,
                       vv_hls as HLS,vv_hls_rates as HLSResolution,vv_dash as DASH,vv_dash_rate as DASHResolution,
                       vv_mp4 as MP4,vv_mp4_rate as MP4Resolution,vv_watermark as WaterMark,vv_watermark_image as WaterMarkImage,
                       watermark_position as WaterMarkImagePostition,vv_url as FileName,vv_thtime as ThumbnailImage,
                       vv_subtitle as SubTitle,vv_subtitle_files as SubTitleFiles,vv_referer as RefererWebsites,
                       vv_length as VideoLength, vv_status as VideoStatus,vv_hls_audio_bitrate as HLSAudioBitRate,
                       vv_mp4_audio_bitrate as MP4AudioBitRate,vv_dash_audio_bitrate as DASHAudioBitRate,
                       CASE
                    WHEN " . $GLOBALS['vv_status'] . "=0 THEN  'waiting for download'
                    WHEN " . $GLOBALS['vv_status'] . "=1 THEN  'downloading'
                    WHEN " . $GLOBALS['vv_status'] . "=2 THEN  'downloded'
                    WHEN " . $GLOBALS['vv_status'] . "=3 THEN  'pending for convert'
                    WHEN " . $GLOBALS['vv_status'] . "=4 THEN  'converting'
                    WHEN " . $GLOBALS['vv_status'] . "=5 THEN  'converted'
            END as Video_Status ,vv_percent  
                from " . $GLOBALS["vod_video_tablename"] . " WHERE " . $GLOBALS['vv_vfid_fk'] . "=" . $folderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "شما ویدئویی در این فولدر ندارید",
            ];
            return $result;
        }
        return $sql;

        $resHLLSResolution = explode(",", $res[0]["HLSResolution"]);
        $outresHLLSResolution = [];
        foreach ($resHLLSResolution as $l) {
            array_push($outresHLLSResolution, $l);
        }
        $res[0]["HLSResolution"] = $outresHLLSResolution;

        $resDASHResolution = explode(",", $res[0]["DASHResolution"]);
        $outresDASHResolution = [];
        foreach ($resDASHResolution as $l) {
            array_push($outresDASHResolution, $l);
        }
        $res[0]["DASHResolution"] = $outresDASHResolution;

        $resMP4Resolution = explode(",", $res[0]["MP4Resolution"]);
        $outresMP4Resolution = [];
        foreach ($resMP4Resolution as $l) {
            array_push($outresMP4Resolution, $l);
        }
        $res[0]["MP4Resolution"] = $outresMP4Resolution;

        $arrSubtitleFiles = explode(",", $res[0]["SubTitleFiles"]);
        $outputarrSubtitleFiles = [];
        foreach ($arrSubtitleFiles as $l) {
            $name = explode(".", $l)[0];
            array_push($outputarrSubtitleFiles, ["name" => $l]);
        }
        $res[0]["SubTitleFiles"] = $outputarrSubtitleFiles;

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "شما ویدئویی در این فولدر ندارید",
            ];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $res];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOne($token, $videoid, $fid)
    {
        /**
         *   دریافت یک  ویدئوها براساس فولدر
         * 
         *   ورودی : 
         *              string Token
         *              int videoid
         *              int folderid
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    data   : اطلاعات دامنه کاربر
         */
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];

        if (VOD_FOLDERS_ADMIN::UserCanAccessToFolder($uid, $fid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید", "code" => "302"];
        }

        $sql = "SELECT vvid as VideoID,vv_name as VideoName,vv_framerate as FrameRate,
        vv_hls as HLS,vv_hls_rates as HLSResolution,vv_dash as DASH,vv_dash_rate as DASHResolution,
        vv_mp4 as MP4,vv_mp4_rate as MP4Resolution,vv_watermark as WaterMark,vv_watermark_image as WaterMarkImage,
        watermark_position as WaterMarkImagePostition,vv_url as FileName,vv_thtime as ThumbnailImage,
        vv_subtitle as SubTitle,vv_subtitle_files as SubTitleFiles,vv_referer as RefererWebsites,
        vv_length as VideoLength, vv_status as VideoStatus,vv_hls_audio_bitrate as HLSAudioBitRate,
        vv_mp4_audio_bitrate as MP4AudioBitRate,vv_dash_audio_bitrate as DASHAudioBitRate,
        CASE
                    WHEN " . $GLOBALS['vv_status'] . "=0 THEN  'waiting for download'
                    WHEN " . $GLOBALS['vv_status'] . "=1 THEN  'downloading'
                    WHEN " . $GLOBALS['vv_status'] . "=2 THEN  'downloded'
                    WHEN " . $GLOBALS['vv_status'] . "=3 THEN  'pending for convert'
                    WHEN " . $GLOBALS['vv_status'] . "=4 THEN  'converting'
                    WHEN " . $GLOBALS['vv_status'] . "=5 THEN  'converted'
            END as Video_Status ,vv_percent 
                                 from " . $GLOBALS["vod_video_tablename"] . " WHERE " . $GLOBALS['vvid'] . "=" . $videoid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "شما ویدئویی در این فولدر ندارید",
            ];
            return $result;
        }
        if (strpos($res[0]["HLSResolution"], ",")) {

            $resHLLSResolution = explode(",", $res[0]["HLSResolution"]);
            $outresHLLSResolution = [];
            foreach ($resHLLSResolution as $l) {
                array_push($outresHLLSResolution, $l);
            }
            $res[0]["HLSResolution"] = $outresHLLSResolution;
        }
        if (strpos($res[0]["DASHResolution"], ",")) {

            $resDASHResolution = explode(",", $res[0]["DASHResolution"]);
            $outresDASHResolution = [];
            foreach ($resDASHResolution as $l) {
                array_push($outresDASHResolution, $l);
            }
            $res[0]["DASHResolution"] = $outresDASHResolution;
        }
        if (strpos($res[0]["MP4Resolution"], ",")) {
            $resMP4Resolution = explode(",", $res[0]["MP4Resolution"]);
            $outresMP4Resolution = [];
            foreach ($resMP4Resolution as $l) {
                array_push($outresMP4Resolution, $l);
            }
            $res[0]["MP4Resolution"] = $outresMP4Resolution;
        }

        $arrSubtitleFiles = explode(",", $res[0]["SubTitleFiles"]);
        $outputarrSubtitleFiles = [];
        foreach ($arrSubtitleFiles as $l) {
            $name = explode(".", $l)[0];
            array_push($outputarrSubtitleFiles, ["name" => $l]);
        }
        $res[0]["SubTitleFiles"] = $outputarrSubtitleFiles;
        if ($res[0]["HLS"] == "false") {
            $res[0]["HLSResolution"] = "null";
        }
        if ($res[0]["DASH"] == "false") {
            $res[0]["DASHResolution"] = "null";
        }
        if ($res[0]["MP4"] == "false") {
            $res[0]["MP4Resolution"] = "null";
        }

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "شما ویدئویی در این فولدر ندارید",
            ];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $res];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetAll($token)
    {
        /**
         *   دریافت یک  ویدئوها براساس فولدر
         * 
         *   ورودی : 
         *              string Token
         *              int videoid
         *              int folderid
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    data   : اطلاعات دامنه کاربر
         */
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];

        if (VOD_FOLDERS_ADMIN::UserCanAccessToFolder($uid, $fid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید", "code" => "302"];
        }

        $sql = "SELECT vvid as VideoID,vv_name as VideoName,vv_framerate as FrameRate,
        vv_hls as HLS,vv_hls_rates as HLSResolution,vv_dash as DASH,vv_dash_rate as DASHResolution,
        vv_mp4 as MP4,vv_mp4_rate as MP4Resolution,vv_watermark as WaterMark,vv_watermark_image as WaterMarkImage,
        watermark_position as WaterMarkImagePostition,vv_url as FileName,vv_thtime as ThumbnailImage,
        vv_subtitle as SubTitle,vv_subtitle_files as SubTitleFiles,vv_referer as RefererWebsites,
        vv_length as VideoLength, vv_status as VideoStatus,vv_hls_audio_bitrate as HLSAudioBitRate,
        vv_mp4_audio_bitrate as MP4AudioBitRate,vv_dash_audio_bitrate as DASHAudioBitRate,
        CASE
                    WHEN " . $GLOBALS['vv_status'] . "=0 THEN  'waiting for download'
                    WHEN " . $GLOBALS['vv_status'] . "=1 THEN  'downloading'
                    WHEN " . $GLOBALS['vv_status'] . "=2 THEN  'downloded'
                    WHEN " . $GLOBALS['vv_status'] . "=3 THEN  'pending for convert'
                    WHEN " . $GLOBALS['vv_status'] . "=4 THEN  'converting'
                    WHEN " . $GLOBALS['vv_status'] . "=5 THEN  'converted'
            END as Video_Status ,vv_percent 
                                 from " . $GLOBALS["vod_video_tablename"] . " WHERE " . $GLOBALS['vvid'] . "=" . $videoid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "شما ویدئویی در این فولدر ندارید",
            ];
            return $result;
        }
        if (strpos($res[0]["HLSResolution"], ",")) {

            $resHLLSResolution = explode(",", $res[0]["HLSResolution"]);
            $outresHLLSResolution = [];
            foreach ($resHLLSResolution as $l) {
                array_push($outresHLLSResolution, $l);
            }
            $res[0]["HLSResolution"] = $outresHLLSResolution;
        }
        if (strpos($res[0]["DASHResolution"], ",")) {

            $resDASHResolution = explode(",", $res[0]["DASHResolution"]);
            $outresDASHResolution = [];
            foreach ($resDASHResolution as $l) {
                array_push($outresDASHResolution, $l);
            }
            $res[0]["DASHResolution"] = $outresDASHResolution;
        }
        if (strpos($res[0]["MP4Resolution"], ",")) {
            $resMP4Resolution = explode(",", $res[0]["MP4Resolution"]);
            $outresMP4Resolution = [];
            foreach ($resMP4Resolution as $l) {
                array_push($outresMP4Resolution, $l);
            }
            $res[0]["MP4Resolution"] = $outresMP4Resolution;
        }

        $arrSubtitleFiles = explode(",", $res[0]["SubTitleFiles"]);
        $outputarrSubtitleFiles = [];
        foreach ($arrSubtitleFiles as $l) {
            $name = explode(".", $l)[0];
            array_push($outputarrSubtitleFiles, ["name" => $l]);
        }
        $res[0]["SubTitleFiles"] = $outputarrSubtitleFiles;
        if ($res[0]["HLS"] == "false") {
            $res[0]["HLSResolution"] = "null";
        }
        if ($res[0]["DASH"] == "false") {
            $res[0]["DASHResolution"] = "null";
        }
        if ($res[0]["MP4"] == "false") {
            $res[0]["MP4Resolution"] = "null";
        }

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "شما ویدئویی در این فولدر ندارید",
            ];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $res];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedName($name)
    {

        $sql = "SELECT * FROM " . $GLOBALS["vod_domain_tablename"] . " WHERE " . $GLOBALS['vdname'] . "='" . $name . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function UploadFileSubtitle($subtitlefile, $domain)
    {
        /**
         *  آپلود فایل زیر نویس
         * 
         *   ورودی : 
         *              string Token
         *              int videoid
         *              int folderid
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    data   : اطلاعات دامنه کاربر
         */
        $resp = [];

        $files = array_filter($subtitlefile['name']);
        $total_count = count($subtitlefile['name']);

        for ($i = 0; $i < $total_count; $i++) {

            $dirs = array_filter(glob($GLOBALS["RootFiles"] . '/attachments/video/*'), 'is_dir');
            $isDirectoryExist = false;
            foreach ($dirs as $drs) {
                $exp = explode("/", $drs);

                if ($domain == $exp[count($exp) - 1]) {
                    $isDirectoryExist = true;
                }
            }
            $FilePath = $GLOBALS["RootFiles"] . '/attachments/video/' . $domain;
            if (!$isDirectoryExist)
                mkdir($FilePath);

            $size   =   $subtitlefile["size"][$i];
            $name   =   $subtitlefile["name"][$i];
            $ext    =   pathinfo($name, PATHINFO_EXTENSION);
            $allowed = array('srt');

            $uploadName =  $name . "." . $ext;
            $output = $FilePath;
            if (in_array($ext, $allowed)) {
                if ((number_format($size / 1048576, 2)) > 160) {
                    $response = [
                        "status" => "error", "message" => "حداکثر حجم فایل برای آپلود 4مگابایت است",
                        "filename" => $name
                    ];
                } else {
                    if (move_uploaded_file($subtitlefile["tmp_name"][$i], $output . '/' . $uploadName)) {
                        $response = ["status" => "success"];
                    } else {
                        $response = [
                            "status" => "error", "message" => "خطا در آپلود فایل لطفا دقایقی دیگر بررسی نمایید",
                            "filename" => $name
                        ];
                    }
                }
            } else {
                $response = ["status" => "error", "message" => "فرمت فایل ارسالی نامعتبر است ", "filename" => $name];
            }
            array_push($resp, $response);
        }
        return $resp;
    }
    public static function UploadWaterMark($subtitlefile, $filename, $domain)
    {
        /**
         *  آپلود فایل واترمارک 
         * 
         *   ورودی : 
         *              string filename
         *              Files subtitlefile
         *              int domain
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    data   : اطلاعات دامنه کاربر
         */
        $resp = [];

        $dirs = array_filter(glob($GLOBALS["RootFiles"] . '/attachments/video/*'), 'is_dir');
        $isDirectoryExist = false;
        foreach ($dirs as $drs) {
            $exp = explode("/", $drs);

            if ($domain == $exp[count($exp) - 1]) {
                $isDirectoryExist = true;
            }
        }
        $FilePath = $GLOBALS["RootFiles"] . '/attachments/video/' . $domain;
        if (!$isDirectoryExist)
            mkdir($FilePath);

        $size   =   $subtitlefile["size"];
        $name   =   $subtitlefile["name"];
        $ext    =   pathinfo($name, PATHINFO_EXTENSION);
        $allowed = array('jpg', 'png', 'jpeg');

        $uploadName =  $filename . "." . $ext;
        $output = $FilePath;
        if (in_array($ext, $allowed)) {
            if ((number_format($size / 1048576, 2)) > 160) {
                $response = [
                    "status" => "error", "message" => "حداکثر حجم فایل برای آپلود 4مگابایت است",
                    "filename" => $name
                ];
            } else {
                if (move_uploaded_file($subtitlefile["tmp_name"], $output . '/' . $uploadName)) {
                    $response = ["status" => "success"];
                } else {
                    $response = [
                        "status" => "error", "message" => "خطا در آپلود فایل لطفا دقایقی دیگر بررسی نمایید",
                        "filename" => $name
                    ];
                }
            }
        } else {
            $response = ["status" => "error", "message" => "فرمت فایل ارسالی نامعتبر است ", "filename" => $name];
        }
        return $response;
    }
    public static function GetStatusFromBackend($vid, $status, $percent)
    {
        $sql = "UPDATE " . $GLOBALS['vod_video_tablename'] . " SET " .
            $GLOBALS['vv_progress'] . "=" . $percent . " ," . $GLOBALS['vv_status'] . "=" . $status . " where " .
            $GLOBALS['vvid'] . "=" . $vid;
        $conn = GetConnection();
        $conn->query($sql);

        $conn->close();
    }
    public static function AddVideoWithLink(
        $token,
        $domainid,
        $framerate,
        $hls,
        $hlsresolution,
        $dash,
        $dashresolution,
        $mp4,
        $mp4resolution,
        $watermark,
        $watermarkimage,
        $watermarkposition,
        $url,
        $thtime,
        $subtitile,
        $subtitlefiles,
        $referer,
        $folderid,
        $length
    ) {
        /**
         *   آپلود ویدئو با لینک
         * 
         *   ورودی : 
         *              string $token,
         *              int domaindid,
         *              int $framerate,
         *              int $hls,
         *              string $hlsresolution,
         *              int $dash,
         *              string $dashresolution,
         *              int $mp4,
         *              string $mp4resolution,
         *              int $watermark,
         *              int $watermarkimage,
         *              string $watermarkposition,
         *              string $url,
         *              string $thtime,
         *              int $subtitile,
         *              int $subtitlefiles,
         *              string $referer,
         *              int $folderid,
         *              string $length
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    data   : اطلاعات دامنه کاربر
         */

        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];

        if (VOD_DOMAIN_ADMIN::UserCanAccessToStreamDomain($uid, $domainid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
        }

        $lv = VOD_FOLDERS_ADMIN::UserCanAccessToFolder($uid, $folderid);
        if ($lv["status"] == "error") {
            return ["status" => "error", "message" => "شما امکان آپلود ویدئو در روت را ندارید"];
        }

        if (!in_array($framerate, range(24, 30))) {
            return ["status" => "error", "message" => "ّframe rate  ارسالی شما نامعتبر است شما میتوانید از رنج 24  تا 30 انتخاب نمایید"];
        }
        $hlsOrDashStatus = ["true", "false"];
        $resolution = ["360", "480", "720", "1080"];
        if (!in_array($hls, $hlsOrDashStatus)) {
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس HLS اشتباه است"];
        }
        if (!in_array($dash, $hlsOrDashStatus)) {
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس HLS اشتباه است"];
        }
        $hlsRes = [];
        if ($hls == "true") {
            $hlsRes = explode(",", $hlsresolution);
            if (count($hlsRes) == 0) {
                return ["status" => "error", "message" => "ّشما مقداری برای Resolution HLS ارسال نکرده اید"];
            } else {
                foreach ($hlsRes as $m) {

                    if (!in_array($m, $resolution)) {
                        return ["status" => "error", "message" => "ّمقدار ارسالی برای Resolution HLS اشتباه است ", "HLS-Resolution" => $m];
                    }
                }
            }
        } else {
            $hlsresolution = "";
        }
        $dashRes = [];

        if ($dash == "true") {
            $dashRes = explode(",", $dashresolution);
            if (count($dashRes) == 0) {
                return ["status" => "error", "message" => "ّشما مقداری برای Resolution DASH ارسال نکرده اید"];
            } else {
                foreach ($dashRes as $m) {
                    if (!in_array($m, $resolution)) {
                        return ["status" => "error", "message" => "ّمقدار ارسالی برای Resolution DASH اشتباه است ", "DASH-Resolution" => $m];
                    }
                }
            }
        } else {
            $dashresolution = "";
        }
        $MP4Res = [];

        if ($mp4 == "true") {
            $MP4Res = explode(",", $mp4resolution);
            if (count($MP4Res) == 0) {
                return ["status" => "error", "message" => "ّشما مقداری برای Resolution MP4 ارسال نکرده اید"];
            } else {
                foreach ($MP4Res as $m) {
                    if (!in_array($m, $resolution)) {
                        return ["status" => "error", "message" => "ّمقدار ارسالی برای Resolution MP4 اشتباه است ", "MP4-Resolution" => $m];
                    }
                }
            }
        } else {
            $mp4resolution = "";
        }
        $watermarkPostitionArray = ["middlepage", "topleft", "topright", "bottomright", "bottomleft"];

        if ($watermark == "true") {
            //  $uploadWaterMark= VOD_VIDEO_ADMIN::UploadWaterMark($watermarkimage, "abc", $lv["data"][0]["vdname"]);
            // if($uploadWaterMark["status"]=="error")
            // return $uploadWaterMark;

            if (VOD_WATERMARK_ADMIN::GetOne($token, $watermarkimage, $domainid)["status"] == "error") {
                return ["status" => "error", "message" => "واترمارک ارسالی اشتباه است"];
            }
            if (!in_array($watermarkposition, $watermarkPostitionArray)) {
                return ["status" => "error", "message" => "مکان قرار گیری برای watermark اشتباه درج شده است"];
            }
        }
        if ($subtitile == "true") {
            //    $uploadsubtitle= VOD_VIDEO_ADMIN::UploadFileSubtitle($subtitlefiles,  $lv["data"][0]["vdname"]);

            //  if($uploadsubtitle["status"]=="error")
            //   return $uploadsubtitle;
        }
        $validformat = ["avi", "mp4", "flv", "mkv", "mov"];
        $extensionfile = substr($url, -3);
        if (!in_array($extensionfile, $validformat)) {
            return ["status" => "error", "message" => "پسوند فایل ارسالی شما اشتباه است"];
        }
        //if (!VOD_VIDEO_ADMIN::does_url_exists($url)) {
        //    return ["status" => "error", "message" => "لینک ارسالی شما اشتباه است"];
        //}
        if (!preg_match("/^([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$/", $thtime)) {
            return ["status" => "error", "message" => "فرمت زمان ارسالی شما اشتباه است"];
        }

        $r = explode(",", $referer);
        foreach ($r as $l) {
            if (!filter_var($l, FILTER_VALIDATE_URL)) {
                return ["status" => "error", "message" => "آدرس ارسالی اشتباه است ", "url" => $l];
            }
        }
        // $getID3 = new getID3;
        $file_name = basename($url);
        // if(file_put_contents($GLOBALS["RootFiles"] . "/attachments/safestorage/". $file_name,file_get_contents($url))) {
        //     }
        //     else {
        //         return ["status" => "error", "message" => "فایل درخواستی شما قابل دانلود نیست"];

        //     }

        // $file = $getID3->analyze($GLOBALS["RootFiles"] . "/attachments/safestorage/". $file_name);
        // $c=explode(":",$file['playtime_string']);
        // if(count($c)==2){
        //     $file['playtime_string']="00:".$file['playtime_string'];
        //     if(strlen($c[0])==1){
        //         $file['playtime_string']="00:0".$c[0].":".$c[1];
        //     }
        // }

        // if($file['playtime_string'] < $thtime){
        //     unlink($GLOBALS["RootFiles"] . "/attachments/safestorage/". $file_name);
        //     return ["status" => "error", "message" => "زمان درخواستی شما برای کاور ویدئو از زمان  ویدئو بیشتر است"];
        // }
        $domain = $lv["data"][0]["vdname"];
        // $dirs = array_filter(glob($GLOBALS["RootFiles"] . '/attachments/video/*'), 'is_dir');
        //     $isDirectoryExist = false;
        //     foreach ($dirs as $drs) {
        //         $exp = explode("/", $drs);

        //         if ($domain == $exp[count($exp) - 1]) {
        //             $isDirectoryExist = true;
        //         }
        //     }
        //     $FilePath = $GLOBALS["RootFiles"] . '/attachments/video/' .$domain;
        //     if (!$isDirectoryExist)
        //         mkdir($FilePath);

        //         $currentFilePath=$GLOBALS["RootFiles"] . "/attachments/safestorage/". $file_name;
        //         $newFilePath=$GLOBALS["RootFiles"] . '/attachments/video/' .$domain."/". $file_name;
        // rename($currentFilePath, $newFilePath);

        // $token, $framerate, $hls, $hlsresolution, $dash, $dashresolution, $mp4, $mp4resolution, $watermark, $watermarkimage, $watermarkposition, $url,
        // $thtime, $subtitile, $subtitlefiles, $referer, $folderid
        $hlsbitrate = [];
        $dashbitrate = [];
        $mp4bitrate = [];

        $hlsaudiobitrate = [];
        $dashaudiobitrate = [];
        $mp4audiobitrate = [];

        $bitrateRes = ["360" => "350", "480" => "800", "720" => "1200", "1080" => "1900"];
        $AudiobitrateRes = ["360" => "64", "480" => "128", "720" => "192", "1080" => "320"];

        $bitrate = [];

        $arrHLSresolution = explode(",", $hlsresolution);
        $arrDASHresolution = explode(",", $dashresolution);
        $arrMP4resolution = explode(",", $mp4resolution);

        foreach ($arrHLSresolution as $l) {
            array_push($hlsbitrate, $bitrateRes[$l]);
            array_push($hlsaudiobitrate, $AudiobitrateRes[$l]);
        }

        foreach ($arrDASHresolution as $l) {
            array_push($dashbitrate, $bitrateRes[$l]);
            array_push($dashaudiobitrate, $AudiobitrateRes[$l]);
        }

        foreach ($arrMP4resolution as $l) {
            array_push($mp4bitrate, $bitrateRes[$l]);
            array_push($mp4audiobitrate, $AudiobitrateRes[$l]);
        }

        $outHLSbitrate = implode(",", $hlsbitrate);
        $outDASHbitrate = implode(",", $dashbitrate);
        $ouMP4bitrate = implode(",", $mp4bitrate);

        $outAudioHLSbitrate = implode(",", $hlsaudiobitrate);
        $outAudioDASHbitrate = implode(",", $dashaudiobitrate);
        $ouAudioMP4bitrate = implode(",", $mp4audiobitrate);

        $sql = "INSERT INTO " . $GLOBALS['vod_video_tablename'] . "(" . $GLOBALS['vv_name'] . "," . $GLOBALS['vv_framerate'] . "," . $GLOBALS['vv_resolution'] . "," . $GLOBALS['vv_hls'] . "," . $GLOBALS['vv_hls_rates'] . "," .
            $GLOBALS['vv_dash'] . "," . $GLOBALS['vv_dash_rate'] . "," . $GLOBALS['vv_mp4'] . "," . $GLOBALS['vv_mp4_rate'] . "," . $GLOBALS['vv_watermark'] . "," . $GLOBALS['vv_watermark_image'] . "," .
            $GLOBALS['watermark_position'] . "," . $GLOBALS['vv_url'] . "," . $GLOBALS['vv_thtime'] . "," . $GLOBALS['vv_subtitle'] . "," . $GLOBALS['vv_subtitle_files'] . "," . $GLOBALS['vv_referer'] . "," .
            $GLOBALS['vv_vfid_fk'] . "," . $GLOBALS['vv_length'] . "," . $GLOBALS['vv_status'] . "," . $GLOBALS['vv_hls_bitrate'] . "," . $GLOBALS['vv_dash_bitrate'] . "," .
            $GLOBALS['vv_mp4_bitrate'] . "," . $GLOBALS['vv_hls_audio_bitrate'] . "," . $GLOBALS['vv_dash_audio_bitrate'] . "," . $GLOBALS['vv_mp4_audio_bitrate'] . "" . $GLOBALS['vv_progress'] . ") VALUES('" . $file_name . "','" . $framerate . "','','" . $hls . "','" .
            $hlsresolution . "','" . $dash . "','" . $dashresolution . "','" . $mp4 . "','" . $mp4resolution . "','" . $watermark . "','" . basename($watermarkimage) . "','" . $watermarkposition . "','" . $file_name . "','" . $thtime . "','" . $subtitile . "','" .
            $subtitlefiles . "','" . $referer . "','" . $folderid . "','" . $length . "',0,'" . $outHLSbitrate . "','" . $outDASHbitrate . "','" . $ouMP4bitrate . "','" . $outAudioHLSbitrate . "','" . $outAudioDASHbitrate . "','" . $ouAudioMP4bitrate . "','0')";
        $conn = GetConnection();
        $conn->query($sql);

        $conn->close();

        return ["status" => "success", "message" => "ویدئو شما با موفقیت دریافت شد و در حال پردازش است"];
    }
    public static function does_url_exists($url)
    {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($code == 200) {
            $status = true;
        } else {
            $status = false;
        }
        curl_close($ch);
        return $status;
    }

    public static function UserCanAccessToVideo($uid, $vid)
    {
        $sql = "SELECT * FROM
                tbl_vod_domain,`tbl_vod_video`,tbl_vod_folders
                WHERE `vv_vfid_fk`= vfid and
                vf_cidfk= vdid and

                vd_uid_fk=" . $uid . " AND vvid=" . $vid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "شما اجازه دسترسی به این ویدئو را ندارید ",
            ];
            return $result;
        } else {
            $d = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $d];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneVideo($token, $vid)
    {
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];
        return VOD_VIDEO_ADMIN::UserCanAccessToVideo($uid, $vid);
    }
    public static function RemoveVideo($token, $vid)
    {
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];
        $vc = VOD_VIDEO_ADMIN::UserCanAccessToVideo($uid, $vid);
        if ($vc["status"] == "error") {
            return $vc;
        } else {
            $folderServerPath = VOD_FOLDERS_ADMIN::GetFolderAndUpFolders($vc["data"][0]["vfid"], "", 0);
            $sql = "DELETE FROM " .
                $GLOBALS['vod_video_tablename'] . " WHERE " . $GLOBALS['vvid'] . "=" . $vid;
            $conn = GetConnection();
            $conn->query($sql);
            return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        }
    }
    public static  function  GetListByFolder($token, $fid)
    {
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];
        $sql = "SELECT * FROM
            tbl_vod_domain,`tbl_vod_video`,tbl_vod_folders
            WHERE `vv_vfid_fk`= vfid and
            tbl_vod_domain.vdid=tbl_vod_folders.vf_cidfk and
                vd_uid_fk=" . $uid . " AND vfid=" . $fid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error", "message" => "در این فولدر ویدئویی آپلود نشده است ",
            ];
            return $result;
        } else {
            $d = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $d];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
}
