<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';



class VOD_FOLDERS_ADMIN
{


    public static function findParent(&$array, $parentid = 0, $childarray = [])
    {
        /***
         * ایجاد لیست فولدرها و زیر فولدرها
         */
        foreach ($array as $i => &$row) {                         // make $row modifiable
            if ($parentid) {                                    // if not zero
                if ($row['vfid'] == $parentid) {                    // found parent
                    $row['nodes'][] = $childarray;              // append child to parent's nodes subarray
                } elseif (isset($row['nodes'])) {                // go down rabbit hole looking for parent
                    VOD_FOLDERS_ADMIN::findParent($row['nodes'], $parentid, $childarray);  // look deeper for parent while preserving the initial parent_id and row
                }                                             // else continue;
            } elseif ($row['vf_parentid']) {                       // child requires adoption
                unset($array[$i]);                            // remove child from level because it will be store elsewhere and won't be its own parent (reduce iterations in next loop & avoid infinite recursion)
                VOD_FOLDERS_ADMIN::findParent($array, $row['vf_parentid'], $row);    // look for parent using parent_id while carrying the entire row as the childarray
            }                                                 // else continue;
        }
        return $array;                                        // return the modified array
    }
    public static function GetList($token)
    {
        /**
         * بررسی Token کاربر و نمایش لیست فولدر ها و زیر فولدرها
         * 
         *   ورودی : Token
         *   خروجی : Array :
         *                    status : وضعیت درخواست
         *                    data : آرایه ای از فولدر ها 
         */
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این بخش را ندارید"];
        }
        if ($lv["status"] == "error") {
            return ["status" => "success", "message" => "شما دامنه ای انتخاب نکرده اید"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . " WHERE " . $GLOBALS['vf_cidfk'] . "=" . $lv["data"][0]["vdid"];
        $conn = GetConnection();
        $result = $conn->query($sql);


        $arr = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "datasaf" =>  $arr,  "data" => VOD_FOLDERS_ADMIN::findParent($arr)];
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedName($parentid, $name)
    {
        /**
         *  بررسی تکراری بودن نام فولدر ها
         * 
         *   ورودی : شناسه فولدر والد - نام فولدر
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . " WHERE " . $GLOBALS['vfname'] . "='" . $name . "' AND " . $GLOBALS['vf_parentid'] . "=" . $parentid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOne($token, $fid)
    {
        /**
         *   دریافت اطلاعات یک فولدر
         * 
         *   ورودی :Token - Folder ID
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         *                    data : آرایه ای از اطلاعات فولدر
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . " WHERE " . $GLOBALS['vfid'] . "=" . $fid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneWithoutToken($fid)
    {
        /**
         *   دریافت اطلاعات یک فولدر
         * 
         *   ورودی : Folder ID
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         *                    data : آرایه ای از اطلاعات فولدر
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . " WHERE " . $GLOBALS['vfid'] . "=" . $fid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateFolderName($token, $fid, $nm)
    {
        /**
         *   ایجاد تغییر  اطلاعات یک فولدر
         * 
         *   ورودی :Token - Folder ID - New name
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $name = TOOLS_ADMIN::seo_friendly_url($nm);
        $ufaccess = VOD_FOLDERS_ADMIN::GetOne($token, $fid);
        if ($ufaccess["status"] == "error") {
            return $ufaccess;
        }

        if (VOD_FOLDERS_ADMIN::CheckDuplicatedName($ufaccess["data"][0]["vf_parentid"], $name)["status"] == "error") {
            return ["status" => "error", "message" => "نام درخواستی شما تکراری است و قابل ثبت نیست لطفا نام دیگری انتخاب نمایید"];
        }

        $uid =    $u["userdetail"][0]["uid"];

        $now = date("Y/m/d H:i:s");
        if ($ufaccess["data"][0]["vf_parentid"] != 0) {
            if (VOD_FOLDERS_ADMIN::UserCanAccessToParentID($uid, $ufaccess["data"][0]["vf_parentid"])["status"] == "error") {
                return ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید"];
            }
        }

        $sqlins = "UPDATE " . $GLOBALS["vod_folders_tablename"] . " SET " . $GLOBALS['vfname'] . "='" . $name . "' WHERE " . $GLOBALS["vfid"] . "=" . $fid;
        $conn = GetConnection();

        if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
        } else {
            $listOfRecordType = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckFolderCanDelete($folderid)
    {
        /**
         *   بررسی امکان حذف اطلاعات یک فولدر
         * 
         *   ورودی : Folder ID 
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         */
        //1- check Folder contains subfolder
        $sqlCheckFolderContainsSubfolder = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . " WHERE " . $GLOBALS["vf_parentid"] . "=" . $folderid;
        $conn = GetConnection();
        $result = $conn->query($sqlCheckFolderContainsSubfolder);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ouput = ["status" => "success"];
        } else {
            $result->free_result();
            $conn->close();
            return ["status" => "error"];
        }
        //2- check Folder contains Videos

        $result->free_result();
        $conn->close();
        return $ouput;
    }
    public static function CheckChannelContainsFolder($channelid)
    {

        $sql = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . " WHERE " . $GLOBALS["vf_cidfk"] . "=" . $channelid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToFolder($uid, $folderID)
    {
        /**
         *   بررسی دسترسی کاربر یک فولدر
         * 
         *   ورودی : Folder ID - uid
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         *                    data : آرایه ای از اطلاعات بک فولدر
         */
        $sql = "SELECT * FROM tbl_vod_domain,tbl_users, tbl_vod_folders "
            . " WHERE uid=vd_uid_fk and vf_cidfk=vdid and uid=" . $uid
            . " AND " . $GLOBALS['vfid'] . "=" . $folderID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ouput = ["status" => "error",];
        } else {
            $ouput =  ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }

        $conn->close();
        return $ouput;
    }
    public static function AddFolders($token, $domainid, $parentid, $nm)
    {
        /**
         *   افزودن فولدر جدید 
         * 
         *   ورودی : string Token,
         *            int    domainID,
         *            int    ParentID,
         *            string name  
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $name = TOOLS_ADMIN::seo_friendly_url($nm);
        if (VOD_FOLDERS_ADMIN::CheckDuplicatedName($parentid, $name)["status"] == "error") {
            return ["status" => "error", "message" => "نام درخواستی شما تکراری است و قابل ثبت نیست لطفا نام دیگری انتخاب نمایید"];
        }

        $uid =    $u["userdetail"][0]["uid"];

        $now = date("Y/m/d H:i:s");
        if ($parentid != 0) {
            if (VOD_FOLDERS_ADMIN::UserCanAccessToParentID($uid, $parentid)["status"] == "error") {
                return ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید"];
            }
        }
        if (VOD_DOMAIN_ADMIN::UserCanAccessToStreamDomain($uid, $domainid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
        };
        $sqlins = "INSERT INTO " . $GLOBALS["vod_folders_tablename"] . "(" . $GLOBALS['vfname'] . "," . $GLOBALS['vf_cidfk'] . "," . $GLOBALS['vf_parentid'] . "," . $GLOBALS['vf_creationdate'] . "," . $GLOBALS['vf_updatedate'] . ") VALUES ('"
            . $name . "'," . $domainid . "," . $parentid . ",'" . $now . "','" . $now . "')";
        $conn = GetConnection();

        if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد","id"=>$conn->insert_id,"now"=>$now];
        } else {
            $listOfRecordType = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function RemoveFolders($token, $folderid)
    {
        /**
         *   حذف یک فولدر 
         * 
         *   ورودی : string Token,
         *            int    FolderID
         *   خروجی : Array :
         *                    status : وضعیت درخواست 
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];


        if (VOD_FOLDERS_ADMIN::UserCanAccessToFolder($uid, $folderid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید"];
        }
        if (VOD_FOLDERS_ADMIN::CheckFolderCanDelete($folderid)["status"] == "error") {
            return ["status" => "error", "message" => "شما امکان حذف این فولدر را ندارید لطفا ابتدا فولدر های داخلی و فایل های مربوط به آن را حذف نمایید سپس اقدام به حذف فولدر نمایید "];
        }
        $sqlins = "DELETE FROM  " . $GLOBALS["vod_folders_tablename"] . " WHERE " . $GLOBALS["vfid"] . "=" . $folderid;
        $conn = GetConnection();

        if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت حذف شد"];
        } else {
            $listOfRecordType = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToParentID($uid, $parentid)
    {
        /**
         *   بررسی دسترسی یک کاربر به والد یک فولدر
         * 
         *   ورودی : 
         *              int    uid,
         *              int    parentid
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . "," . $GLOBALS["vod_domain_tablename"] . "," . $GLOBALS["users_tablename"] . " WHERE " . $GLOBALS['vfid'] . "=" . $parentid . " AND " .
            $GLOBALS['uid'] . "=" . $uid . " AND " . $GLOBALS['vf_cidfk'] . "=" . $GLOBALS['vdid'] . " AND " . $GLOBALS['uid'] . "=" . $GLOBALS['vd_uid_fk'];
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetFolderAndUpFolders($vfid, $olname, $r)
    {
         /**
         *   دریافت یک فولدر و وارد آن
         * 
         *   ورودی : 
         *              int    vfid,
         *              string olname
         *              int    r //parentID
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    output : آرایه ای از فولدرها
         */
        $m = [];
        $vf = VOD_FOLDERS_ADMIN::GetOneWithoutToken($vfid, "", 0);
        if ($r == 0)
            array_push($m, $vf["data"][0]);

        while ($vf["data"][0]["vf_parentid"] != "0") {
            $vf = VOD_FOLDERS_ADMIN::GetOneWithoutToken($vf["data"][0]["vf_parentid"], $olname, 1);
            array_push($m, $vf["data"][0]);
        }
        $ouput = [];
        $ouputfoldername = "";
        if ($vf["data"][0]["vf_parentid"] == "0") {
            foreach ($m as $l) {
                array_push($ouput, $l["vfname"]);
            }
            $o = array_reverse($ouput);
            $ouputfoldername = implode(",", $o);
            return $ouputfoldername;
        }
        return $m;
    }
}
