<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
require_once '../../include/vars.php';

require_once $GLOBALS["RootFiles"] . '/include/tools.php';

function returnCurlResult($url, $action, $time, $domain)
{
    $response = API_REPORT_ADMIN::RunWafLog($domain, $time, $action);
    return $response;
}

function ReturnWafLayerTwo($url, $action, $time, $domain)
{
    $response = API_REPORT_ADMIN::RunModsecLog($domain, $time, $action);
    return $response;
}
function MergeReport($layer1, $layer2)
{
    $output=[];
    $l1keys = array_keys($layer1);
    $l2keys = array_keys($layer2);
    for($i=0; $i < count($layer1); $i++) {
        $output['layer1'][$l1keys[$i]] = $layer1[$l1keys[$i]];
        $output['layer2'][$l1keys[$i]] = $layer2[$l2keys[$i]];
        $output['data'][$l1keys[$i]]  = intVal($layer1[$l1keys[$i]]) + intVal($layer2[$l2keys[$i]]);
    }
    return $output;
}
$dtse = $_POST["time"];
$validtime = ["1min"=>"1","5min"=>"5","15min"=>"15","30min"=>"30","1h"=>"1","3h" => "3", "6h" => "6", "12h" => "12", "1d" => "24", "1w" => "7d", "1m" => "30d"];
if (!isset($validtime[$dtse])) {
    echo json_encode(["status" => "error", $dtse, "message" => "زمان درخواستی شما نامعتبر است"]);
    return;
}

$m = [];
$url = "";
$action = "counter";
$_POST['action'] = $action;

$domain = $_POST["domain"];
if ($_POST["website"] != $domain) {
    $domain = $_POST["website"] . "." . $_POST["domain"];
}

if (WEBSITES_ADMIN::CheckPlan($_POST["token"], $_POST["websiteid"], "waflog")["status"] == "error") {
    echo json_encode(["status" => "error", "message" => "شما در این پلان امکان دسترسی به این بخش ندارید"]);

    return;
}

if (!file_exists("wafcharts/" . $domain))
    mkdir("wafcharts/" . $domain);

$fp = "wafcharts/" . $domain . "/" . $validtime[$_POST["time"]] . ".report";

if (file_exists($fp)) {
    $response = file_get_contents($fp);

    $now = date("Y/m/d H:i:s");
    $rep = json_decode($response, true);
    $expire = $rep["expire"];
    if ($now > $expire) {
        $_POST["action"] = "counter";
        $response = returnCurlResult(
            $url,
            $action,
            $validtime[$dtse],
            $domain
        );
        $response2 = ReturnWafLayerTwo(
            $url,
            $action,
            $validtime[$dtse],
            $domain
        );

        $rep = json_decode($response, true);
        $rep2 = json_decode($response2, true);
        ksort($rep);
        ksort($rep2);
        $output = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد",  MergeReport($rep, $rep2)  ];
        $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+1  minutes"));

        $dtss = ["expire" => $expire, "data" => $output];
        $dmns = json_encode($dtss);
        $myfile = fopen($fp, "w") or die(json_encode(["status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp]));
        fwrite($myfile, $dmns);
        fclose($myfile);
        echo json_encode($output);
    } else {
        $rep = $rep["data"];
        // ksort($rep["data"]);

        echo json_encode($rep);
    }
} else {
    $_POST["action"] = "counter";
    $response = returnCurlResult(
        $url,
        $action,
        $validtime[$dtse],
        $domain
    );
    $response2 = ReturnWafLayerTwo(
        $url,
        $action,
        $validtime[$dtse],
        $domain
    );
    $rep = json_decode($response, true);
    $rep2 = json_decode($response2, true);
    // ksort($rep);
    // ksort($rep2);
    $output = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد",  MergeReport($rep, $rep2) ];

    $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+1 minutes"));

    $dtss = ["expire" => $expire, "data" => $output];
    $dmns = json_encode($dtss);
    $myfile = fopen($fp, "w") or die(json_encode(["status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp]));
    fwrite($myfile, $dmns);
    fclose($myfile);
    echo json_encode($output);
}
