<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once '../../include/vars.php';

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

function returnCurlResult($url, $action, $time, $domain)
{
    $r = API_REPORT_ADMIN::RunAccessLog($domain, $time, $action);
    return $r;
}
// TotalBytes,TotalCachedBytes
$validtimerange = ["3h" => "3", "6h" => "6", "12h" => "12", "1d" => "24", "1w" => "7d", "1m" => "30d"];
if (!isset($validtimerange[$_POST["timerange"]])) {
    echo json_encode([ "status" => "error", $dtse, "message" => "زمان درخواستی شما نامعتبر است" ]);
    return;
}

$domain = $_POST["domain"];
if ($_POST["website"] != $domain) {
    $domain = $_POST["website"] . "." . $_POST["domain"];
}

if (isset($_POST["graph"])) {

    $totalBytes = returnCurlResult('', "TotalBytes", $validtimerange[$_POST["timerange"]], $domain);
    $cachebw = returnCurlResult('', "TotalCachedBytes", $validtimerange[$_POST["timerange"]], $domain);
    $TotalRequests = returnCurlResult('', "TotalRequests", $validtimerange[$_POST["timerange"]], $domain);
    $TotalCachedRequests = returnCurlResult('', "TotalCachedRequests", $validtimerange[$_POST["timerange"]], $domain);

    if ($TotalCachedRequests == "")
        $TotalCachedRequests = "0";

    $output = [
        "status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "data" =>
        [
            "totalBytes" => json_decode($totalBytes, true), // number_format( $tbf / 1048576, 1, '.', ''),
            "cachebw" => json_decode($cachebw, true), // number_format( $cbf / 1048576, 1, '.', ''),
            "TotalRequests" => json_decode($TotalRequests, true),
            "TotalCachedRequests" => json_decode($TotalCachedRequests, true)
        ]
    ];
    echo json_encode($output);
    return;
}


if (!file_exists("accesss/" . $domain))
    mkdir("accesss/" . $domain);

$fp = "accesss/" . $domain . "/" . $validtimerange[$_POST["timerange"]] . ".report";

if (file_exists($fp)) {
    $response = file_get_contents($fp);

    $now = date("Y/m/d H:i:s");
    $rep = json_decode($response, true);
    $expire = $rep["expire"];

    if ($now > $expire) {
        $totalBytes = returnCurlResult('', "TotalBytes", $validtimerange[$_POST["timerange"]], $domain);
        $cachebw = returnCurlResult('', "TotalCachedBytes", $validtimerange[$_POST["timerange"]], $domain);
        $TotalRequests = returnCurlResult('', "TotalRequests", $validtimerange[$_POST["timerange"]], $domain);
        $TotalCachedRequests = returnCurlResult('', "TotalCachedRequests", $validtimerange[$_POST["timerange"]], $domain);

        if ($TotalCachedRequests == "")
            $TotalCachedRequests = "0";

        $tb = json_decode($totalBytes, true);
        $cb = json_decode($cachebw, true);
        $tr = json_decode($TotalRequests, true);
        $tcr = json_decode($TotalCachedRequests, true);
        $tbf = 0;
        $cbf = 0;
        $trf = 0;
        $tcrf = 0;

        foreach ($tb as $t => $j) {
            // foreach($j as $s){
            $tbf = intVal($j) + $tbf;

            // }
        }
        foreach ($cb as $t => $j) {
            // foreach($j as $s){
            $cbf = intVal($j) + $cbf;
            // }
        }
        foreach ($tr as $t => $j) {
            // foreach($j as $s){
            $trf = intVal($j) + $trf;
            // }
        }
        if(is_array($tcr)){
            foreach ($tcr as $t => $j) {
                // foreach($j as $s){
                $tcrf = intVal($j) + $tcrf;
                // }
            }
        }
        $output = [
            "status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "data" =>
            [
                "totalBytes" => $tbf, // number_format( $tbf / 1048576, 1, '.', ''),
                "cachebw" => $cbf, // number_format( $cbf / 1048576, 1, '.', ''),
                "TotalRequests" => $trf . "",
                "TotalCachedRequests" => $tcrf . "",
            ]
        ];
        // $rep = json_decode($output, true);

        $expire = date("Y/m/d H:" . TOOLS_ADMIN::returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

        $dtss = ["expire" => $expire, "data" => $output];
        $dmns = json_encode($dtss);
        $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
        fwrite($myfile, $dmns);
        fclose($myfile);
        echo json_encode($output);
    } else {
        $rep = $rep["data"];
        echo json_encode($rep);
    }
} else {
    $totalBytes = returnCurlResult('', "TotalBytes", $validtimerange[$_POST["timerange"]], $domain);
    $cachebw = returnCurlResult('', "TotalCachedBytes", $validtimerange[$_POST["timerange"]], $domain);
    $TotalRequests = returnCurlResult('', "TotalRequests", $validtimerange[$_POST["timerange"]], $domain);
    $TotalCachedRequests = returnCurlResult('', "TotalCachedRequests", $validtimerange[$_POST["timerange"]], $domain);

    if ($TotalCachedRequests == "")
        $TotalCachedRequests = "0";

    $tb = json_decode($totalBytes, true);
    $cb = json_decode($cachebw, true);
    $tr = json_decode($TotalRequests, true);
    $tcr = json_decode($TotalCachedRequests, true);
    $tbf = 0;
    $cbf = 0;
    $trf = 0;
    $tcrf = 0;

    foreach ($tb as $t => $j) {
        // foreach($j as $s){
        $tbf = intVal($j) + $tbf;

        // }
    }
    foreach ($cb as $t => $j) {
        // foreach($j as $s){
        $cbf = intVal($j) + $cbf;
        // }
    }
    foreach ($tr as $t => $j) {
        // foreach($j as $s){
        $trf = intVal($j) + $trf;
        // }
    }
    if(is_array($tcr) && count($tcr)>0){
        foreach ($tcr as $t => $j) {
            // foreach($j as $s){
            $tcrf = intVal($j) + $tcrf;
            // }
        }
    }
    $output = [
        "status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "data" =>
        [
            "totalBytes" => $tbf, // number_format( $tbf / 1048576, 1, '.', ''),
            "cachebw" => $cbf, // number_format( $cbf / 1048576, 1, '.', ''),
            "TotalRequests" => $trf . "",
            "TotalCachedRequests" => $tcrf . "",
        ]
    ];
    // $rep = json_decode($output, true);

    $expire = date("Y/m/d H:" . TOOLS_ADMIN::returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

    $dtss = ["expire" => $expire, "data" => $output];
    $dmns = json_encode($dtss);
    $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
    fwrite($myfile, $dmns);
    fclose($myfile);
    echo json_encode($output);
}
