<?php

use PHPMailer\PHPMailer\PHPMailer;

require_once  'vars.php';
function check_national_code($code)
{
	if (!preg_match('/^[0-9]{10}$/', $code))
		return 0;
	for ($i = 0; $i < 10; $i++)
		if (preg_match('/^' . $i . '{10}$/', $code))
			return 0;
	for ($i = 0, $sum = 0; $i < 9; $i++)
		$sum += ((10 - $i) * intval(substr($code, $i, 1)));
	$ret = $sum % 11;
	$parity = intval(substr($code, 9, 1));
	if (($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity))
		return 1;
	return 0;
}
function SendMailWithSMTP()
{
	require_once $GLOBALS["RootFiles"] . '/bussiness/setting/admin/setting_admin_class.php';
	$SETTING_ADMIN = new SETTING_ADMIN();
	if (!file_exists("../conf/settingconf.php")) {
		$SETTING_ADMIN->GetAllParamsAndCreateFile();
	}
	require_once $GLOBALS["RootFiles"] . '/conf/settingsconf.php';
	require $GLOBALS["RootFiles"] . '/vendor/autoload.php';
	$mail = new PHPMailer;
	$mail->isSMTP();
	$mail->SMTPDebug = 2;
	$mail->Host = $GLOBALS['smtp_server'];
	$mail->Port = $GLOBALS['smtp_port'];
	$mail->SMTPAuth = true;
	$mail->SMTPSecure = "tls";
	$mail->Username = $GLOBALS['smtp_username'];
	$mail->Password = $GLOBALS['smtp_password'];
	$mail->setFrom('hammedsadeghie@gmail.com', 'Your Name');
	#$mail->addReplyTo('test@hostinger-tutorials.com', 'Your Name');
	$mail->addAddress('hammedsadeghie@gmail.com', 'Receiver Name');
	$mail->Subject = 'Testing PHPMailer';
	#$mail->msgHTML(file_get_contents('message.html'), __DIR__);
	$mail->Body = 'This is a plain text message body';
	//$mail->addAttachment('test.txt');
	if (!$mail->send()) {
		echo 'Mailer Error: ' . $mail->ErrorInfo;
	} else {
		echo 'The email message was sent.';
	}
}
class TOOLS_ADMIN
{
	public static function guidv4($data)
	{
		assert(strlen($data) == 16);
		$data[6] = chr(ord($data[6]) & 0x0f | 0x40); // set version to 0100
		$data[8] = chr(ord($data[8]) & 0x3f | 0x80); // set bits 6-7 to 10
		return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
	}
	public static function ReturnCountry()
	{
		return array(
			'Afghanistan' => 'AF',
			'Aland Islands' => 'AX',
			'Albania' => 'AL',
			'Algeria' => 'DZ',
			'American Samoa' => 'AS',
			'Andorra' => 'AD',
			'Angola' => 'AO',
			'Anguilla' => 'AI',
			'Antarctica' => 'AQ',
			'Antigua and Barbuda' => 'AG',
			'Argentina' => 'AR',
			'Armenia' => 'AM',
			'Aruba' => 'AW',
			'Australia' => 'AU',
			'Austria' => 'AT',
			'Azerbaijan' => 'AZ',
			'Bahamas' => 'BS',
			'Bahrain' => 'BH',
			'Bangladesh' => 'BD',
			'Barbados' => 'BB',
			'Belarus' => 'BY',
			'Belgium' => 'BE',
			'Belize' => 'BZ',
			'Benin' => 'BJ',
			'Bermuda' => 'BM',
			'Bhutan' => 'BT',
			'Bolivia' => 'BO',
			'Bosnia and Herzegovina' => 'BA',
			'Botswana' => 'BW',
			'Bouvet Island' => 'BV',
			'Brazil' => 'BR',
			'British Indian Ocean Territory (Chagos Archipelago)' => 'IO',
			'British Virgin Islands' => 'VG',
			'Brunei Darussalam' => 'BN',
			'Bulgaria' => 'BG',
			'Burkina Faso' => 'BF',
			'Burundi' => 'BI',
			'Cambodia' => 'KH',
			'Cameroon' => 'CM',
			'Canada' => 'CA',
			'Cape Verde' => 'CV',
			'Cayman Islands' => 'KY',
			'Central African Republic' => 'CF',
			'Chad' => 'TD',
			'Chile' => 'CL',
			'China' => 'CN',
			'Christmas Island' => 'CX',
			'Cocos (Keeling) Islands' => 'CC',
			'Colombia' => 'CO',
			'Comoros the' => 'KM',
			'Congo' => 'CD',
			'Congo the' => 'CG',
			'Cook Islands' => 'CK',
			'Costa Rica' => 'CR',
			'Ivory Coast' => 'CI',
			'Croatia' => 'HR',
			'Cuba' => 'CU',
			'Cyprus' => 'CY',
			'Czechia' => 'CZ',
			'Denmark' => 'DK',
			'Djibouti' => 'DJ',
			'Dominica' => 'DM',
			'Dominican Republic' => 'DO',
			'Ecuador' => 'EC',
			'Egypt' => 'EG',
			'El Salvador' => 'SV',
			'Equatorial Guinea' => 'GQ',
			'Eritrea' => 'ER',
			'Estonia' => 'EE',
			'Ethiopia' => 'ET',
			'Faroe Islands' => 'FO',
			'Falkland Islands (Malvinas)' => 'FK',
			'Fiji' => 'FJ',
			'Finland' => 'FI',
			'France' => 'FR',
			'French Guiana' => 'GF',
			'French Polynesia' => 'PF',
			'French Southern Territories' => 'TF',
			'Gabon' => 'GA',
			'Gambia the' => 'GM',
			'Georgia' => 'GE',
			'Germany' => 'DE',
			'Ghana' => 'GH',
			'Gibraltar' => 'GI',
			'Greece' => 'GR',
			'Greenland' => 'GL',
			'Grenada' => 'GD',
			'Guadeloupe' => 'GP',
			'Guam' => 'GU',
			'Guatemala' => 'GT',
			'Guernsey' => 'GG',
			'Guinea' => 'GN',
			'Guinea-Bissau' => 'GW',
			'Guyana' => 'GY',
			'Haiti' => 'HT',
			'Heard Island and McDonald Islands' => 'HM',
			'Holy See (Vatican City State)' => 'VA',
			'Honduras' => 'HN',
			'Hong Kong' => 'HK',
			'Hungary' => 'HU',
			'Iceland' => 'IS',
			'India' => 'IN',
			'Indonesia' => 'ID',
			'Iran' => 'IR',
			'Iraq' => 'IQ',
			'Ireland' => 'IE',
			'Isle of Man' => 'IM',
			'Israel' => 'IL',
			'Italy' => 'IT',
			'Jamaica' => 'JM',
			'Japan' => 'JP',
			'Jersey' => 'JE',
			'Jordan' => 'JO',
			'Kazakhstan' => 'KZ',
			'Kenya' => 'KE',
			'Kiribati' => 'KI',
			'South Korea' => 'KP',
			'Korea' => 'KR',
			'Kuwait' => 'KW',
			'Kyrgyz Republic' => 'KG',
			'Lao' => 'LA',
			'Latvia' => 'LV',
			'Lebanon' => 'LB',
			'Lesotho' => 'LS',
			'Liberia' => 'LR',
			'Libya' => 'LY',
			'Liechtenstein' => 'LI',
			'Lithuania' => 'LT',
			'Luxembourg' => 'LU',
			'Macao' => 'MO',
			'North Macedonia' => 'MK',
			'Madagascar' => 'MG',
			'Malawi' => 'MW',
			'Malaysia' => 'MY',
			'Maldives' => 'MV',
			'Mali' => 'ML',
			'Malta' => 'MT',
			'Marshall Islands' => 'MH',
			'Martinique' => 'MQ',
			'Mauritania' => 'MR',
			'Mauritius' => 'MU',
			'Mayotte' => 'YT',
			'Mexico' => 'MX',
			'Micronesia' => 'FM',
			'Moldova' => 'MD',
			'Principality of Monaco' => 'MC',
			'Mongolia' => 'MN',
			'Montenegro' => 'ME',
			'Montserrat' => 'MS',
			'Morocco' => 'MA',
			'Mozambique' => 'MZ',
			'Myanmar' => 'MM',
			'Namibia' => 'NA',
			'Nauru' => 'NR',
			'Nepal' => 'NP',
			'Netherlands Antilles' => 'AN',
			'Netherlands' => 'NL',
			'New Caledonia' => 'NC',
			'New Zealand' => 'NZ',
			'Nicaragua' => 'NI',
			'Niger' => 'NE',
			'Nigeria' => 'NG',
			'Niue' => 'NU',
			'Norfolk Island' => 'NF',
			'Northern Mariana Islands' => 'MP',
			'Norway' => 'NO',
			'Oman' => 'OM',
			'Pakistan' => 'PK',
			'Palau' => 'PW',
			'Palestine' => 'PS',
			'Panama' => 'PA',
			'Papua New Guinea' => 'PG',
			'Paraguay' => 'PY',
			'Peru' => 'PE',
			'Philippines' => 'PH',
			'Pitcairn Islands' => 'PN',
			'Poland' => 'PL',
			'Portugal' => 'PT',
			'Puerto Rico' => 'PR',
			'Qatar' => 'QA',
			'Reunion' => 'RE',
			'Romania' => 'RO',
			'Russia' => 'RU',
			'Rwanda' => 'RW',
			'Saint Barthelemy' => 'BL',
			'Saint Helena' => 'SH',
			'Saint Kitts and Nevis' => 'KN',
			'Saint Lucia' => 'LC',
			'Saint Martin' => 'MF',
			'Saint Pierre and Miquelon' => 'PM',
			'Saint Vincent and the Grenadines' => 'VC',
			'Samoa' => 'WS',
			'San Marino' => 'SM',
			'Sao Tome and Principe' => 'ST',
			'Saudi Arabia' => 'SA',
			'Senegal' => 'SN',
			'Serbia' => 'RS',
			'Seychelles' => 'SC',
			'Sierra Leone' => 'SL',
			'Singapore' => 'SG',
			'Slovakia' => 'SK',
			'Slovenia' => 'SI',
			'Solomon Islands' => 'SB',
			'Somalia' => 'SO',
			'South Africa' => 'ZA',
			'South Georgia and the South Sandwich Islands' => 'GS',
			'Spain' => 'ES',
			'Sri Lanka' => 'LK',
			'Sudan' => 'SD',
			'Suriname' => 'SR',
			'Svalbard & Jan Mayen Islands' => 'SJ',
			'Swaziland' => 'SZ',
			'Sweden' => 'SE',
			'Switzerland' => 'CH',
			'Syria' => 'SY',
			'Taiwan' => 'TW',
			'Tajikistan' => 'TJ',
			'Tanzania' => 'TZ',
			'Thailand' => 'TH',
			'East Timor' => 'TL',
			'Togo' => 'TG',
			'Tokelau' => 'TK',
			'Tonga' => 'TO',
			'Trinidad and Tobago' => 'TT',
			'Tunisia' => 'TN',
			'Turkey' => 'TR',
			'Turkmenistan' => 'TM',
			'Turks and Caicos Islands' => 'TC',
			'Tuvalu' => 'TV',
			'Uganda' => 'UG',
			'Ukraine' => 'UA',
			'United Arab Emirates' => 'AE',
			'United Kingdom' => 'GB',
			'United States' => 'US',
			'United States Minor Outlying Islands' => 'UM',
			'United States Virgin Islands' => 'VI',
			'Uruguay' => 'UY',
			'Uzbekistan' => 'UZ',
			'Vanuatu' => 'VU',
			'Venezuela' => 'VE',
			'Vietnam' => 'VN',
			'Wallis and Futuna' => 'WF',
			'Western Sahara' => 'EH',
			'Yemen' => 'YE',
			'Zambia' => 'ZM',
			'Zimbabwe' => 'ZW',
			'Kyrgyzstan' => 'KG',

		);
	}
	public static function CountryToIso($country)
	{
		$code = strtoupper($country);

		$countryList = array(
			'Afghanistan' => 'AF',
			'Aland Islands' => 'AX',
			'Albania' => 'AL',
			'Algeria' => 'DZ',
			'American Samoa' => 'AS',
			'Andorra' => 'AD',
			'Angola' => 'AO',
			'Anguilla' => 'AI',
			'Antarctica' => 'AQ',
			'Antigua and Barbuda' => 'AG',
			'Argentina' => 'AR',
			'Armenia' => 'AM',
			'Aruba' => 'AW',
			'Australia' => 'AU',
			'Austria' => 'AT',
			'Azerbaijan' => 'AZ',
			'Bahamas' => 'BS',
			'Bahrain' => 'BH',
			'Bangladesh' => 'BD',
			'Barbados' => 'BB',
			'Belarus' => 'BY',
			'Belgium' => 'BE',
			'Belize' => 'BZ',
			'Benin' => 'BJ',
			'Bermuda' => 'BM',
			'Bhutan' => 'BT',
			'Bolivia' => 'BO',
			'Bosnia and Herzegovina' => 'BA',
			'Botswana' => 'BW',
			'Bouvet Island' => 'BV',
			'Brazil' => 'BR',
			'British Indian Ocean Territory (Chagos Archipelago)' => 'IO',
			'British Virgin Islands' => 'VG',
			'Brunei Darussalam' => 'BN',
			'Bulgaria' => 'BG',
			'Burkina Faso' => 'BF',
			'Burundi' => 'BI',
			'Cambodia' => 'KH',
			'Cameroon' => 'CM',
			'Canada' => 'CA',
			'Cape Verde' => 'CV',
			'Cayman Islands' => 'KY',
			'Central African Republic' => 'CF',
			'Chad' => 'TD',
			'Chile' => 'CL',
			'China' => 'CN',
			'Christmas Island' => 'CX',
			'Cocos (Keeling) Islands' => 'CC',
			'Colombia' => 'CO',
			'Comoros the' => 'KM',
			'Congo' => 'CD',
			'Congo the' => 'CG',
			'Cook Islands' => 'CK',
			'Costa Rica' => 'CR',
			'Ivory Coast' => 'CI',
			'Croatia' => 'HR',
			'Cuba' => 'CU',
			'Cyprus' => 'CY',
			'Czechia' => 'CZ',
			'Denmark' => 'DK',
			'Djibouti' => 'DJ',
			'Dominica' => 'DM',
			'Dominican Republic' => 'DO',
			'Ecuador' => 'EC',
			'Egypt' => 'EG',
			'El Salvador' => 'SV',
			'Equatorial Guinea' => 'GQ',
			'Eritrea' => 'ER',
			'Estonia' => 'EE',
			'Ethiopia' => 'ET',
			'Faroe Islands' => 'FO',
			'Falkland Islands (Malvinas)' => 'FK',
			'Fiji' => 'FJ',
			'Finland' => 'FI',
			'France' => 'FR',
			'French Guiana' => 'GF',
			'French Polynesia' => 'PF',
			'French Southern Territories' => 'TF',
			'Gabon' => 'GA',
			'Gambia the' => 'GM',
			'Georgia' => 'GE',
			'Germany' => 'DE',
			'Ghana' => 'GH',
			'Gibraltar' => 'GI',
			'Greece' => 'GR',
			'Greenland' => 'GL',
			'Grenada' => 'GD',
			'Guadeloupe' => 'GP',
			'Guam' => 'GU',
			'Guatemala' => 'GT',
			'Guernsey' => 'GG',
			'Guinea' => 'GN',
			'Guinea-Bissau' => 'GW',
			'Guyana' => 'GY',
			'Haiti' => 'HT',
			'Heard Island and McDonald Islands' => 'HM',
			'Holy See (Vatican City State)' => 'VA',
			'Honduras' => 'HN',
			'Hong Kong' => 'HK',
			'Hungary' => 'HU',
			'Iceland' => 'IS',
			'India' => 'IN',
			'Indonesia' => 'ID',
			'Iran' => 'IR',
			'Iraq' => 'IQ',
			'Ireland' => 'IE',
			'Isle of Man' => 'IM',
			'Israel' => 'IL',
			'Italy' => 'IT',
			'Jamaica' => 'JM',
			'Japan' => 'JP',
			'Jersey' => 'JE',
			'Jordan' => 'JO',
			'Kazakhstan' => 'KZ',
			'Kenya' => 'KE',
			'Kiribati' => 'KI',
			'South Korea' => 'KP',
			'Korea' => 'KR',
			'Kuwait' => 'KW',
			'Kyrgyz Republic' => 'KG',
			'Lao' => 'LA',
			'Latvia' => 'LV',
			'Lebanon' => 'LB',
			'Lesotho' => 'LS',
			'Liberia' => 'LR',
			'Libya' => 'LY',
			'Liechtenstein' => 'LI',
			'Lithuania' => 'LT',
			'Luxembourg' => 'LU',
			'Macao' => 'MO',
			'North Macedonia' => 'MK',
			'Madagascar' => 'MG',
			'Malawi' => 'MW',
			'Malaysia' => 'MY',
			'Maldives' => 'MV',
			'Mali' => 'ML',
			'Malta' => 'MT',
			'Marshall Islands' => 'MH',
			'Martinique' => 'MQ',
			'Mauritania' => 'MR',
			'Mauritius' => 'MU',
			'Mayotte' => 'YT',
			'Mexico' => 'MX',
			'Micronesia' => 'FM',
			'Moldova' => 'MD',
			'Principality of Monaco' => 'MC',
			'Mongolia' => 'MN',
			'Montenegro' => 'ME',
			'Montserrat' => 'MS',
			'Morocco' => 'MA',
			'Mozambique' => 'MZ',
			'Myanmar' => 'MM',
			'Namibia' => 'NA',
			'Nauru' => 'NR',
			'Nepal' => 'NP',
			'Netherlands Antilles' => 'AN',
			'Netherlands' => 'NL',
			'New Caledonia' => 'NC',
			'New Zealand' => 'NZ',
			'Nicaragua' => 'NI',
			'Niger' => 'NE',
			'Nigeria' => 'NG',
			'Niue' => 'NU',
			'Norfolk Island' => 'NF',
			'Northern Mariana Islands' => 'MP',
			'Norway' => 'NO',
			'Oman' => 'OM',
			'Pakistan' => 'PK',
			'Palau' => 'PW',
			'Palestine' => 'PS',
			'Panama' => 'PA',
			'Papua New Guinea' => 'PG',
			'Paraguay' => 'PY',
			'Peru' => 'PE',
			'Philippines' => 'PH',
			'Pitcairn Islands' => 'PN',
			'Poland' => 'PL',
			'Portugal' => 'PT',
			'Puerto Rico' => 'PR',
			'Qatar' => 'QA',
			'Reunion' => 'RE',
			'Romania' => 'RO',
			'Russia' => 'RU',
			'Rwanda' => 'RW',
			'Saint Barthelemy' => 'BL',
			'Saint Helena' => 'SH',
			'Saint Kitts and Nevis' => 'KN',
			'Saint Lucia' => 'LC',
			'Saint Martin' => 'MF',
			'Saint Pierre and Miquelon' => 'PM',
			'Saint Vincent and the Grenadines' => 'VC',
			'Samoa' => 'WS',
			'San Marino' => 'SM',
			'Sao Tome and Principe' => 'ST',
			'Saudi Arabia' => 'SA',
			'Senegal' => 'SN',
			'Serbia' => 'RS',
			'Seychelles' => 'SC',
			'Sierra Leone' => 'SL',
			'Singapore' => 'SG',
			'Slovakia' => 'SK',
			'Slovenia' => 'SI',
			'Solomon Islands' => 'SB',
			'Somalia' => 'SO',
			'South Africa' => 'ZA',
			'South Georgia and the South Sandwich Islands' => 'GS',
			'Spain' => 'ES',
			'Sri Lanka' => 'LK',
			'Sudan' => 'SD',
			'Suriname' => 'SR',
			'Svalbard & Jan Mayen Islands' => 'SJ',
			'Swaziland' => 'SZ',
			'Sweden' => 'SE',
			'Switzerland' => 'CH',
			'Syria' => 'SY',
			'Taiwan' => 'TW',
			'Tajikistan' => 'TJ',
			'Tanzania' => 'TZ',
			'Thailand' => 'TH',
			'East Timor' => 'TL',
			'Togo' => 'TG',
			'Tokelau' => 'TK',
			'Tonga' => 'TO',
			'Trinidad and Tobago' => 'TT',
			'Tunisia' => 'TN',
			'Turkey' => 'TR',
			'Turkmenistan' => 'TM',
			'Turks and Caicos Islands' => 'TC',
			'Tuvalu' => 'TV',
			'Uganda' => 'UG',
			'Ukraine' => 'UA',
			'United Arab Emirates' => 'AE',
			'United Kingdom' => 'GB',
			'United States' => 'US',
			'United States Minor Outlying Islands' => 'UM',
			'United States Virgin Islands' => 'VI',
			'Uruguay' => 'UY',
			'Uzbekistan' => 'UZ',
			'Vanuatu' => 'VU',
			'Venezuela' => 'VE',
			'Vietnam' => 'VN',
			'Wallis and Futuna' => 'WF',
			'Western Sahara' => 'EH',
			'Yemen' => 'YE',
			'Zambia' => 'ZM',
			'Zimbabwe' => 'ZW',
			'Kyrgyzstan' => 'KG',

		);

		if (!isset($countryList[$country]))
			return $code;
		else
			return $countryList[$country];
	}
	public static function code_to_country($code)
	{

		$code = strtoupper($code);

		$countryList = array(
			'AF' => 'Afghanistan',
			'AX' => 'Aland Islands',
			'AL' => 'Albania',
			'DZ' => 'Algeria',
			'AS' => 'American Samoa',
			'AD' => 'Andorra',
			'AO' => 'Angola',
			'AI' => 'Anguilla',
			'AQ' => 'Antarctica',
			'AG' => 'Antigua and Barbuda',
			'AR' => 'Argentina',
			'AM' => 'Armenia',
			'AW' => 'Aruba',
			'AU' => 'Australia',
			'AT' => 'Austria',
			'AZ' => 'Azerbaijan',
			'BS' => 'Bahamas',
			'BH' => 'Bahrain',
			'BD' => 'Bangladesh',
			'BB' => 'Barbados',
			'BY' => 'Belarus',
			'BE' => 'Belgium',
			'BZ' => 'Belize',
			'BJ' => 'Benin',
			'BM' => 'Bermuda',
			'BT' => 'Bhutan',
			'BO' => 'Bolivia',
			'BA' => 'Bosnia and Herzegovina',
			'BW' => 'Botswana',
			'BV' => 'Bouvet Island (Bouvetoya)',
			'BR' => 'Brazil',
			'IO' => 'British Indian Ocean Territory (Chagos Archipelago)',
			'VG' => 'British Virgin Islands',
			'BN' => 'Brunei Darussalam',
			'BG' => 'Bulgaria',
			'BF' => 'Burkina Faso',
			'BI' => 'Burundi',
			'KH' => 'Cambodia',
			'CM' => 'Cameroon',
			'CA' => 'Canada',
			'CV' => 'Cape Verde',
			'KY' => 'Cayman Islands',
			'KG' => 'Kyrgyzstan',
			'CF' => 'Central African Republic',
			'TD' => 'Chad',
			'CL' => 'Chile',
			'CN' => 'China',
			'CX' => 'Christmas Island',
			'CC' => 'Cocos (Keeling) Islands',
			'CO' => 'Colombia',
			'KM' => 'Comoros the',
			'CD' => 'Congo',
			'CG' => 'Congo the',
			'CK' => 'Cook Islands',
			'CR' => 'Costa Rica',
			'CI' => 'Ivory Coast',
			'HR' => 'Croatia',
			'CU' => 'Cuba',
			'CY' => 'Cyprus',
			'CZ' => 'Czech Republic',
			'DK' => 'Denmark',
			'DJ' => 'Djibouti',
			'DM' => 'Dominica',
			'DO' => 'Dominican Republic',
			'EC' => 'Ecuador',
			'EG' => 'Egypt',
			'SV' => 'El Salvador',
			'GQ' => 'Equatorial Guinea',
			'ER' => 'Eritrea',
			'EE' => 'Estonia',
			'ET' => 'Ethiopia',
			'FO' => 'Faroe Islands',
			'FK' => 'Falkland Islands (Malvinas)',
			'FJ' => 'Fiji',
			'FI' => 'Finland',
			'FR' => 'France',
			'GF' => 'French Guiana',
			'PF' => 'French Polynesia',
			'TF' => 'French Southern Territories',
			'GA' => 'Gabon',
			'GM' => 'Gambia the',
			'GE' => 'Georgia',
			'DE' => 'Germany',
			'GH' => 'Ghana',
			'GI' => 'Gibraltar',
			'GR' => 'Greece',
			'GL' => 'Greenland',
			'GD' => 'Grenada',
			'GP' => 'Guadeloupe',
			'GU' => 'Guam',
			'GT' => 'Guatemala',
			'GG' => 'Guernsey',
			'GN' => 'Guinea',
			'GW' => 'Guinea-Bissau',
			'GY' => 'Guyana',
			'HT' => 'Haiti',
			'HM' => 'Heard Island and McDonald Islands',
			'VA' => 'Holy See (Vatican City State)',
			'HN' => 'Honduras',
			'HK' => 'Hong Kong',
			'HU' => 'Hungary',
			'IS' => 'Iceland',
			'IN' => 'India',
			'ID' => 'Indonesia',
			'IR' => 'Iran',
			'IQ' => 'Iraq',
			'IE' => 'Ireland',
			'IM' => 'Isle of Man',
			'IL' => 'Israel',
			'IT' => 'Italy',
			'JM' => 'Jamaica',
			'JP' => 'Japan',
			'JE' => 'Jersey',
			'JO' => 'Jordan',
			'KZ' => 'Kazakhstan',
			'KE' => 'Kenya',
			'KI' => 'Kiribati',
			'KP' => 'South Korea',
			'KR' => 'Korea',
			'KW' => 'Kuwait',
			'KG' => 'Kyrgyz Republic',
			'LA' => 'Lao',
			'LV' => 'Latvia',
			'LB' => 'Lebanon',
			'LS' => 'Lesotho',
			'LR' => 'Liberia',
			'LY' => 'Libya',
			'LI' => 'Liechtenstein',
			'LT' => 'Lithuania',
			'LU' => 'Luxembourg',
			'MO' => 'Macao',
			'MK' => 'North Macedonia',
			'MG' => 'Madagascar',
			'MW' => 'Malawi',
			'MY' => 'Malaysia',
			'MV' => 'Maldives',
			'ML' => 'Mali',
			'MT' => 'Malta',
			'MH' => 'Marshall Islands',
			'MQ' => 'Martinique',
			'MR' => 'Mauritania',
			'MU' => 'Mauritius',
			'YT' => 'Mayotte',
			'MX' => 'Mexico',
			'FM' => 'Micronesia',
			'MD' => 'Moldova',
			'MC' => 'Principality of Monaco',
			'MN' => 'Mongolia',
			'ME' => 'Montenegro',
			'MS' => 'Montserrat',
			'MA' => 'Morocco',
			'MZ' => 'Mozambique',
			'MM' => 'Myanmar',
			'NA' => 'Namibia',
			'NR' => 'Nauru',
			'NP' => 'Nepal',
			'AN' => 'Netherlands Antilles',
			'NL' => 'Netherlands',
			'NC' => 'New Caledonia',
			'NZ' => 'New Zealand',
			'NI' => 'Nicaragua',
			'NE' => 'Niger',
			'NG' => 'Nigeria',
			'NU' => 'Niue',
			'NF' => 'Norfolk Island',
			'MP' => 'Northern Mariana Islands',
			'NO' => 'Norway',
			'OM' => 'Oman',
			'PK' => 'Pakistan',
			'PW' => 'Palau',
			'PS' => 'Palestine',
			'PA' => 'Panama',
			'PG' => 'Papua New Guinea',
			'PY' => 'Paraguay',
			'PE' => 'Peru',
			'PH' => 'Philippines',
			'PN' => 'Pitcairn Islands',
			'PL' => 'Poland',
			'PT' => 'Portugal',
			'PR' => 'Puerto Rico',
			'QA' => 'Qatar',
			'RE' => 'Reunion',
			'RO' => 'Romania',
			'RU' => 'Russia',
			'RW' => 'Rwanda',
			'BL' => 'Saint Barthelemy',
			'SH' => 'Saint Helena',
			'KN' => 'Saint Kitts and Nevis',
			'LC' => 'Saint Lucia',
			'MF' => 'Saint Martin',
			'PM' => 'Saint Pierre and Miquelon',
			'VC' => 'Saint Vincent and the Grenadines',
			'WS' => 'Samoa',
			'SM' => 'San Marino',
			'ST' => 'Sao Tome and Principe',
			'SA' => 'Saudi Arabia',
			'SN' => 'Senegal',
			'RS' => 'Serbia',
			'SC' => 'Seychelles',
			'SL' => 'Sierra Leone',
			'SG' => 'Singapore',
			'SK' => 'Slovakia',
			'SI' => 'Slovenia',
			'SB' => 'Solomon Islands',
			'SO' => 'Somalia',
			'ZA' => 'South Africa',
			'GS' => 'South Georgia and the South Sandwich Islands',
			'ES' => 'Spain',
			'LK' => 'Sri Lanka',
			'SD' => 'Sudan',
			'SR' => 'Suriname',
			'SJ' => 'Svalbard & Jan Mayen Islands',
			'SZ' => 'Swaziland',
			'SE' => 'Sweden',
			'CH' => 'Switzerland',
			'SY' => 'Syria',
			'TW' => 'Taiwan',
			'TJ' => 'Tajikistan',
			'TZ' => 'Tanzania',
			'TH' => 'Thailand',
			'TL' => 'Timor-Leste',
			'TG' => 'Togo',
			'TK' => 'Tokelau',
			'TO' => 'Tonga',
			'TT' => 'Trinidad and Tobago',
			'TN' => 'Tunisia',
			'TR' => 'Turkey',
			'TM' => 'Turkmenistan',
			'TC' => 'Turks and Caicos Islands',
			'TV' => 'Tuvalu',
			'UG' => 'Uganda',
			'UA' => 'Ukraine',
			'AE' => 'United Arab Emirates',
			'GB' => 'United Kingdom',
			'US' => 'United States',
			'UM' => 'United States Minor Outlying Islands',
			'VI' => 'United States Virgin Islands',
			'UY' => 'Uruguay',
			'UZ' => 'Uzbekistan',
			'VU' => 'Vanuatu',
			'VE' => 'Venezuela',
			'VN' => 'Vietnam',
			'WF' => 'Wallis and Futuna',
			'EH' => 'Western Sahara',
			'YE' => 'Yemen',
			'ZM' => 'Zambia',
			'ZW' => 'Zimbabwe'
		);

		if (!$countryList[$code]) return $code;
		else
			return $countryList[$code];
	}

	public static function ReturnCacheStaus()
	{
		return [
			"-1" => 0,
			"1s" => 1,
			"5s" => 2,
			"10s" => 3,
			"30s" => 4,
			"1m" => 5,
			"2m" => 6,
			"5m" => 7,
			"10m" => 8,
			"20m" => 9,
			"30m" => 10,
			"45m" => 11,
			"1h" => 12,
			"2h" => 13,
			"3h" => 14,
			"6h" => 15,
			"12h" => 16,
			"1d" => 17,
			"3d" => 18,
			"7d" => 19,
			"10d" => 20,
			"15d" => 21,
			"30d" => 22,
			"180d" => 23,
			"1y" => 24,

		];
	}

	public static function returnMinute($m)
	{
		if ($m < 15 && $m > 0)
			return "18";
		if ($m < 30 && $m > 15)
			return "33";
		if ($m < 45 && $m > 30)
			return "48";
		if ($m < 59  && $m >= 45)
			return "03";
	}
	public static function ReturnDomainName($websitesOwner)
	{
		$dmn = "";
		if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
			$dmn = $websitesOwner["data"][0]["d_name"];
		} else {
			$dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
		}
		return $dmn;
	}
	public static function ReturnDomainNameForCluster($websitesOwner)
	{
		$dmn = "";

		if ($websitesOwner["subdomain"] == "maindomain") {
			$dmn = $websitesOwner["d_name"];
		} else {
			$dmn = $websitesOwner["ws_recordname"] . "." . $websitesOwner["d_name"];
		}
		return $dmn;
	}
	public static function ReturnDomainNameForClusterAdd($websitesOwner, $index, $part = "data")
	{
		$dmn = "";

		if ($websitesOwner[$part][$index]["subdomain"] == "maindomain") {
			$dmn = $websitesOwner[$part][$index]["d_name"];
		} else {
			$dmn = $websitesOwner[$part][$index]["ws_recordname"] . "." . $websitesOwner[$part][$index]["d_name"];
		}
		return $dmn;
	}
	public static function ReturnDomainNameForSubFolder($websitesOwner)
	{
		$dmn = "";

		if ($websitesOwner[0]["subdomain"] == "maindomain") {
			$dmn = $websitesOwner[0]["d_name"];
		} else {
			$dmn = $websitesOwner[0]["ws_recordname"] . "." . $websitesOwner[0]["d_name"];
		}
		return $dmn;
	}
	public static function MiniEncrypt($data)
	{
		$simple_string = "1010250";
		$ciphering = "AES-128-CTR";
		$iv_length = openssl_cipher_iv_length($ciphering);
		$options = 0;
		$encryption_iv = '1234567891011121';
		$encryption_key = "hamedEnc";
		$encryption = openssl_encrypt(
			$data,
			$ciphering,
			$encryption_key,
			$options,
			$encryption_iv
		);
		return $encryption;
		// echo "Encrypted String: " . $encryption . "\n";
		// $decryption_iv = '1234567891011121';
		// $decryption_key = "GeeksforGeeks";
		// $decryption=openssl_decrypt ($encryption, $ciphering,
		// $decryption_key, $options, $decryption_iv);
		// echo "Decrypted String: " . $decryption;
	}
	public static function encrypt($data)
	{
		$password = "PaymentGatewayEncryption";
		$iv = substr(sha1(mt_rand()), 0, 16);
		$password = sha1($password);

		$salt = sha1(mt_rand());
		$saltWithPassword = hash('sha256', $password . $salt);

		$encrypted = openssl_encrypt(
			"$data",
			'aes-256-cbc',
			"$saltWithPassword",
			0,
			$iv
		);
		$msg_encrypted_bundle = "$iv:$salt:$encrypted";
		return $msg_encrypted_bundle;
	}
	public static function decrypt($msg_encrypted_bundle)
	{
		$password = "PaymentGatewayEncryption";
		$password = sha1($password);

		$components = explode(':', $msg_encrypted_bundle);
		$iv            = $components[0];
		$salt          = hash('sha256', $password . $components[1]);
		$encrypted_msg = $components[2];

		$decrypted_msg = openssl_decrypt(
			$encrypted_msg,
			'aes-256-cbc',
			$salt,
			0,
			$iv
		);

		if ($decrypted_msg === false)
			return false;

		$msg = substr($decrypted_msg, 41);
		return $decrypted_msg;
	}
	public static function getRealIpAddr()
	{
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			// Check IP from internet.
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			// Check IP is passed from proxy.
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			// Get IP address from remote address.
			$ip = $_SERVER['REMOTE_ADDR'];
		}
		return $ip;
	}

	public static function ipCIDRCheck($IP, $CIDR)
	{
		list($net, $mask) = explode("/", $CIDR);

		$ip_net = ip2long($net);
		$ip_mask = ~((1 << (32 - $mask)) - 1);

		$ip_ip = ip2long($IP);

		$ip_ip_net = $ip_ip & $ip_mask;

		$out = "false";
		if ($ip_ip_net == $ip_net)
			$out = "true";
		return $out;
	}
	public static function ip_is_private($ip)
	{
		$pri_addrs = array(
			'10.0.0.0|10.255.255.255', // single class A network
			'172.16.0.0|172.31.255.255', // 16 contiguous class B network
			'192.168.0.0|192.168.255.255', // 256 contiguous class C network
			'169.254.0.0|169.254.255.255', // Link-local address also refered to as Automatic Private IP Addressing
			'127.0.0.0|127.255.255.255' // localhost
		);
		$long_ip = ip2long($ip);
		if ($long_ip != -1) {
			foreach ($pri_addrs as $pri_addr) {
				list($start, $end) = explode('|', $pri_addr);
				if ($long_ip >= ip2long($start) && $long_ip <= ip2long($end)) {
					return "success";
				}
			}
		}
		return "Error";
	}
	public static function isJson($string)
	{
		$l = @json_decode($string,true);
        if ($l === null && json_last_error() !== JSON_ERROR_NONE) {
            return ["status" => "error", "message" => "خطا در مقادیر ورودی"];
        }
	}
	public static function checkPassword($pwd)
	{
		//$errors_init = $errors;
		$uppercase = preg_match('@[A-Z]@', $pwd);
		$lowercase = preg_match('@[a-z]@', $pwd);
		$number    = preg_match('@[0-9]@', $pwd);
		$specialChars = preg_match('@[^\w]@', $pwd);

		if (!$uppercase || !$lowercase || !$number || !$specialChars || strlen($pwd) < 8) {
			return  'رمز عبور باید شامل حروف بزرگ  - کوچک اعداد و کاراکتر خاص باشد و حداقل طول آن 8 کاراکتر باشد';
		} else {
			return 'success';
		}
	}
	public static function seo_friendly_url($string)
	{
		$result  = preg_replace('/[^a-zA-Z0-9_ -]/s', '', $string);
		return $result;
	}
}
