<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';



class API_CLOUD_SERVER_ADMIN
{
	public static function GetRescue($name,$idc,$serverid,$pass,$requestid,$imageid)
	{
		$actionUrl = "api/v1/server/rescue";
		$postededata["image_id"]=$imageid;
		$postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
		$postededata["user_data"]= "#cloud-config\npassword: ".$pass."\nchpasswd: { expire: False }\nssh_pwauth: True";
		$postededata["request_id"]=$requestid;
		$postededata["server_id"]=$serverid;
		$apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut, true);
        return    $api;
		// "user_data": "#cloud-config\npassword: ".$pass."\nchpasswd: { expire: False }\nssh_pwauth: True",
		// "request_id": "requaskddjhfsjdfhsest_id"
	}
	public static function GetUnRescue($name,$idc,$serverid,$data,$requestid,$oldid)
	{
		$actionUrl = "api/v1/server/unrescue";
		$postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
		$postededata["request_id"]=$requestid;
		$postededata["rescue_server_id"]=$serverid;
		$postededata["data"]=json_decode($data);
		$postededata["server_id"]=$oldid;
		$apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut, true);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        return    $api;
	}
    public static function GetServerDetailFromAPI($name, $idc, $sid)
    {
        $actionUrl = "api/v1/server/get";
        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["id"] = $sid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut, true);
        return    $api;
    }
    public static function GetServerUsageFromAPI($idc,$start,$end)
    {
        $actionUrl = "/api/v1/server/usage";
        $postededata["from_date"]=$start;
        $postededata["to_date"]=$end;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut, true);
        return    $api;
    }
    public static function GetDiskUsage($idc,$start,$end)
    {
        $actionUrl = "/api/v1/server/disk_usage";
        $postededata["from_date"]=$start;
        $postededata["to_date"]=$end;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut, true);
        return    $api;
    }
    public static function GetAllServerDetailFromAPI($name, $idc)
    {
        $actionUrl = "api/v1/server/list";
        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc, 100);
        $api = json_decode($apiOut, true);
        return    $api;
    }

    public static function GetCloudServerReportUsage($sid, $name, $idc, $start, $end, $base, $period = "5m", $step_size = "5s")
    {
        //upload/speed
        //download/speed
        //disk_write_speed
        //disk_read_speed
        //processor
        $bases = [
            "uploadspeed" => "upload/speed",
            "downloadspeed" => "download/speed",
            "diskwrite" => "disk_write_speed",
            "diskread" => "disk_read_speed",
            "processor" => "processor"
        ];
        $actionUrl = "api/v1/server/monitor/" . $bases[$base];

        $postededata["useraccount"] = $name; //"admin";//
        $postededata["instance_name"] = $sid; //"d85ac7b0-d3a8-4336-a0eb-0ab0b0cc8d77";//
        $postededata["start_time"] = $start;
        $postededata["end_time"] = $end;
        $postededata["period"] = $period;
        $postededata["step_size"] = $step_size;


        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut, true);
        $cljs = json_encode($postededata);
        // str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);


        return    $api;
    }

    public static function RunCreateServer($name, $image_id, $email, $idcid, $flavor_id, $key_id, $networks, $security_groups, $vid, $idcStorageType, $metadata, $ip)
    {

        $actionUrl = "api/v1/server/create";
        if ($idcStorageType == 1) {
            $image_id = "";
        }
        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["name"] = $name;
        $postededata["display_name"] = $name;
        $postededata["description"] = $name;
        $postededata["image_id"] = ""; //$image_id;
        $postededata["flavor"] = $flavor_id;
        $postededata["networks"] = $networks;
        $postededata["security_groups"] = $security_groups;
        $postededata["key_id"] = $key_id;
        $postededata["block_device_mapping"] = $vid;
        // $postededata["attached_volumes"] = $vid;
        $postededata["user_data"] = $metadata;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        $api = json_decode($apiOut, true);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return    $api;
    }
    public static function RunExtendAPIVolume($id, $email, $idcid, $size)
    {

        $actionUrl = "api/v1/volume/extend";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $id;
        $postededata["size"] = $size;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        $m = json_decode($apiOut);
        //$id= $m->id;
        return    $apiOut;
    }
    public static function RunAttachFirewallToServer($name, $serverid, $firewallid, $idc)
    {
        $actionUrl = "api/v1/server/add_security_group";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["id"] = $serverid;
        $postededata["security_group"] = $firewallid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunDetachFirewallToServer($name, $serverid, $firewallid, $idc)
    {
        $actionUrl = "api/v1/server/remove_security_group";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["id"] = $serverid;
        $postededata["security_group"] = $firewallid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunAttachVolumeToServer($name, $serverid, $vlid, $idc)
    { ///api/v1/server/volume/attach
        $actionUrl = "api/v1/server/volume/attach";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["server_id"] = $serverid;
        $postededata["volume_id"] = $vlid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunGetServerMountedVolume($name,$serverid,$idc){

    }
    public static function RunDetachVolumeToServer($name, $serverid, $vlid, $idc)
    { // /api/v1/server/volume/detach
        $actionUrl = "api/v1/server/volume/detach";

        $postededata["useraccount"] = $name;
        $postededata["passcode"] = md5($name);
        $postededata["server_id"] = $serverid;
        $postededata["volume_id"] = $vlid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunHardReboot($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/hardreboot";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunPauseServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/pause_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunRebuildOS($mail, $serverid, $imageid, $idc, $type, $pass,$requestid,$Oldvolumeid)
    {
        $actionUrl = "api/v1/server/rebuild_new_image";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server_id"] = $serverid;
        $postededata["image_id"] = $imageid;
        $postededata["is_snapshot"] = "False";
        $storageType = ["nvme" => "nvme", "ssd" => "__DEFAULT__", "sas" => "sas"];
        $postededata["volume_type"] = $storageType[$type];
        $postededata["user_data"] = $pass;
        $postededata["request_id"] = $requestid;
        $postededata["Oldvolumeid"] = $Oldvolumeid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

		$cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return     $apiOut;
    }
    public static function RunSetMetaData($mail,$serverid,$key,$value,$idc){
        $actionUrl = "api/v1/server/set_meta";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $serverid;
        $postededata["metadata"][$key] = $value;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        return     $apiOut;
    }
    public static function RunDeleteMetaData($mail,$serverid,$key,$idc){
        $actionUrl = "api/v1/server/delete_meta";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $serverid;
        $postededata["metadata"]= [$key];
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        return     $apiOut;
    }
    public static function RunRestoreSnapshot($mail, $serverid, $imageid, $idc)
    {
        $actionUrl = "api/v1/server/rebuild_new_image";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server_id"] = $serverid;
        $postededata["image_id"] = $imageid;
        $postededata["is_snapshot"] = "True";
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    [$postededata, $apiOut, $idc];
    }

    public static function RunChangeHostname($id, $mail, $idc, $hostname)
    {
        $actionUrl = "api/v1/server/update_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $postededata["name"] = $hostname;
        $postededata["description"] = "VALUE";

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunStartServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/start_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunResizeServer($id, $mail, $idc, $flavordid)
    {
        $actionUrl = "api/v1/server/resize_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $postededata["flavor"] = $flavordid;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        self::ConfirmResize($id, $mail, $idc);

        return    $apiOut;
    }
    public static function ConfirmResize($id, $mail, $idc)
    {
        $actionUrl = "/api/v1/server/confirm_resize";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
    }
    public static function RunShutDownServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/stop_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunUnPauseServer($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/unpause_server";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunSoftReboot($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/softreboot";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunChangePassword($id, $mail, $idc, $password)
    {
        $actionUrl = "api/v1/server/changepassword";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;
        $postededata["password"] = $password;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $a = json_decode($apiOut, true);
        if (isset($a["status"]) && $a["status"] == "error") {
            return ["status" => "error", "message" => $a["exceptions"]];
        }
        return    ["status" => "success", "data" => json_decode($apiOut, true)];
    }
    public static function GetInterfaceList($mail, $idc, $sid)
    {
        $actionUrl =  "api/v1/server/interface/list";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }

    public static function RunAttachPublicNetworkNetwork($mail, $idc, $sid)
    {
        $actionUrl = "api/v1/server/interface/attach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["subnet_id"] = SENDAPI_MIDDLECLOUD::GetMiddleAPIInfo($idc)[1]["ci_public_network"];
        $postededata["fixed_ip"] = "";
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $cljs = str_replace("'", "\'", json_encode($postededata));
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return    $apiOut;
    }

    public static function RunAttachInternalNetwork($mail, $idc, $sid, $networkid)
    {
        $actionUrl = "api/v1/server/interface/attach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["subnet_id"] = $networkid;
        $postededata["fixed_ip"] = "";
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $cljs = str_replace("'", "\'", json_encode($postededata));
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return    $apiOut;
    }
    public static function RunDetachPublicNetwork($mail, $idc, $sid, $networkid)
    {
        $actionUrl = "api/v1/server/interface/detach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["port_id"] = $networkid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunDetachInternalNetwork($mail, $idc, $sid, $networkid)
    {
        $actionUrl = "api/v1/server/interface/detach";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["server"] = $sid;
        $postededata["port_id"] = $networkid;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        return    $apiOut;
    }
    public static function RunGetVNCConsole($id, $mail, $idc)
    {
        $actionUrl = "api/v1/server/get_vnc_console";

        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["id"] = $id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);
        $api = json_decode($apiOut);
        return    $api->url;
    }
    public static function RunRemoveVolume($id, $email, $idcid)
    {
        $actionUrl = "api/v1/volume/delete";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);

        return    $apiOut;
    }
    public static function RunDeleteServer($id, $email, $idcid)
    {
        $actionUrl = "api/v1/server/force_delete";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $id;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);

        return    $apiOut;
    }
    public static function MonitoringServer($serverid, $email, $idcid, $metric)
    {
        $actionUrl = "api/v1/server/monitor";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $serverid;
        $postededata["metric"] = $metric;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);

        return     $apiOut;
    }
}
