<html>

<head>

	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.4/css/jquery.dataTables.css">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
	<!-- jQuery library -->
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

	<!-- Latest compiled JavaScript -->
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
	<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.4/js/jquery.dataTables.js"></script>
</head>

<body>

	<?php
	// cloud\apitobackend\sendrequest\getlog.php
	require_once '../../../include/vars.php';
	require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

	$page_number = 1;
	if (isset($_GET['page'])) {
		$page_number = $_GET['page'];
	}
	$limit = 40;
	$initial_page = ($page_number - 1) * $limit;
	$total_pages = ceil(CLOUD_LOG_ADMIN::ReturnCountOfAllLogs() / $limit);

	$l = CLOUD_LOG_ADMIN::ReturnAllLogs($initial_page, $limit);
	?>

	<style>
		td {
			word-break: break-all;
		}
	</style>
	<div class="container-fluid"">
    <button class=" btn btn-md btn-success" onclick="window.location.reload()">refresh</button>
		<table id="example" class="table ">

			<thead class="thead-dark">
				<tr>
					<th style="width:10%">
						ID
					</th>

					<th class="col col-1">
						Task
					</th>

					<th class="col col-1">
						Response
					</th>

					<th class="col col-3">
						Time
					</th>

					<th class="col col-1">
						Response Time
					</th>

					<th class="col col-1">
						ActionUrl
					</th>
				</tr>
			</thead>
			<?php

			foreach ($l as $b) {
				$resp=json_decode($b["clresponse"],true);
				$json_pretty = json_encode($resp, JSON_PRETTY_PRINT);
				$state="table-danger";
				if(isset($resp["status"]) && $resp["status"]!="error"){
					$state="table-success";
				}
				echo
				  '<tr class="'.$state.'">
                <td>
                    ' . $b["clid"] . '
                </td>

                <td>
                    ' . $b["claction"] . '
                </td>

                <td>
					<pre>' . $b["clresponse"].' </pre>
                </td>

                <td>
                    ' . $b["cldatetime"] . '
                </td>

                <td>
                    ' . $b["d_lastupdate"] . '
                </td>

                <td>
                    ' . $b["cl_action_url"] . '
                </td>
            </tr>';
			}

			?>
		</table>

	</div>
	<?php
	for ($page_number = 1; $page_number <= $total_pages; $page_number++) {

		echo '<a class="btn btn-info" href = "index.php?page=' . $page_number . '">' . $page_number . ' </a>';
	}
	?>
</body>

</html>
