<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/wafcustomrules/wafcustomrules_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';

class WAFCUSTOMRULES_ADMIN
{
    public static function GetRuleByID($websiteid, $token, $ruleid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $uc = WEBSITES_ADMIN::UserCanAccessToWebsiteWithToken($websiteid, $token);
        if ($uc["status"] == "error") {
            return ["status" => "error", "message" => "شما امکان دسترسی یه این سایت را ندارید"];
        }

        $sql = "SELECT *  from " . $GLOBALS["waf_customrules_tablename"] . " WHERE " .
            $GLOBALS['wcr_websiteid'] . "=" . $websiteid . " and
            " . $GLOBALS["wcrid"] . "=" . $ruleid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                $sql,
                "status" => "error",
                "message" => "شما اجازه دسترسی به این فانون را ندارید  "
            ];
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "state" => "200",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $list
            ];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetListOfRules($websiteid, $token)
    {
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
                ];
            }

            $uid = $usersDetails["userdetail"][0]["uid"];

            $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
            if ($websitesOwner["status"] == "error") {
                return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ", $websitesOwner];
            }
        }

        $sql = "SELECT *  FROM " . $GLOBALS["waf_customrules_tablename"] . " WHERE " .
            $GLOBALS['wcr_websiteid'] . "=" . $websiteid . " ORDER BY " . $GLOBALS['wcr_waf_level'] . "," .
            $GLOBALS['wcr_rulename'];
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "state" => "201",
                "message" => "شما قانونی ایجاد نکرده اید "
            ];
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success", "state" => "200",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $list
            ];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckRuleDuplicated($websiteid, $rulename, $rulekey, $waflevel, $rulevalue)
    {
        $sql = "SELECT *  FROM " . $GLOBALS["waf_customrules_tablename"] . " WHERE " .
            $GLOBALS['wcr_websiteid'] . "=" . $websiteid . " AND wcr_rulename='".$rulename."' and wcr_rulekey='".$rulekey."' and wcr_rulevalue='".$rulevalue."'
            and wcr_waf_level=".$waflevel;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success"
            ];
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "error"
            ];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function AddNewRules($token, $websiteid, $rulename, $waflevel, $rulekey, $rulevalue)
    {

        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
                ];
            }

            $uid = $usersDetails["userdetail"][0]["uid"];

            $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
            if ($websitesOwner["status"] == "error") {
                return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ", $websitesOwner];
            }
        }
        $validRulenName = ["disable", "posted_fields", "referer", "ip", "url", "wildurl"];
        if (!in_array($rulename, $validRulenName)) {
            return ["status" => "error", "message" => "قانون درخواستی شما نامعتبر است"];
        }
        $validWafLevel = ["1", "2", "3"];
        if (!in_array($waflevel, $validWafLevel)) {
            return ["status" => "error", "message" => "waf درخواستی شما نامعتبر است"];
        }
        $activewaf = WAF_ADMIN::GetListOfActiveWaf($token, $websiteid);
        if ($activewaf["status"] == "error") {
            return $activewaf;
        }
        if($activewaf["data"][0]["WafLevel"]!=3){
            if ($activewaf["data"][0]["WafLevel"] != $waflevel) {
                return ["status" => "error", "message" => "قانون درخواستی شما با وف فعال شما مطابقت ندارد"];
            }
        }
        if(self::CheckRuleDuplicated($websiteid, $rulename, $rulekey, $waflevel, $rulevalue)["status"]=="error"){
            return ["status" => "error", "message" => "قانون درخواستی شما تکراری است"];
        }
        $sql = "INSERT INTO " . $GLOBALS['waf_customrules_tablename'] . "
        (" . $GLOBALS['wcrid'] . "," . $GLOBALS['wcr_websiteid'] . "," . $GLOBALS['wcr_rulename'] . "," .
            $GLOBALS['wcr_rulekey'] . "," . $GLOBALS['wcr_rulevalue'] . "," . $GLOBALS['wcr_waf_level'] . "
                  ) VALUES (0," . $websiteid . ",'" . $rulename . "','" .  $rulekey . "','" . $rulevalue . "',
                  '" . $waflevel . "')";
        $conn = GetConnection();
        $conn->query($sql);
        $id = $conn->insert_id;
        $conn->close();
        self::RunAddByTypes($websiteid, $rulename, $websitesOwner);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "id" => $id];
    }
    public static function RunAddByTypes($websiteid, $type, $websitesOwner)
    {

        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        $a = self::GetListOfRules($websiteid, "12");
        $output = "";
        $m = "";
        if ($a["state"] == "200") {
            foreach ($a["data"] as $b) {
                $m .= $b["wcr_rulename"] . "////";
                if ($b["wcr_rulename"] == $type) {
                    if ($type == "posted_fields") {
                        $output .= $b["wcr_rulevalue"] . "," . $b["wcr_rulevalue"] . ";";
                    } else {
                        $output .= $b["wcr_rulevalue"] . ";";
                    }
                }
            }
            $output = substr($output, 0, strlen($output) - 1);
            $s = API_WAFRULES_ADMIN::RunCreateAPIRulesManagement($dmn, "1", $output, $type);
            return ["s" => $s, "a" => $a, "m", $m, "t" => $type, "C" => count($a["data"]), "d" => $dmn, "o" => $output];
        } else {
            API_WAFRULES_ADMIN::RunRemoveAPIRulesManagement($dmn, "1", $type);
            return ["status" => "success"];
        }
    }

    public static function UpdateRules(
        $token,
        $ruleid,
        $websiteid,
        $rulename,
        $waflevel,
        $rulekey,
        $rulevalue
    ) {
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
                ];
            }

            $uid = $usersDetails["userdetail"][0]["uid"];

            $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
            if ($websitesOwner["status"] == "error") {
                return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ", $websitesOwner];
            }
        }
        $validRulenName = ["disable", "posted_fields", "referer", "ip", "url", "wildurl"];
        if (!in_array($rulename, $validRulenName)) {
            return ["status" => "error", "message" => "قانون درخواستی شما نامعتبر است"];
        }
        $validWafLevel = ["1", "2", "3"];
        if (!in_array($waflevel, $validWafLevel)) {
            return ["status" => "error", "message" => "waf درخواستی شما نامعتبر است"];
        }
        $activewaf = WAF_ADMIN::GetListOfActiveWaf($token, $websiteid);
        if ($activewaf["status"] == "error") {
            return $activewaf;
        }
        if ($activewaf["data"][0]["WafLevel"] != $waflevel) {
            return ["status" => "error", "message" => "قانون درخواستی شما با وف فعال شما مطابقت ندارد"];
        }

        $wafDet = self::GetRuleByID($websiteid, $token, $ruleid);
        if ($wafDet["status"] == "error") {
            return ["status" => "error", "message" => "شما امکان دسترسی به این قانون را ندارید"];
        }
        $sql = "UPDATE " . $GLOBALS["waf_customrules_tablename"] . " SET "
            . $GLOBALS['wcr_rulevalue'] . "=" . $rulevalue . " , " .
            $GLOBALS['wcr_rulekey'] . "=" . $rulekey . " WHERE " . $GLOBALS['wcrid'] . "=" . $ruleid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
    public static function RemoveRules($token, $ruleid, $websiteid)
    {
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
                ];
            }

            $uid = $usersDetails["userdetail"][0]["uid"];

            $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
            if ($websitesOwner["status"] == "error") {
                return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ", $websitesOwner];
            }
        }
        $wafDet = self::GetRuleByID($websiteid, $token, $ruleid);

        if ($wafDet["status"] == "error") {
            return ["status" => "error", "message" => "شما امکان دسترسی به این قانون را ندارید"];
        }

        $ins = "DELETE FROM   " . $GLOBALS["waf_customrules_tablename"] . " WHERE " .
            $GLOBALS["wcrid"] . "=" . $ruleid;
        $conn = GetConnection();
        $conn->query($ins);
        $conn->close();
        self::RunAddByTypes($websiteid, $wafDet["data"][0]["wcr_rulename"], $websitesOwner);
        return ["status" => "success", $ins, "message" => "قانون درخواستی شما با موفقیت حذف شد"];
    }
}
