<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/underattack/underattack_filed_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/underattackmode/underattackmode.php';

class UnderAttack_ADMIN
{

    public static function CheckUnderAttackForDownGrade($domainID, $currentPlan, $newPlan)
    {
        $currentPlanUnderAttachMode = ReturnPlans()[$currentPlan]["ddos"];
        $NewPlanUnderAttachMode = ReturnPlans()[$newPlan]["ddos"];
        $sql = "SELECT * FROM `tbl_underattack`,tbl_websites,tbl_domains WHERE
                            domain_id=ws_domainid_fk and ua_wid_fk=wsid and domain_id=" . $domainID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "success"];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            foreach ($r as $f) {
                if ($f["ua_status"] > $NewPlanUnderAttachMode) {
                    $websitename = $f["d_name"];
                    if ($f["d_name"] != $f["ws_recordname"]) {
                        $websitename = $f["ws_recordname"] . "." . $f["d_name"];
                    }
                    return ["status" => "error", "message" => "حالت انتخاب شده شما برای DDOS سایت " . $websitename . " بالاتر پلان درخواستی شماست"];
                }
            }
            $listOfRecordType = [
                "status" => "success",
                "data" => $r
            ];
            $conn->close();
        }
        return ["status" => "success"];
    }
    public static function GetWebsiteUnderAttack($token, $websiteid)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT ua_status as UnderAttackStatus ,ua_ttl as ttl  FROM " . $GLOBALS["unserattack_tablename"] .
            " WHERE " . $GLOBALS["ua_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "data" => ["UnderAttackStatus" => "deactive"]
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => ["UnderAttackStatus" => "level" . $r[0]["UnderAttackStatus"], "ttl" => $r[0]["ttl"]]
            ];
            $conn->close();
        }

        return $listOfRecordType;
    }

    public static function UpdateWebsiteUnderAttack($token, $websiteid, $status, $ttl)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        if ($status == "") {
            return ["status" => "error", "message" => "امکان خالی بودن وضعیت وجود ندارد"];
        }

        $allowedstatus = ["1", "2", "3"];

        $planwebsite = $websitesOwner["data"][0]["wsplan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (isset($plans[$planwebsite]["ddos"])) {
                if (intVal($status) > intVal($plans[$planwebsite]["ddos"])) {
                    return ["status" => "error", "message" => "شما امکان انتخاب این مورد را ندارید و باید پلان سایت خود را ارتقا دهید"];
                }
            } else {
                return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }

        $methods = explode(",", $status);
        $res = [];
        $stat = 1;
        foreach ($methods as $method) {
            if (!in_array(strtoupper($method), $allowedstatus)) {
                $stat = 0;
                array_push(
                    $res,
                    ["status" => "error", "status" => $status, "message" => "وضعیت نامعتبر است"]
                );
            }
        }

        if ($stat == 0) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی", "UnderAttackMode" => $res];
        }
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["unserattack_tablename"] .
            " WHERE " . $GLOBALS["ua_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["unserattack_tablename"] . " (" . $GLOBALS['ua_wid_fk'] . "," . $GLOBALS['ua_status'] . "," . $GLOBALS['ua_ttl'] . ")
                VALUE ('" . $websiteid . "','" . $status . "','" . $ttl . "')";
            API_UNDERATTACKMODE_ADMIN::RunCreateAPIUNDERATTACKMODE($dmn, $status, null,null,$ttl);
        } else {
            $ins = "UPDATE " . $GLOBALS["unserattack_tablename"] . " SET " .
                $GLOBALS['ua_status'] . "='" . $status . "'," .
                $GLOBALS['ua_ttl'] . "='" . $ttl . "'
                        WHERE " . $GLOBALS['ua_wid_fk'] . "=" . $websiteid;
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            if(isset($plans[$planwebsite]["ddostime"]) && intVal($plans[$planwebsite]["ddostime"]) > 0){
                $ttl=intVal($plans[$planwebsite]["ddostime"]);
            }
            $b = API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, $r[0]["ua_status"], null);
            $a = API_UNDERATTACKMODE_ADMIN::RunCreateAPIUNDERATTACKMODE($dmn, $status, null,null,$ttl);

            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای  فشرده سازی  ایجاد نکرده اید "
            ];
        }
        $conn->query($ins);
        $conn->close();

        return ["status" => "success",   "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RemoveUnderAttackMode($token, $websiteid, $level)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["unserattack_tablename"] .
            " WHERE " . $GLOBALS["ua_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای این بخش ایجاد نکرده اید "
            ];

            $conn->close();
        } else {
            $sql = "DELETE  FROM " . $GLOBALS["unserattack_tablename"] .
                " WHERE " . $GLOBALS["ua_wid_fk"] . "=" . $websiteid;
            $result = $conn->query($sql);
            $conn->close();
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, $level, null);
        }

        return $listOfRecordType;
    }
}
