<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supportticketsdepartment/admin/supportticketsdepartment_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supporttickets/supporttickets_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supportticketsreplies/admin/supportticketsreplies_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/attachments/admin/attachments_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supportticketsattachments/admin/supportticketsattachments_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/admin/admin/admin_admin_class.php';

class SUPPORTPLANS
{
    public static function GetListOfPlans(){
        $sql = "SELECT * FROM  tbl_support_plans ";
            $conn = GetConnection();
            $result = mysqli_query($conn, $sql);
            return ["status"=>"success","data"=>mysqli_fetch_all($result, MYSQLI_ASSOC)];
    }
    public static function GetListAll(){
        $sql = "SELECT * FROM  tbl_support_plans_users ";
            $conn = GetConnection();
            $result = mysqli_query($conn, $sql);
            return ["status"=>"success","data"=>mysqli_fetch_all($result, MYSQLI_ASSOC)];
    }
    public static function GetList($token)
    {
        $userExist = USERS_ADMIN::GetOneByToken($token);
        if ($userExist["status"] == "error") {
            $result = ["status" => "error", "result" => "توکن ارسالی نامعتبر است"];
            return $result;
        } else {
            $uid = $userExist["userdetail"][0]["uid"];
            $sql = "SELECT * FROM tbl_support_plans_users,tbl_support_plans where spid=spu_spid_fk and spu_uidfk=".$uid;
            $conn = GetConnection();
            $result = mysqli_query($conn, $sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                 self::AddDefault($uid);
                 return self::GetList($token);
                $result = ["status" => "error", "code" => "201", "message" => "اطلاعاتی جهت نمایش وجود ندارد"];
                return $result;
            } else {
                $listOfRecordType = [
                    "status" => "success",
                    "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
                ];
            }
            $result->free_result();
            $conn->close();
            return $listOfRecordType;
        }
    }
    public static function AddDefault($uid){
        $exp = date("Y/m/d", strtotime("+1 month"));
        $sql="INSERT INTO `tbl_support_plans_users`(`spuid`, `spu_uidfk`, `spu_spid_fk`, `spu_expiredate`) VALUES (0,".$uid.",3,'".$exp."')";
        $conn = GetConnection();
        mysqli_query($conn, $sql);
        $conn->close();
        return null;
    }
    public static function RenewPlan($planid,$uid){
        $exp = date("Y/m/d", strtotime("+1 month"));
            $userExist=USERS_ADMIN::GetOneByUID($uid);
            $uid = $userExist["userdetail"][0]["uid"];
            $planDetails=self::GetPlan($planid);

            $planName=$planDetails["data"][0]["spname"];
            if($planDetails["status"]=="error"){
                return ["status" => "error", "message" => "پلان ارسالی نامعتبر است"];
            }

            $planPrice=$planDetails["data"][0]["spprice"];
            $userCredit=$userExist["credit"];

            if(intVal($userCredit) < $planPrice){
                $sql="UPDATE tbl_support_plans_users set spu_spid_fk=1 where uid=".$uid;
                $conn = GetConnection();
                mysqli_query($conn, $sql);
                $conn->close();
                return ;
            }

            $currentPlan=self::GetList($token);
            $now=   date("Y-m-d");
                    $sql="UPDATE  tbl_support_plans_users SET spu_spid_fk=".$planid.",spu_expiredate= '".$exp."' WHERE spu_uidfk=".$uid;
                    CREADITDETAILS_ADMIN::AddCreditDetails("خرید یا تمدید پلان پشتیبانی  ".
                    $planName
                    ." تا تاریخ  : "
                    .$exp,$planPrice*(-1),$uid,9);
                    $conn = GetConnection();
                    mysqli_query($conn, $sql);
                    $conn->close();
                    return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد"];
    }
    public static function AddPlans($token, $planid)
    {
        $exp = date("Y/m/d", strtotime("+1 month"));
        $userExist = USERS_ADMIN::GetOneByToken($token);
        if ($userExist["status"] == "error") {
            $result = ["status" => "error", "result" => "توکن ارسالی نامعتبر است"];
            return $result;
        } else {
            $uid = $userExist["userdetail"][0]["uid"];
            $planDetails=self::GetPlan($planid);

            $planName=$planDetails["data"][0]["spname"];
            if($planDetails["status"]=="error"){
                return ["status" => "error", "message" => "پلان ارسالی نامعتبر است"];
            }

            $planPrice=$planDetails["data"][0]["spprice"];
            $userCredit=$userExist["credit"];

            if(intVal($userCredit) < $planPrice){
                return ["status"=>"error",
                "price"=>$planPrice,
                "message"=>"حداقل اعتبار برای این پلان پشتیبانی مبلغ".
                number_format($planPrice)." ریال میباشد"
                ];
            }

            $currentPlan=self::GetList($token);
            $dts= date_create($currentPlan["data"][0]["spu_expiredate"]);
            $expiredate= date_format($dts,"Y-m-d");

            $now=   date("Y-m-d");
            if($planid < $currentPlan["data"][0]["spid"] ){
                //DownGrade
                if($now <= $expiredate){
                    return ["status"=>"error"
                    ,"now"=>$now,
                    "exp"=>$expiredate
                    ,"message"=>"شما تا پایان دوره پشتیبانی امکان کاهش را ندارید"];
                }
                else{
                    $sql="UPDATE  tbl_support_plans_users SET spu_spid_fk=".$planid.",spu_expiredate= '".$exp."' WHERE spu_uidfk=".$uid;
                    CREADITDETAILS_ADMIN::AddCreditDetails("خرید یا تمدید پلان پشتیبانی  ".
                    $planName
                    ." تا تاریخ  : "
                    .$exp,$planPrice*(-1),$uid,9);
                    $conn = GetConnection();
                    mysqli_query($conn, $sql);
                    $conn->close();
                    return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد"];
                    //ADD NEW PLAN
                }
            }
            else{
                //UPGRADE
                 if($now <= $expiredate){
                    //UPGRADE PLAN
                    $date1=date_create($expiredate);
                    $date2=date_create($now);
                    $daysOfCurrentPlan=  date_diff($date1,$date2)->days;
                    $currentPlanPrice=$currentPlan["data"][0]["spprice"];
                    $amountOfCredit=intVal($currentPlanPrice)/30;
                    $neededAmount=intVal($amountOfCredit)*$daysOfCurrentPlan - $planPrice;
                    if(intVal($userCredit) < intVal($amountOfCredit)){
                        return ["status"=>"error",
                        "price"=>$planPrice,
                        "message"=>"حداقل اعتبار برای این پلان پشتیبانی مبلغ".
                        number_format($neededAmount)." ریال میباشد"
                        ];
                    }
                      $sql="UPDATE  tbl_support_plans_users SET spu_spid_fk=".$planid.",spu_expiredate= '".$exp."' WHERE spu_uidfk=".$uid;
                    CREADITDETAILS_ADMIN::AddCreditDetails("خرید یا تمدید پلان پشتیبانی  ".
                    $planName
                    ." تا تاریخ  : "
                    .$exp,$neededAmount,$uid,9);
                    $conn = GetConnection();
                    mysqli_query($conn, $sql);
                    $conn->close();
                    return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد"];

                    return [ date_diff($date1,$date2)->days,intVal($neededAmount),$currentPlan];
                }
                else{
                    $sql="UPDATE  tbl_support_plans_users SET spu_spid_fk=".$planid.",spu_expiredate= '".$exp."' WHERE spu_uidfk=".$uid;
                    CREADITDETAILS_ADMIN::AddCreditDetails("خرید یا تمدید پلان پشتیبانی  ".
                    $planName
                    ." تا تاریخ  : "
                    .$exp,$planPrice*(-1),$uid,9);
                    $conn = GetConnection();
                    mysqli_query($conn, $sql);
                    $conn->close();
                    return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد"];
                }
            }
            return $currentPlan;
        }
    }
    public static function GetPlan($planid)
    {
        $sql = "SELECT * FROM tbl_support_plans where spid=" . $planid;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data"=>mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }

}
