<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class RATELIMITSUBFOLDER_ADMIN
{

    public static function GetWebsiteRateLimit($token, $subfolderid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "آدرس فرعی درخواستی شما اشتباه است"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["ratelimitsubfolder_tablename"] .
            " WHERE " . $GLOBALS["rl_sfid_fk"] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید"
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $rangeips = $r[0]["rlsfipranges"];
            $rgip = [];
            $ips = explode(",", $rangeips);
            foreach ($ips as $ip) {
                array_push($rgip, $ip);
            }
            unset($r[0]["rlsfipranges"]);
            $r[0]["rangeips"] = $rgip;
            $listOfRecordType = [
                "status" => "success", "code" => "200",
                // "countofrules"=>count($r),
                "data" => $r[0]
            ];
            $conn->close();
        }
        return $listOfRecordType;
    }

    public static function UpdateWebsiteRateLimit($token, $subfolderid, $rtimeformat, $rate, $burst, $burstcount, $ipranges, $priority)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $websitesOwner = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "آدرس فرعی درخواستی شما اشتباه است"];
        }

        $planwebsite = $websitesOwner["data"][0]["d_plan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (!isset($plans[$planwebsite]["ratelimit"])) {
                return [
                    "status" => "error", "action" => "needtoupgrade", $planwebsite, $websitesOwner,
                    "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید "
                ];
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }
        if (!in_array($rtimeformat, ['s', 'm']))
            return ["status" => "error", "message" => "مقدار ارسالی برای فرمت زمانی نامعتبر است"];

        if (!is_numeric($rate))
            return ["status" => "error", "message" => "مقدار ارسالی برای ایجاد محدودیت در تعداد درخواست باید عدد باشد "];
        if (!in_array($burst, ["false", "true"]))
            return ["status" => "error", "message" => "مقدار ارسالی برای Burst اشتباه است"];

        if (!is_numeric($burstcount))
            return ["status" => "error", "message" => "مقدار ارسالی برای ایجاد محدودیت در تعداد درخواست همزمان باید عدد باشد"];

        if ($ipranges != "") {
            $ipes = explode(",", $ipranges);
            $ips = array_unique($ipes);

            $res = [];
            $stat = 1;
            foreach ($ips as $ip) {
                if (strpos($ip, '/')) {
                    $nip = explode("/", $ip);
                    if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push($res, ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]);
                    }
                } else {
                    if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push($res, ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]);
                    }
                }
            }

            if ($stat == 0) {
                return ["status" => "error", "message" => "خطا در IPهای ارسالی ", "data" => $res];
            }
            $ipranges=implode(",",$ips);
        }

        $sql = "SELECT * FROM " . $GLOBALS["ratelimitsubfolder_tablename"] . " WHERE " . $GLOBALS["rl_sfid_fk"] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $nm = str_replace("/", "_", $websitesOwner["data"][0]["sf_name"]);
        $rname = $nm . "_" . $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"] . "_ratelimit";
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["ratelimitsubfolder_tablename"] . " (" . $GLOBALS['rlsfname'] . "," . $GLOBALS['rlsftimerate'] . "," . $GLOBALS['rlsfrate'] . "," .
                $GLOBALS['rlsfburst'] . "," . $GLOBALS['rlsfburstcount'] . "," . $GLOBALS['rlsfipranges'] . "," . $GLOBALS['rl_sfid_fk'] . ")
                                            VALUE ('" . $rname . "','" . $rtimeformat . "'," . $rate . "," . $burst . "," . $burstcount . ",'" . $ipranges . "'," . $subfolderid . ")";
            SUBFOLDERRULES_ADMIN::UpdateArrayinDB($subfolderid, "add", "ratelimit");
        } else {
            $ins = "UPDATE " . $GLOBALS["ratelimitsubfolder_tablename"] . " SET " . $GLOBALS['rlsfname'] . "='" . $rname . "'," . $GLOBALS['rlsftimerate'] . "='" . $rtimeformat . "'," .
                $GLOBALS['rlsfrate'] . "=" . $rate . "," . $GLOBALS['rlsfburst'] . "=" . $burst . "," .
                $GLOBALS['rlsfburstcount'] . "=" . $burstcount . "," . $GLOBALS['rlsfipranges'] . "='" . $ipranges . "' WHERE " . $GLOBALS['rl_sfid_fk'] . "=" . $subfolderid;
            SUBFOLDERRULES_ADMIN::UpdateArrayinDB($subfolderid, "add", "ratelimit");
        }
        $ip = str_replace(",", ";", $ipranges);
        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        $brs = 10;
        if ($burst == "true")
            $brs = $burstcount;

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);

        API_RATELIMIT_ADMIN::RunCreateAPIRATELIMIT($dmn, $rname, $rate, $rtimeformat, $brs, "/" . $requiredData[0]["sf_name"], $ip, $priority);
        $conn->query($ins);
        $conn->close();

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RemoveRateLimit($token, $subfolderid, $priority)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "آدرس فرعی درخواستی شما اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["ratelimitsubfolder_tablename"] .
            " WHERE " . $GLOBALS["rl_sfid_fk"] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید "
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $sql = "DELETE  FROM " . $GLOBALS["ratelimitsubfolder_tablename"] .
                " WHERE " . $GLOBALS["rl_sfid_fk"] . "=" . $subfolderid;
            $result = $conn->query($sql);
            $conn->close();
            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            API_RATELIMIT_ADMIN::RunDisableAPIRATELIMIT($dmn, $r[0]["rlsfname"], $priority);
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            SUBFOLDERRULES_ADMIN::UpdateArrayinDB($subfolderid, "remove", "ratelimit");
        }

        return $listOfRecordType;
    }
}
