<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/gzip/gzip_filed_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/gzip/gzip.php';

class GZIP_ADMIN
{

    public static function GetWebsiteGZIP($token, $websiteid)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT gstatus as GzipStatus FROM " . $GLOBALS["gzip_tablename"] .
            " WHERE " . $GLOBALS["g_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "data" => ["GzipStatus" => "active"]
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $r[0]
            ];
            $conn->close();
        }

        return $listOfRecordType;
    }

    public static function UpdateWebsiteGzip($token, $websiteid, $status)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        if ($status == "") {
            return ["status" => "error", "message" => "امکان خالی بودن وضعیت وجود ندارد"];
        }

        $allowedstatus = ["ACTIVE", "DEACTIVE"];

        $methods = explode(",", $status);
        $res = [];
        $stat = 1;
        foreach ($methods as $method) {
            if (!in_array(strtoupper($method), $allowedstatus)) {
                $stat = 0;
                array_push(
                    $res,
                    ["status" => "error", "status" => $status, "message" => "وضعیت نامعتبر است"]
                );
            }
        }

        if ($stat == 0) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی", "gzip" => $res];
        }

        $sql = "SELECT * FROM " . $GLOBALS["gzip_tablename"] .
            " WHERE " . $GLOBALS["g_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["gzip_tablename"] . " (" . $GLOBALS['g_wid_fk'] . "," . $GLOBALS['gstatus'] . ")
                    VALUE ('" . $websiteid . "','" . $status . "')";
        } else {
            $ins = "UPDATE " . $GLOBALS["gzip_tablename"] . " SET " . $GLOBALS['gstatus'] . "='" . $status . "'
                            WHERE " . $GLOBALS['g_wid_fk'] . "=" . $websiteid;
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای  فشرده سازی  ایجاد نکرده اید "
            ];
        }
        $conn->query($ins);
        $conn->close();
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        if (strtolower($status) == "active")
            API_GZIP_ADMIN::RunCreateAPIGZIP($dmn);
        else
            API_GZIP_ADMIN::RunDisableAPIGZIP($dmn);
        LOGS_ADMIN::AddLog($status . " کردن gzip " . $dmn, $uid, 0, "", "users");

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RemoveGzip($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["gzip_tablename"] .
            " WHERE " . $GLOBALS["g_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای فشرده سازی ایجاد نکرده اید "
            ];
            $conn->close();
        } else {
            $sql = "DELETE  FROM " . $GLOBALS["gzip_tablename"] .
                " WHERE " . $GLOBALS["g_wid_fk"] . "=" . $websiteid;
            $result = $conn->query($sql);
            $conn->close();
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            $dmn = "";
            if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
                $dmn = $websitesOwner["data"][0]["d_name"];
            } else {
                $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
            }
            API_GZIP_ADMIN::RunDisableAPIGZIP($dmn);
        }

        LOGS_ADMIN::AddLog("حذف کردن gzip " . $dmn, $uid, 0, "", "users");

        return $listOfRecordType;
    }
}
