from rest_framework.permissions import BasePermission
from usermanagement.models import Users, Roles, Permissions, PermissionUsers, PermissionRoles
from rest_framework.response import Response
from rest_framework.exceptions import PermissionDenied


class CheckUserAccessLevel(BasePermission):
    
    def has_object_permission(self, request, view, obj):
        user_object = Users.objects.filter(user_name__exact=request.user).values_list('id', 'group_permission', 'role_id')
        userid = user_object[0][0]
        user_group_permission = user_object[0][1]
        user_department = user_object[0][2]
        permissionid = Permissions.objects.filter(name__exact=obj).values_list('id', flat=True)
        if user_group_permission:
            perm_user = PermissionRoles.objects.filter(permission_id__exact=permissionid[0], role_id__exact=user_department)
            if perm_user.count() > 0:
                return True
        else:
            perm_user = PermissionUsers.objects.filter(user_id__exact=userid, permission_id__exact=permissionid[0])
            if perm_user.count() > 0:
                return True
        raise PermissionDenied(detail={'result': 'false', 'message': 'دسترسی کاربر محدود شده است'})


def check_admin_permission(user_id, user_object, rolename):
    is_admin = False
    user_object = user_object.values_list('id', 'group_permission', 'role_id')
    permissionid = Permissions.objects.filter(name__exact=rolename).values_list('id', flat=True)
    if user_object[0][1]:
        perm_user = PermissionRoles.objects.filter(permission_id__exact=permissionid[0], role_id__exact=user_object[0][2])
        if perm_user.count() > 0:
            return True
    else:
        perm_user = PermissionUsers.objects.filter(user_id__exact=user_id, permission_id__exact=permissionid[0])
        if perm_user.count() > 0:
            return True
    return False

