import requests
import json
import environ
import os
from mysgi_api.settings.base import BASE_DIR
import urllib.request
import http.cookiejar
import logging


env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))

class Kerio:
    def __init__(self):
        jar = http.cookiejar.CookieJar()
        opener = urllib.request.build_opener(urllib.request.HTTPCookieProcessor(jar))
        urllib.request.install_opener(opener)
        
        self.api_cookie = '/tmp/kerio-api-cookie'
        self.api_host_name = env('KERIO_HOSTNAME')
        self.api_url = env('KERIO_ADDRESS')
        self.api_user = env('KERIO_USER')
        self.api_password = env('KERIO_PASS')
        
        
    def callMethod(self, method, params, token = None):
    
        data =  {"method": method ,"id":1, "jsonrpc":"2.0", "params": params}
            
        req = urllib.request.Request(url = self.api_url)
        req.add_header('Content-Type', 'application/json')
        if (token is not None):
            req.add_header('X-Token', token)    
        
        httpResponse = urllib.request.urlopen(req, json.dumps(data).encode())
        
        if (httpResponse.status == 200):
            body = httpResponse.read().decode()
            return json.loads(body)

    def get_kerio_summary(self, email):
        answer = self.get_user_statistics(email)
        print(answer)
        if answer[0]:
            pass
        else:
            return [False, 'ارور رخ داده است']
        user_stats = answer[1]
        if len(user_stats['result']['list']) > 0:
            today_statistic = round(user_stats['result']['list'][0]['data']['today'])
            week_statistic = round(user_stats['result']['list'][0]['data']['week'])
            month_statistic = round(user_stats['result']['list'][0]['data']['month'])
        else:
            today_statistic = 0
            week_statistic = 0
            month_statistic = 0
        quota = user_stats.get('quota', 0)
        
        active_hosts = answer[2]
        last_hosts = list()
        for host in active_hosts['result']['list']:
            last_hosts.append(
                {
                    'ip': host['ip'],
                    'usage': host['totalDownload'] + host['totalUpload']
                }
            )
        
        return [True, {
            'net_usage': {
                'today': self.format_size_units(today_statistic),
                'week': self.format_size_units(week_statistic),
                'month': self.format_size_units(month_statistic * 1024),
                'quota': quota,
            },
            'active_hosts': {
                'total_items': active_hosts['result']['totalItems'],
                'list': last_hosts
            }
        }]

    def format_size_units(self, bytes):
        if bytes >= 1073741824:
            return f'{bytes / 1073741824:.2f} گیگابایت'
        elif bytes >= 1048576:
            return f'{bytes / 1048576:.2f} مگابایت'
        elif bytes >= 1024:
            return f'{bytes / 1024:.2f} کیلوبایت'
        elif bytes > 1:
            return f'{bytes} بایت'
        elif bytes == 1:
            return f'{bytes} بایت'
        else:
            return '0 بایت'

    def get_user_statistics(self, email):
        
        session = self.callMethod("Session.login", {"userName": self.api_user, "password": self.api_password, "application":{"vendor":"Kerio", "name":"Sample app", "version":"1.0"}})
        logger = logging.getLogger(__name__)
        logger.error(str(session))
        if 'result' not in session:
            return [False, False]
        token = session["result"]["token"]
        
        user_stats = self.callMethod(
            "UserStatistics.get", 
            { 
                "domainId": "15", 
                "query": {
                    "limit": -1, 
                    "start": 0, 
                    "conditions": [
                        {
                            "comparator": "Like", 
                            "fieldName": "userName", 
                            "value": email
                        }
                    ] 
                },
                "orderBy": {
                    "columnName": "fullName",
                    "direction": "Asc"
                },
                "refresh": True
            }, 
            token
        )
        active_hosts = self.callMethod(
            "ActiveHosts.get", 
            {
                "domainId": "15", 
                "query": {
                    "limit": 2000,
                    "combining": "Or", 
                    "start": 0, 
                    "conditions": [
                        {
                            "comparator": "Like", 
                            "fieldName": "QUICKSEARCH", 
                            "value": email
                        }
                    ] 
                },
                "orderBy": [
                    {
                        "columnName": "currentDownload",
                        "direction": "Desc"
                    },
                ],
                "refresh": True
            }, 
            token
        )
        self.callMethod("Session.logout",{}, token)
        return [True, user_stats, active_hosts]

    def get_active_hosts(self, email):
        
        session = self.callMethod("Session.login", {"userName": self.api_user, "password": self.api_password, "application":{"vendor":"Kerio", "name":"Sample app", "version":"1.0"}})
        logger = logging.getLogger(__name__)
        logger.error(str(session))
        if 'result' not in session:
            return [False, False]
        token = session["result"]["token"]
        print(token)
        api_query = self.callMethod(
            "ActiveHosts.get", 
            {
                "domainId": "15", 
                "query": {
                    "limit": 2000,
                    "combining": "Or", 
                    "start": 0, 
                    "conditions": [
                        {
                            "comparator": "Like", 
                            "fieldName": "QUICKSEARCH", 
                            "value": email
                        }
                    ] 
                },
                "orderBy": [
                    {
                        "columnName": "currentDownload",
                        "direction": "Desc"
                    },
                ],
                "refresh": True
            }, 
            token
        )
        self.callMethod("Session.logout",{}, token)
        return [True, api_query]

