from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import Notification
from django.dispatch import Signal
from usermanagement.models import Users


announcement_created = Signal()
announcement_deleted = Signal()

@receiver(announcement_created)
def handle_announcement_created(sender, title, tid, **kwargs):
    all_users = Users.objects.all().values('id')
    for user in all_users:
        Notification.objects.create(
            user_id=user['id'],
            message=title,
            department="منابع انسانی",
            notif_id=tid
        )


@receiver(announcement_deleted)
def handle_announcement_deleted(sender, tid, **kwargs):
    Notification.objects.filter(
        notif_id=str(tid)
    ).delete()
