<?php
	defined( 'ABSPATH' ) || exit;

	// registered

	if( mfn_is_registered() ){
		$registered = __('فعال', 'betheme');
	} else {
		$registered = __('unregistered', 'betheme');
	}

	// theme support

	$disable = mfn_opts_get('theme-disable');
?>

<header class="mfn-dashboard-menu">

	<?php
		$logo = '<div class="logo '. $registered .'"></div>';

		if( ! WHITE_LABEL ){
			echo apply_filters('betheme_logo', $logo);
		}
	?>

	<div class="menu-wrapper">

		<ul class="dashboard-menu">
			<li data-page="dashboard"><a href="admin.php?page=<?php echo apply_filters('betheme_dynamic_slug', 'betheme'); ?>"><span class="mfn-icon mfn-icon-dashboard"></span><?php _e('Dashboard', 'betheme'); ?></a></li>
			<li data-page="plugins"><a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-plugins"><span class="mfn-icon mfn-icon-plugins"></span><?php _e('Plugins', 'betheme'); ?></a></li>

			<?php if( ! WHITE_LABEL && ! isset($disable['demo-data']) ): ?>
			<li data-page="websites"><a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-websites"><span class="mfn-icon mfn-icon-websites"></span><?php _e('وب سایتها', 'betheme'); ?></a></li>
			<?php endif; ?>

			<li data-page="templates"><a href="edit.php?post_type=template"><span class="mfn-icon mfn-icon-templates"></span><?php _e('Templates', 'betheme'); ?></a></li>
			<li data-page="options"><a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-options"><span class="mfn-icon mfn-icon-theme-options"></span><?php _e('Options', 'betheme'); ?></a></li>
			<li>
				<a><span class="mfn-icon mfn-icon-maintenance"></span><?php _e('Other', 'betheme'); ?></a>
				<ul>
					<?php if( ! WHITE_LABEL && ! isset($disable['demo-data']) ): ?>
					<li>
						<a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-setup">
							<span class="mfn-icon mfn-icon-setup-wizzard"></span>
							<div class="inner-link">
								<span class="label"><?php _e('Setup Wizard', 'betheme'); ?></span>
								<span class="desc"><?php _e('راه اندازی وبسایت ', 'betheme'); ?></span>
							</div>
						</a>
					</li>
					<?php endif; ?>
					<li data-page="status">
						<a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-status">
							<span class="mfn-icon mfn-icon-system-status"></span>
							<div class="inner-link">
								<span class="label"><?php _e('System status', 'betheme'); ?></span>
								<span class="desc"><?php _e('چک کردن کانفیگ هاست ', 'betheme'); ?></span>
							</div>
						</a>
					</li>
					<?php if( ! WHITE_LABEL && ! apply_filters('betheme_disable_support', false) ): ?>
					<li data-page="support">
						<a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-support">
							<span class="mfn-icon mfn-icon-support"></span>
							<div class="inner-link">
								<span class="label"><?php _e('Manual & Support', 'betheme'); ?></span>
								<span class="desc"><?php _e('نیاز به کمک دارید؟ ' , 'betheme'); ?></span>
							</div>
						</a>
					</li>
					<?php endif; ?>
					<?php if( ! WHITE_LABEL && ! apply_filters('betheme_disable_changelog', false) ): ?>
					<li data-page="changelog">
						<a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-changelog">
							<span class="mfn-icon mfn-icon-changelog"></span>
							<div class="inner-link">
								<span class="label"><?php _e('تاریخچه تغییرات ', 'betheme'); ?></span>
								<span class="desc"><?php _e("موارد جدید قالب ", 'betheme'); ?></span>
							</div>
						</a>
					</li>
					<?php endif; ?>
					<?php if( ! WHITE_LABEL ): ?>
					<li data-page="tools">
						<a href="admin.php?page=<?php echo apply_filters('betheme_slug', 'be'); ?>-tools">
							<span class="mfn-icon mfn-icon-settings"></span>
							<div class="inner-link">
								<span class="label"><?php _e('ابزارها ', 'betheme'); ?></span>
								<span class="desc"><?php _e('مدیریت موارد متفرقه ', 'betheme'); ?></span>
							</div>
						</a>
					</li>
					<?php endif; ?>
				</ul>
			</li>
		</ul>

	</div>

	<?php
		if( ! empty($is_theme_options) ){
			echo '<a class="mfn-option-btn btn-large mfn-option-blank responsive-menu" href="#"><span class="mfn-icon mfn-icon-menu"></span></a>';
		}
	?>

	<a class="mfn-option-btn btn-large mfn-option-blank mfn-color-scheme">
		<i class="icon-moon dark"></i>
		<i class="icon-light-up light"></i>
	</a>

</header>
