<?php
$downloads     = WC()->customer->get_downloadable_products();
$has_downloads = (bool) $downloads;
if ( $has_downloads ) {
	$ums_downloads = array();
	foreach ( $downloads as $ums_download ) {
		$ums_downloads[ $ums_download['product_id'] ][ $ums_download['order_id'] ][] = $ums_download;
	}
}
?>
<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see    https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


do_action( 'woocommerce_before_account_downloads', $has_downloads ); ?>

<?php if ( $has_downloads ) : ?>

	<?php do_action( 'woocommerce_before_available_downloads' ); ?>

    <ul uk-accordion>
		<?php foreach ( $ums_downloads as $product_id => $orders_download ): ?>
			<?php $img_url = get_the_post_thumbnail( $product_id, 'thumbnail' ); ?>
            <li class="container-ums-details">
                    <a class="uk-accordion-title" href="#"><?php echo $img_url; ?><?php echo get_the_title( $product_id ); ?></a>
					<?php foreach ( $orders_download as $order_id => $download_items ): ?>
                        <div class="uk-accordion-content">
                            <div class="details-styling">
								<?php if ( ! empty( $download_items ) ): ?>
                                    <p style="font-size: 13px;font-weight: 600;color: #000;padding-right: 25px;padding-top: 15px;">
										<?php echo __( 'Order number : ', 'wp_ums' ) . $order_id ?></p>
                                    <table class="uk-table  uk-table-divider">
                                        <thead id="title-list-download">
                                        <tr>
                                            <th><?php _e( 'File', 'woocommerce' ); ?></th>
                                            <th><?php _e( 'Downloads remaining', 'woocommerce' ); ?></th>
                                            <th><?php _e( 'Expires', 'woocommerce' ); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
										<?php foreach ( $download_items as $key => $ums_download ): ?>
                                            <tr>
                                                <td style="text-align: center;    width: 25%;" id="link-download"><a
                                                            href="<?php echo esc_url( $ums_download['download_url'] ); ?>"><?php echo $ums_download['file']['name'] ?></a>
                                                </td>
                                                <td style="text-align: center;    width: 25%;"><?php echo is_numeric( $ums_download['downloads_remaining'] ) ? esc_html( $ums_download['downloads_remaining'] ) : __( '&infin;', 'woocommerce' ); ?></td>
                                                <td style="text-align: center;    width: 25%;">
													<?php if ( ! empty( $ums_download['access_expires'] ) ) : ?>
                                                        <time datetime="<?php echo date( 'Y-m-d', strtotime( $ums_download['access_expires'] ) ); ?>"
                                                              title="<?php echo esc_attr( strtotime( $ums_download['access_expires'] ) ); ?>"><?php echo date_i18n( get_option( 'date_format' ), strtotime( $ums_download['access_expires'] ) ); ?></time>
													<?php else : ?>
														<?php _e( 'Never', 'woocommerce' ); ?>
													<?php endif; ?>
                                                </td>
                                            </tr>
										<?php endforeach; ?>
                                        </tbody>
                                    </table>
								<?php endif; ?>
                            </div>
                        </div>
					<?php endforeach; ?>
            </li>
		<?php endforeach; ?>
                                                    </ul>

	<?php do_action( 'woocommerce_after_available_downloads' ); ?>

<?php else : ?>
    <div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
        <a class="woocommerce-Button button"
           href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php esc_html_e( 'Go shop', 'woocommerce' ); ?>
        </a>
		<?php esc_html_e( 'No downloads available yet.', 'woocommerce' ); ?>
    </div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_account_downloads', $has_downloads ); ?>
