<table style="border: 1px solid #e5e5e5" id="table_id"
       class="uk-table display uk-table-hover uk-table-striped uk-table-responsive" cellspacing="0"
       data-vertable="ver3">
    <thead>
    <tr class="head">
        <th class="uk-table-shrink" data-column="column1">#</th>
        <th class="uk-table-shrink" data-column="column2"><?php _e( 'Tracking ID', 'wp_ums' ) ?></th>
        <th class="uk-table-shrink" data-column="column3"><?php _e( 'Product name', 'wp_ums' ) ?></th>
        <th class="uk-table-shrink" data-column="column4"><?php _e( 'Product price', 'wp_ums' ) ?></th>
        <th class="uk-table-shrink" data-column="column4"><?php _e( 'Payment gateway', 'wp_ums' ) ?></th>
        <th class="uk-table-shrink" data-column="column5"><?php _e( 'Date', 'wp_ums' ) ?></th>
        <th class="uk-table-shrink" data-column="column6"><?php _e( 'Status', 'wp_ums' ) ?></th>
		<?php if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-button-download-page-purchases' ) ): ?>
            <th class="uk-table-shrink" data-column="column7"><?php _e( 'file download', 'wp_ums' ) ?></th>
		<?php endif; ?>
    </tr>
    </thead>
    <tbody style="overflow: auto">
	<?php if ( $purchases ): ?>
		<?php foreach ( $purchases as $purchase ): ?>
            <tr class="row100">
                <td data-column="column1"><?php echo esc_attr( $purchase->payment_id ); ?></td>
                <td data-column="column2"><?php echo esc_attr( $purchase->payment_ref_num ) ?></td>
                <td data-column="column3"><?php echo esc_attr( $purchase->product_name ) ?></td>
                <td data-column="column4"><?php echo esc_attr( \classes\UMS_Utility::show_amount( number_format( $purchase->payment_amount ) ) ) ?></td>
                <td data-column="column4"><?php echo esc_attr( ums_show_name_gateway( $purchase->payment_gateway ) ) ?></td>
                <td data-column="column5"><?php echo \classes\UMS_Utility::show_date($purchase->payment_paid_at) ?></td>
                <td data-column="column6">
				    <?php
					if ( $purchase->payment_status == 1 ) {
						echo '<span style="color:#00d900">' . __( 'Paid', 'wp_ums' ) . '</span>';
					} else {
						echo '<span style="color:red">' . __( 'unpaid', 'wp_ums' ) . '</span>';
					}
					?>
                </td>
				<?php if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-button-download-page-purchases' ) ): ?>
                    <td data-column="column7"><a target="_blank" class="btn-order-wallet" style="color: #fff"
                                                 href="<?php echo esc_attr( ums_download_url_secure( $purchase->product_code, $purchase->payment_user_id ) ) ?>"><?php echo 'دانلود فایل' ?></a>
                    </td>
				<?php endif; ?>
            </tr>
		<?php endforeach; ?>
	<?php else: ?>
        <tr valign="top">
            <td colspan="8" style="text-align: center;color: red;">
				<?php _e( 'No purchases made by you', 'wp_ums' ) ?>
            </td>
        </tr>
	<?php endif; ?>
    </tbody>
</table>