<div class="uk-child-width-1-3@m uk-grid-small uk-grid-match" uk-grid>
	<?php if ( $products ): ?>
		<?php foreach ( $products as $product ): ?>
            <div class="ums-card-product">
				<?php if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-img-product-menu-up' ) ): ?>
                    <div class="ums-card-product-img">
                        <img src="<?php echo $product->product_background; ?>" alt="">
                    </div>
				<?php endif; ?>
                <h3><?php echo $product->product_name; ?></h3>
                <p><?php echo $product->product_txt; ?></p>
                <div class="ums-card-product-bottom">
                    <div class="ums-card-product-price">
						<?php if ( $product->product_price == 0 ) {
							if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-price-product-menu-up' ) ) {
								echo '<b>' . __( 'Price', 'wp_ums' ) . ' : ' . '</b>' . __( 'Free', 'wp_ums' );
							}
						} else {
							echo '<b>' . __( 'Price', 'wp_ums' ) . ' : ' . '</b>' . \classes\UMS_Utility::show_amount( number_format( $product->product_price ) );
						}
						?>
                    </div>
                    <div class="ums-card-product-button-buy">
                        <button>
							<?php if ( $product->product_price == 0 ) {
								?>
                                <a href="<?php echo ums_download_url_secure( $product->product_code, $product->product_user_id ); ?>"><?php echo ! empty( \classes\Admin\UMS_Setting_API::get( 'file-download-button-title-product' ) ) ? \classes\Admin\UMS_Setting_API::get( 'file-download-button-title-product' ) : _e( 'file download', 'wp_ums' ) ?></a>
								<?php
							} else {
								?>
                                <a href="<?php echo home_url( ums_get_slug_user_panel() . '/ums-checkout/' . $product->product_code ) ?>"><?php _e( 'Payment', 'wp_ums' ); ?></a>
								<?php
							}
							?>
                        </button>
                    </div>
                </div>
            </div>
		<?php endforeach; ?>
	<?php endif; ?>

	<?php if ( $products_all ): ?>
		<?php foreach ( $products_all as $product_all ): ?>
			<?php if ( \classes\Admin\UMS_Setting_API::get( 'user-only-buy-product-public-once' ) ): ?>
				<?php if (! ( new \classes\Module\Product\UMS_Product_Handler() )->get_payment_status_product( get_current_user_id(), $product_all->product_id ) ): ?>
                    <div class="ums-card-product">
						<?php if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-img-product-menu-up' ) ): ?>
                            <div class="ums-card-product-img">
                                <img src="<?php echo $product_all->product_background; ?>" alt="">
                            </div>
						<?php endif; ?>
                        <h3><?php echo $product_all->product_name; ?></h3>
                        <p><?php echo $product_all->product_txt; ?></p>
                        <div class="ums-card-product-bottom">
                            <div class="ums-card-product-price">
								<?php if ( $product_all->product_price == 0 ) {
									if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-price-product-menu-up' ) ) {
										echo '<b>' . __( 'Price', 'wp_ums' ) . ' : ' . '</b>' . __( 'Free', 'wp_ums' );
									}
								} else {
									echo '<b>' . __( 'Price', 'wp_ums' ) . ' : ' . '</b>' . \classes\UMS_Utility::show_amount( number_format( $product_all->product_price ) );
								}
								?>
                            </div>
                            <div class="ums-card-product-button-buy">
                                <button>
									<?php if ( $product_all->product_price == 0 ) {
										?>
                                        <a href="<?php echo ums_download_url_secure( $product_all->product_code, wp_get_current_user()->ID ); ?>"><?php echo ! empty( \classes\Admin\UMS_Setting_API::get( 'file-download-button-title-product' ) ) ? \classes\Admin\UMS_Setting_API::get( 'file-download-button-title-product' ) : _e( 'file download', 'wp_ums' ) ?></a>
										<?php
									} else {
										?>
                                        <a href="<?php echo home_url( ums_get_slug_user_panel() . '/ums-checkout/' . $product_all->product_code ) ?>"><?php _e( 'Payment', 'wp_ums' ); ?></a>
										<?php
									}
									?>
                                </button>
                            </div>
                        </div>
                    </div>
				<?php endif; ?>
			<?php else: ?>
                <div class="ums-card-product">
					<?php if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-img-product-menu-up' ) ): ?>
                        <div class="ums-card-product-img">
                            <img src="<?php echo $product_all->product_background; ?>" alt="">
                        </div>
					<?php endif; ?>
                    <h3><?php echo $product_all->product_name; ?></h3>
                    <p><?php echo $product_all->product_txt; ?></p>
                    <div class="ums-card-product-bottom">
                        <div class="ums-card-product-price">
							<?php if ( $product_all->product_price == 0 ) {
								if ( ! \classes\Admin\UMS_Setting_API::get( 'remove-price-product-menu-up' ) ) {
									echo '<b>' . __( 'Price', 'wp_ums' ) . ' : ' . '</b>' . __( 'Free', 'wp_ums' );
								}
							} else {
								echo '<b>' . __( 'Price', 'wp_ums' ) . ' : ' . '</b>' . \classes\UMS_Utility::show_amount( number_format( $product_all->product_price ) );
							}
							?>
                        </div>
                        <div class="ums-card-product-button-buy">
                            <button>
								<?php if ( $product_all->product_price == 0 ) {
									?>
                                    <a href="<?php echo ums_download_url_secure( $product_all->product_code, wp_get_current_user()->ID ); ?>"><?php echo ! empty( \classes\Admin\UMS_Setting_API::get( 'file-download-button-title-product' ) ) ? \classes\Admin\UMS_Setting_API::get( 'file-download-button-title-product' ) : _e( 'file download', 'wp_ums' ) ?></a>
									<?php
								} else {
									?>
                                    <a href="<?php echo home_url( ums_get_slug_user_panel() . '/ums-checkout/' . $product_all->product_code ) ?>"><?php _e( 'Payment', 'wp_ums' ); ?></a>
									<?php
								}
								?>
                            </button>
                        </div>
                    </div>
                </div>
			<?php endif; ?>
		<?php endforeach; ?>
	<?php endif; ?>
</div>
