<?php
	defined( 'ABSPATH' ) || exit;

	global $current_user;

  $pages = [
    'dashboard' => [
      'title' => 'خوش آمدی '. $current_user->display_name,
      'icon' => '',
      'breadcrumbs' => '<li>پیشخوان</li>',
    ],
    'changelog' => [
      'title' => 'لاگ تغییرات',
      'icon' => '<span class="subheader-icon mfn-icon-changelog"></span>',
      'breadcrumbs' => '<li><a href="admin.php?page=betheme">بی تم</a></li><li>لاگ تغییرات</li>',
    ],
    'plugins' => [
      'title' => 'افزونه ها',
      'icon' => '<span class="subheader-icon mfn-icon-plugins"></span>',
      'breadcrumbs' => '<li><a href="admin.php?page=betheme">Betheme</a></li><li>افزونه ها</li>',
    ],
    'status' => [
      'title' => 'وضعیت سیستم',
      'icon' => '<span class="subheader-icon mfn-icon-system-status"></span>',
      'breadcrumbs' => '<li><a href="admin.php?page=betheme">Betheme</a></li><li>وضعیت سیستم</li>',
    ],
    'support' => [
      'title' => 'راهنما و پشتیبانی',
      'icon' => '<span class="subheader-icon mfn-icon-support"></span>',
      'breadcrumbs' => '<li><a href="admin.php?page=betheme">Betheme</a></li><li>راهنما و پشتیبانی</li>',
    ],
    'tools' => [
      'title' => 'ابزارها',
      'icon' => '<span class="subheader-icon mfn-icon-settings"></span>',
      'breadcrumbs' => '<li><a href="admin.php?page=betheme">Betheme</a></li><li>ابزارها</li>',
    ],
    'websites' => [
      'title' => 'وبسایت های آماده',
      'icon' => '<span class="subheader-icon mfn-icon-websites"></span>',
      'breadcrumbs' => '<li><a href="admin.php?page=betheme">Betheme</a></li><li>وبسایت های آماده</li>',
    ],
  ];

  // dashboard

  if( get_option('show_avatars') == 1 && get_option('avatar_default') != 'blank' ){
    $pages['dashboard']['icon'] = '<span class="subheader-icon">'. get_avatar( $current_user->ID, 72 ) .'</span>';
  } else {
    $pages['dashboard']['icon'] =  '<span class="subheader-icon mfn-icon-clients"></span>';
  }
?>

<div class="mfn-dashboard-subheader">

	<div class="subheader-title-group">
		<?php echo $pages[$current]['icon']; ?>
    <div class="subheader-desc">
			<?php if( ! WHITE_LABEL ): ?>
      <ul class="subheader-breadcrumbs">
        <?php echo $pages[$current]['breadcrumbs']; ?>
      </ul>
			<?php endif; ?>
      <h2 class="subheader-title"><?php echo $pages[$current]['title']; ?></h2>
    </div>
  </div>

  <div class="subheader-addons">

		<?php if( ! apply_filters('betheme_disable_theme_version', MFN_THEME_VERSION) ): ?>

		<?php elseif( mfn_is_registered() && version_compare( $this->version, MFN_THEME_VERSION, '>' )): ?>

			<a href="update-core.php" class="mfn-icon-box version-info update">
        <span class="icon-wrapper mfn-icon-notification mfn-animation-shake"></span>
        <div class="desc-wrapper">
          <h5 class="heading"><?php esc_html_e( 'New version available', 'mfn-opts' ); ?></h5>
          <p><?php esc_html_e( 'Update to', 'mfn-opts' ); ?> <?php echo esc_html( $this->version ); ?></p>
        </div>
      </a>

		<?php elseif( mfn_is_registered() ): ?>

			<div class="mfn-icon-box version-info">
        <span class="icon-wrapper mfn-icon-check"></span>
        <div class="desc-wrapper">
          <h5 class="heading"></h5>
          <p><?php esc_html_e( 'Your version', 'mfn-opts' ); ?> <?php echo esc_html( MFN_THEME_VERSION ); ?></p>
        </div>
      </div>

		<?php else: ?>

			<a href="admin.php?page=betheme" class="mfn-icon-box version-info update">
        <span class="icon-wrapper mfn-icon-password"></span>
        <div class="desc-wrapper">
          <h5 class="heading"><?php esc_html_e( 'Register to get updates', 'mfn-opts' ); ?></h5>
          <p><?php esc_html_e( 'Your version', 'mfn-opts' ); ?> <?php echo esc_html( MFN_THEME_VERSION ); ?></p>
        </div>
      </a>

		<?php endif; ?>

  </div>

</div>
