<?php
	defined( 'ABSPATH' ) || exit;

	global $current_user;
?>

<div id="mfn-dashboard" class="mfn-ui mfn-dashboard" data-page="dashboard">

	<input type="hidden" name="mfn-builder-nonce" value="<?php echo wp_create_nonce( 'mfn-builder-nonce' ); ?>">

	<?php
		// header
		include_once get_theme_file_path('/functions/admin/templates/parts/header.php');
	?>

	<div class="mfn-wrapper">

		<?php
			// subheader
			$current = 'dashboard';
			include_once get_theme_file_path('/functions/admin/templates/parts/subheader.php');
		?>

		<div class="mfn-dashboard-wrapper">

			

			<?php if( ! WHITE_LABEL ): ?>
		<div class="mfn-row">

        <div class="row-column row-column-4">
          <div class="mfn-card mfn-shadow-1">
            <div class="card-content" style="color: white; background: #47b185;">
              <p>جهت جلوگیری از سواستفاده هر کد خرید قالب استفاده بروی یک دامنه است.<br>

در سیستم لایسنس جدید راستچین، ثبت دامنه در وب سایت راستجین انجام میشود.<br>

لطفا قبل ارسال تیکت<strong> فایلهای راهنما در داخل پکیج دانلود خود، مستندات و ویدیوهای بی تم چک شود</strong>، فقط در صورت وجود مشکل فنی در قالب پشتیبانی انجام خواهد شد.</p>
            </div>
          </div>
        </div>

        <div class="row-column row-column-8">
          <div class="mfn-card mfn-shadow-1">
            <div class="card-content">
				<p>قبل از شروع به کار حتما فایل Help.pdf را مطالعه بفرمایید.</p>
				<h4>لینکهای مفید</h4>
              <p><ul class="links">
				<a class="mfn-btn" href="admin.php?page=be-websites"><span class="btn-wrapper">وب سایت های آماده</span></a>
				<a class="mfn-btn" href="admin.php?page=be-plugins"><span class="btn-wrapper">نصب افزونه ها</span></a>
				<a class="mfn-btn" href="admin.php?page=be-support"><span class="btn-wrapper">راهنما و پشتیبانی</span></a>
				<a class="mfn-btn" href="admin.php?page=be-options"><span class="btn-wrapper">تنظیمات قالب</span></a>
				<a class="mfn-btn" href="https://www.rtl-theme.com/betheme?aff=TopTheme"><span class="btn-wrapper">Toptheme</span></a>
			</ul></p>
            </div>
          </div>
        </div>

      </div>
      <div class="mfn-row">

        <div class="row-column row-column-4">
          <div class="mfn-card mfn-shadow-1" data-card="setup-wizard">
            <div class="card-content">
              <h3>گام به گام<br /> با راه انداز سریع</h3>
              <p>در چند مرحله می توانید با توجه به نیاز خود و نوع کاری که دارید گزینه های مربوطه را انتخاب کنید و در آخر یک دمو (وبسایت آماده) را نصب کنید</p>
              <a class="mfn-btn" href="admin.php?page=be-setup"><span class="btn-wrapper">راه انداز سریع</span></a>
            </div>
          </div>
        </div>

        <div class="row-column row-column-8">
          <?php
				// latest websites
				include_once get_theme_file_path('/functions/admin/templates/parts/websites.php');
			?>
        </div>

      </div>

			<?php endif; ?>

			

			<?php if( mfn_is_registered() ): ?>

				<div class="mfn-row">

					<div class="row-column row-column-8">

						<div class="mfn-card mfn-shadow-1" data-card="theme-register">

							<div class="card-header">
								<div class="card-title-group">
									<span class="card-icon mfn-icon-register-light"></span>
									<div class="card-desc">
										<h4 class="card-title">قالب فعال است</h4>
									</div>
								</div>
								
							</div>

							<div class="card-content">

								<form class="form-register mfn-form" method="post">
									<div class="form-register-input">

										<span class="mfn-icon mfn-icon-password-light"></span>
										<input type="text" value="<?php echo esc_html( mfn_get_purchase_code_hidden() ); ?>" class="mfn-form-control of-input" size="36" readonly="readonly">

										

									</div>
								</form>

								
							</div>

						</div>

					</div>

					<div class="row-column row-column-4">

						<?php
							// mini system status
							include get_theme_file_path('/functions/admin/templates/parts/mini-status.php');

						?>

					</div>

				</div>

			<?php endif; ?>

			<?php if( ! WHITE_LABEL ): ?>

			

		<?php endif; ?>

    </div>

		<?php
			// footer
			include get_theme_file_path('/functions/admin/templates/parts/footer.php');
		?>

	</div>

	<!-- modal: data collection -->

  

</div>
