<?php

/**
 * Plugin Name: مدیریت کاربران ویرا
 * Plugin URI:https://www.themelavin.ir
 * Description:بهترین ابزار برای مدیریت کاربران و ساخت پنل کاربری پیشرفته در وردپرس
 * Version: 12.0.7
 * Author: تم لاوین
 * Author URI: https://www.themelavin.ir
 * Text Domain: wp_ums
 * Domain Path: languages
 */

// Exit if accessed directly
if (! defined('ABSPATH')) {
	exit();
}

require(trailingslashit(plugin_dir_path(__FILE__)) . 'core.php');

$installer = new \classes\UMS_Installer();

register_activation_hook(__FILE__, [$installer, 'activation_hook']);

register_deactivation_hook(__FILE__, [$installer, 'deactivation_hook']);

add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'ums_docs_settings_link');

function ums_docs_settings_link($links)
{
	$my_link = array(
		'<a target="_blank" style="display: inline-block;background: #fb7319;padding: 5px;border-radius: 3px;color: #fff;" href="https://themelavin.ir/ums/docs/">' . __('Documentation', 'wp_ums') . '</a>',
	);

	return array_merge($my_link, $links);
}




