<?php
if (! defined('ABSPATH')) {
	exit;
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<meta name="robots" content="noindex, nofollow">
	<title>
        <?php
			if (is_home()) {
				bloginfo('name');
			} elseif (is_category()) {
				single_cat_title();
				echo ' - ';
				bloginfo('name');
			} elseif (is_single()) {
				single_post_title();
			} elseif (is_page()) {
				bloginfo('name');
				echo ': ';
				single_post_title();
			} else {
				wp_title('', true);
			}
            ?>
    </title>
	<?php do_action('ums_wp_head_register') ?>
	<?php wp_head(); ?>
</head>

<body <?php body_class('ums-login-register-body'); ?>>
	<?php if (have_posts()) : ?>
		<?php while (have_posts()) : the_post(); ?>
			<?php the_content(); ?>
			<?php endwhile;
	else : ?>

    <?php endif; ?>
			<?php wp_footer(); ?>
			<?php do_action('ums_wp_footer_register') ?>
</body>

</html>