<?php
if (! defined('ABSPATH')) {
  exit;
}
$valid_domains = [
  'gmail.com',
  'yahoo.com',
  'hotmail.com',
  'msn.com',
];
if (!empty($options::get('email-valid-domains'))) {
  foreach ($options::get('email-valid-domains') as $domain) {
    if (in_array($domain, $valid_domains) == false) {
      $valid_domains[] = $domain;
    }
  }
}

?>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
  <input class="umss-checkbox" id="enable-show-popup-verify-email" name="enable-show-popup-verify-email" <?php echo checked($options::get('enable-show-popup-verify-email'), 'yes'); ?> type="checkbox" value="yes">
  <label class="form-check-label" for="enable-show-popup-verify-email">
    <?php esc_html_e('Display Email Verification Popup', 'wp_ums') ?>
  </label>
</div>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
  <input class="umss-checkbox" id="enable-send-email-confirmation-after-register" name="enable-send-email-confirmation-after-register" <?php echo checked($options::get('enable-send-email-confirmation-after-register'), 'yes'); ?> type="checkbox" value="yes">
  <label class="form-check-label" for="enable-send-email-confirmation-after-register">
    <?php esc_html_e('Send email confirmation link after user registration', 'wp_ums') ?>
  </label>
</div>

<div class="form-group smu-admin-input-textarea">
  <label for=""><?php esc_html_e('Restrict specific pages', 'wp_ums'); ?></label>
  <textarea row="6" type="text" class="umss-form-control" id="email-restrict-specific-pages" placeholder="" name="email-restrict-specific-pages[]"><?php echo ums_show_array_value($options::get('email-restrict-specific-pages')); ?></textarea>
  <p style="font-weight: 300;margin-top: 8px"><?php esc_html_e('You can enter the address of the pages that need email confirmation (one address per line)', 'wp_ums') ?></p>
</div>

<div class="form-group smu-admin-input-textarea">
  <label for=""><?php esc_html_e('Custom message', 'wp_ums'); ?></label>
  <textarea row="6" type="text" class="umss-form-control" id="email-custom-message" placeholder="" name="email-custom-message"><?php echo esc_textarea($options::get('email-custom-message')); ?></textarea>
</div>

<p class="smu-section-title"><?php esc_html_e('Email Verification Template', 'wp_ums'); ?></p>
<div class="form-group smu-admin-input-text">
  <label for=""><?php esc_html_e('Heading', 'wp_ums'); ?></label>
  <input type="text" class="umss-form-control" name="email-title-send-email-confirmation" id="email-title-send-email-confirmation" value="<?php echo esc_html($options::get('email-title-send-email-confirmation')); ?>">
</div>
<div class="form-group smu-admin-input-text">
  <?php wp_editor(wp_kses_post($options::get('email-text-send-email-confirmation')), 'email-text-send-email-confirmation', ['editor_height' => 256]); ?>
</div>

<p class="smu-section-title"><?php esc_html_e('Email filter', 'wp_ums'); ?></p>

<div class="form-group smu-admin-input-text umss-checkbox ums-checkbox-style">
  <input class="umss-checkbox" id="enable-email-filter-disposable-temporary" name="enable-email-filter-disposable-temporary" <?php echo checked($options::get('enable-email-filter-disposable-temporary'), 'yes'); ?> type="checkbox" value="yes">
  <label class="form-check-label" for="enable-email-filter-disposable-temporary">
    <?php esc_html_e('Activate disposable / temporary email filter', 'wp_ums') ?>
  </label>
</div>
<div class="form-group smu-admin-select">
  <label class="form-check-label" for=""><?php esc_html_e('Valid domains', 'wp_ums'); ?></label>
  <select multiple="multiple" class="umss-form-control email-valid-domains" name="email-valid-domains[]">
    <?php foreach ($valid_domains as $valid_domain) : ?>
      <option value="<?php echo esc_attr($valid_domain) ?>" <?php echo (is_array($options::get('email-valid-domains')) && in_array($valid_domain, $options::get('email-valid-domains'))) ? 'selected' : ''; ?>><?php echo $valid_domain ?></option>
    <?php endforeach; ?>
  </select>
  <p style="font-weight: 300;margin-top: 8px"><?php esc_html_e('Enter the domains that are allowed to register', 'wp_ums') ?></p>
</div>