<?php
defined('ABSPATH') || exit('No Access!');
?>
<div class="wrap">
    <div class="ums-title-admin">
        <p><?php esc_html_e('Modules', 'wp_ums') ?></p>
    </div>
    <div class="ums-modules">
        <?php if ($modules): ?>
            <?php foreach ($modules as $module_key => $module): ?>
                <div class="ums-module-box">
                    <div class="ums-module-box-name">
                        <h3 class="plugin-name">
                            <?php echo esc_html($module['title']) ?>
                        </h3>
                    </div>
                    <div class="action-links">
                        <ul class="plugin-action-buttons">
                            <?php if($active_module && $module['setting'] && in_array('UMS-Modules-' . $module_key, $active_module)): ?>
                                <li data-module="auction">
                                    <a target="_blank" href="<?php echo esc_url(admin_url('admin.php?page=ums-manger-settings#v-ums-') . strtolower($module_key)) ?>"><i class="bi bi-gear"></i></a>
                                </li>
                            <?php endif; ?>
                            <li data-module="auction">
                                <label class="switch tips">
                                    <input class="modules-switch" <?php if ($active_module && in_array('UMS-Modules-' . $module_key, $active_module)) {
                                                                        echo 'checked';
                                                                    } ?>
                                        value="UMS-Modules-<?php echo esc_attr($module_key) ?>" type="checkbox">
                                </label>
                            </li>
                        </ul>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>
<div class="ums-loading-backopacity" style="display: none">
    <img src="<?php echo esc_url(UMS_ASSETS . 'img/477.svg') ?>" alt="loader">
</div>