<?php

namespace classes\Sms;

use classes\Admin\UMS_Setting_API;
use classes\UMS_Sms;

defined('ABSPATH') || exit('No Access!');

class UMS_Iranpayamak extends UMS_Sms
{

	public function send()
	{
		if (is_array($this->message)) {
			$input_data = [];
			$pattern_message = $this->message;
			$fromNum = UMS_Setting_API::get('sms-pattern-service-line');
			$pattern_code = $pattern_message['code_pattern'];
			if (count($pattern_message)) {
				foreach ($pattern_message as $key => $value) {
					if ($key == 'code_pattern') continue;
					$input_data[$key] = $value;
				}
			}

			$url = 'https://api.iranpayamak.com/ws/v1/sms/pattern';

			$payload = [
				'code' => $pattern_code,
				'attributes' => (object)$input_data,
				'recipient' => $this->to,
				'line_number' => $fromNum,
				'number_format' => 'english'
			];

			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, [
				'Accept: application/json',
				'Content-Type: application/json',
				'Api-Key: ' . $this->username
			]);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

			$body = curl_exec($ch);
			$err  = curl_error($ch);
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			curl_close($ch);

			$decoded = null;
			if ($body !== false && !empty($body)) {
				$decoded = json_decode($body, true);
			}
			return [
				'http_code' => $httpCode,
				'response' => $decoded ?? $body,
				'error' => $err ?: null
			];
		} else {
			$url = 'https://api.iranpayamak.com/ws/v1/sms/simple';

			$payload = [
				'text' => $this->message,
				'recipients' => [$this->to],
				'line_number' => $this->from,
				'number_format' => "english",
			];

			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, [
				'Accept: application/json',
				'Content-Type: application/json',
				'Api-Key: ' . $this->username
			]);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

			$body = curl_exec($ch);
			$err  = curl_error($ch);
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			curl_close($ch);

			$decoded = null;
			if ($body !== false && !empty($body)) {
				$decoded = json_decode($body, true);
			}
			return [
				'http_code' => $httpCode,
				'response' => $decoded ?? $body,
				'error' => $err ?: null
			];
		}
	}
}

