function cuteAlert({
                       type,
                       title,
                       message,
                       buttonText = "OK",
                       confirmText = "OK",
                       cancelText = "Cancel",
                       closeStyle,
                   }) {
    return new Promise((resolve) => {
        setInterval(() => {
        }, 5000);
        const body = document.querySelector("body");

        const scripts = document.getElementsByTagName("script");
        let currScript = "";

        for (let script of scripts) {
            if (script.src.includes("toastr.min.js")) {
                currScript = script;
            }
        }

        let src = currScript.src;

        src = src.substring(0, src.lastIndexOf("/"));

        let closeStyleTemplate = "alert-close";
        if (closeStyle === "circle") {
            closeStyleTemplate = "alert-close-circle";
        }

        let btnTemplate = `
    <button class="ums-alert-button ${type}-bg ${type}-btn">${buttonText}</button>
    `;
        if (type === "question") {
            btnTemplate = `
      <div class="ums-question-buttons">
        <button class="ums-confirm-button ${type}-bg ${type}-btn">${confirmText}</button>
        <button class="ums-cancel-button error-bg error-btn">${cancelText}</button>
      </div>
      `;
        }

        const template = `
    <div class="ums-alert-wrapper">
      <div class="ums-alert-frame">
        <div class="ums-alert-header ${type}-bg">
          <img class="ums-alert-img" src="${src}/img/${type}.svg" />
        </div>
        <div class="ums-alert-body">
          <span class="ums-alert-title">${title}</span>
          <span class="ums-alert-message">${message}</span>
          ${btnTemplate}
        </div>
      </div>
    </div>
    `;

        body.insertAdjacentHTML("afterend", template);

        const alertWrapper = document.querySelector(".ums-alert-wrapper");
        const alertFrame = document.querySelector(".ums-alert-frame");
        const alertClose = document.querySelector(`.${closeStyleTemplate}`);

        if (type === "question") {
            const confirmButton = document.querySelector(".ums-confirm-button");
            const cancelButton = document.querySelector(".ums-cancel-button");

            confirmButton.addEventListener("click", () => {
                alertWrapper.remove();
                resolve("confirm");
            });

            cancelButton.addEventListener("click", () => {
                alertWrapper.remove();
                resolve();
            });
        } else {
            const alertButton = document.querySelector(".ums-alert-button");

            alertButton.addEventListener("click", () => {
                alertWrapper.remove();
                resolve();
            });
        }

        alertClose?.addEventListener("click", () => {
            alertWrapper.remove();
            resolve();
        });

        alertWrapper.addEventListener("click", () => {
            alertWrapper.remove();
            resolve();
        });

        alertFrame.addEventListener("click", (e) => {
            e.stopPropagation();
        });
    });
}

function cuteToast({type, title, message, timer = 5000}) {
    return new Promise((resolve) => {
        if (document.querySelector(".toast-container")) {
            document.querySelector(".toast-container").remove();
        }
        const body = document.querySelector("body");

        const scripts = document.getElementsByTagName("script");
        let currScript = "";

        for (let script of scripts) {
            if (script.src.includes("toastr.min.js")) {
                currScript = script;
            }
        }

        let src = currScript.src;

        src = src.substring(0, src.lastIndexOf("/"));

        const template = `
    <div class="ums-toast-container ${type}-bg">
        <div class="ums-toast-frame">
            <div class="ums-toast-img">
                <img  src="${src}/img/${type}.png" />
            </div>
            <div>
                 <span class="ums-toast-message">${message}</span>
            </div>
          <div class="ums-toast-close"><i class="fa-solid fa-xmark"></i></div>
        </div>
        <div class="ums-toast-timer ${type}-timer" style="animation: timer ${timer}ms linear;"/>
    </div>
    `;

        body.insertAdjacentHTML("afterend", template);

        const toastContainer = document.querySelector(".ums-toast-container");

        setTimeout(() => {
            toastContainer.remove();
            resolve();
        }, timer);

        const toastClose = document.querySelector(".ums-toast-close");

        toastClose.addEventListener("click", () => {
            toastContainer.remove();
            resolve();
        });
    });
}
