<div class="uk-text-center" uk-grid>
    <div class="uk-width-5-5@m uk-width-3-3@l">
        <form action="" id="ums-send-post" enctype="multipart/form-data">
            <div class="ums-form-wrap-field">
                <label for="">
					<?php printf( __( 'Title %s', 'wp_ums' ), $title_post_type ) ?>
                    <span class="required">*</span>
                </label>
                <input autocomplete="off"
                       data-label="<?php printf( __( 'Title %s', 'wp_ums' ), $title_post_type ) ?>"
                       type="text"
                       class="regular-text"
                       id="post-title"
                       required
                       name="post-title">
            </div>
			<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-name-submissions-post' ) == 'Active' || \classes\Admin\UMS_Setting_API::get( 'status-field-post-name-submissions-post' ) == 'Active-necessary' ): ?>
                <div class="ums-form-wrap-field">
                    <label for="">
						<?php printf( __( 'Name %s in English (Slug %s)', 'wp_ums' ), $title_post_type, $title_post_type ) ?>
						<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-name-submissions-post' ) == 'Active-necessary' ): ?>
                            <span class="required">*</span>
						<?php endif; ?>
                    </label>
                    <input autocomplete="off"
                           data-label="<?php printf( __( 'Name %s in English (Slug %s)', 'wp_ums' ), $title_post_type, $title_post_type ) ?>"
                           type="text"
                           class="regular-text"
						<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-name-submissions-post' ) == 'Active-necessary' ): ?>
                            required
						<?php endif; ?>
                           id="post-slug"
                           name="post-slug">
                </div>
			<?php endif; ?>
            <div class="ums-form-wrap-field">
                <label for="">
					<?php printf( __( 'Text %s', 'wp_ums' ), $title_post_type ) ?>
                    <span class="required">*</span>
                </label>
				<?php wp_editor( null, 'post-content', array( 'textarea_rows' => '10' ) ); ?>
                <span class="field-description">🚧 <?php echo ! empty( \classes\Admin\UMS_Setting_API::get( 'description-below-content-submissions-post' ) ) ? \classes\Admin\UMS_Setting_API::get( 'description-below-content-submissions-post' ) : _e( 'The text of the article you want to submit must be published for the first time among Persian sites', 'wp_ums' ) ?></span>
            </div>
			<?php if ( \classes\Admin\UMS_Setting_API::get( 'select-categories-user-submissions-post' ) ): ?>
                <div class="ums-form-wrap-field">
                    <label for="">
						<?php _e( 'Category', 'wp_ums' ) ?>
                        <span class="required">*</span>
                    </label>
                    <select name="post-category" id="post-category" required>
						<?php
						$categories = get_categories( array(
							'taxonomy'     => \classes\Admin\UMS_Setting_API::get( 'name-taxonomy-submissions-post' ),
							'orderby'      => 'name',
							'show_count'   => 0,
							'child_of'     => 0,
							'parent'       => '',
							'pad_counts'   => 0,
							'hierarchical' => 1,
							'title_li'     => '',
							'hide_empty'   => 0

						) );
						foreach ( $categories as $category ) {
							echo '<option style="font-size: 13px;" value=' . intval( $category->term_id ) . '>' . $category->name . '</option> ';
						}
						?>
                    </select>
                </div>
			<?php endif; ?>
			<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-tag-submissions-post' ) == 'Active' || \classes\Admin\UMS_Setting_API::get( 'status-field-post-tag-submissions-post' ) == 'Active-necessary' ): ?>
                <div class="ums-form-wrap-field">
                    <label for="">
						<?php printf( __( 'Tags %s', 'wp_ums' ), $title_post_type ) ?>
						<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-tag-submissions-post' ) == 'Active-necessary' ): ?>
                            <span class="required">*</span>
						<?php endif; ?>
                    </label>
                    <input autocomplete="off"
                           placeholder="<?php _e( 'Example: Template, Plugin, WordPress', 'wp_ums' ) ?>"
                           type="text"
                           class="regular-text"
                           id="post-tag"
						<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-name-submissions-post' ) == 'Active-necessary' ): ?>
                            required
						<?php endif; ?>
                           name="post-tag">
                    <span class="field-description"><?php _e( 'Mark the labels , Separate', 'wp_ums' ) ?></span>
                </div>
			<?php endif; ?>

			<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-image-submissions-post' ) == 'Active' || \classes\Admin\UMS_Setting_API::get( 'status-field-post-image-submissions-post' ) == 'Active-necessary' ): ?>
                <div class="ums-form-wrap-field">
                    <label for="">
						<?php printf( __( 'Picture %s', 'wp_ums' ), $title_post_type ) ?>
						<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-image-submissions-post' ) == 'Active-necessary' ): ?>
                            <span class="required">*</span>
						<?php endif; ?>
                    </label>
                    <div uk-form-custom="target: true" class="uk-form-custom uk-margin-small-top">
                        <input name="post-image"
                               id="post-image"
                               accept="image/*"
							<?php if ( \classes\Admin\UMS_Setting_API::get( 'status-field-post-name-submissions-post' ) == 'Active-necessary' ): ?>
                                required
							<?php endif; ?>
                               type="file">
                        <input class="uk-input uk-form-width-medium" type="text"
                               placeholder="<?php _e( 'Upload File', 'wp_ums' ) ?>"
                               disabled>
                        <span class="field-description"><?php echo ! empty( \classes\Admin\UMS_Setting_API::get( 'description-below-picture-submissions-post' ) ) ? \classes\Admin\UMS_Setting_API::get( 'description-below-picture-submissions-post' ) : _e( 'Preferably the photo should be in the size of 300 * 300', 'wp_ums' ) ?></span>
                    </div>
                </div>
			<?php endif; ?>
            
            <?php do_action('ums_after_field_modules_send_post')?>

            <div class="ums-form-wrap-field">
                <button class="ums-btn-submit-sp">
                    <p><?php echo ! empty( \classes\Admin\UMS_Setting_API::get( 'text-send-button-submissions-post' ) ) ? \classes\Admin\UMS_Setting_API::get( 'text-send-button-submissions-post' ) : _e( 'Send', 'wp_ums' ) ?></p>
                </button>
            </div>

        </form>
    </div>
</div>