<div class="uk-child-width-1-1@s" uk-grid>
    <div>
		<?php
		use classes\UMS_jDate;
		global $current_user;
		$user_role = $current_user->roles;
		?>
        <div uk-grid>
            <div class="uk-width-1-1">
                <ul style="list-style: none" class="uk-tab-left notification-list">
					<?php if ( $notifications_all ): ?>
						<?php foreach ( $notifications_all as $notification_all ): ?>
							<?php $selected_roles = unserialize( $notification_all->notification_roles ); ?>
							<?php
							if ( ! is_array( $selected_roles ) ) {
								$selected_roles = [];
							}
							?>

							<?php if ( count( $selected_roles ) == 0 ): ?>
                                <li>
                                    <img src="<?php echo UMS_ASSETS . 'img/notification.png' ?>" alt="">
                                    <a class="list-noti"
                                       href="<?php echo home_url( ums_get_slug_user_panel() . '/' . ( new \classes\UMS_User_Panel_Menu() )->check_menu_exist( '[notifications]' ) . '/view/' . $notification_all->notification_code ) ?>"><?php echo $notification_all->title_notification; ?></a>
									   <span>
									   <?php if(ums_get_lang()=='fa'): ?>										
											<?php echo UMS_jDate::date('Y-m-d H:i:s',$notification_all->notification_create_at_date,false); ?>
										<?php else: ?>
											<?php echo $notification_all->notification_create_at_date ?>
										<?php endif; ?>
										</span>
                                    <p><?php echo wp_trim_words( $notification_all->text_notification, 15, '...' ) ?></p>
									<a class="ums-link-show-notification" href="<?php echo home_url( ums_get_slug_user_panel() . '/' . ( new \classes\UMS_User_Panel_Menu() )->check_menu_exist( '[notifications]' ) . '/view/' . $notification_all->notification_code ) ?>"><?php _e('View notification','wp_ums'); ?></a>
                                </li>
							<?php else: ?>
								<?php if ( array_intersect( $user_role, $selected_roles ) ): ?>
                                    <li>
                                        <img src="<?php echo UMS_ASSETS . 'img/notification.png' ?>"
                                             alt="">
                                        <a class="list-noti"
                                           href="<?php echo home_url( ums_get_slug_user_panel() . '/' . ( new \classes\UMS_User_Panel_Menu() )->check_menu_exist( '[notifications]' ) . '/view/' . $notification_all->notification_code ) ?>"><?php echo $notification_all->title_notification; ?></a>
										   <span>
										   <?php if(ums_get_lang()=='fa'): ?>										
												<?php echo UMS_jDate::date('Y-m-d H:i:s',$notification_all->notification_create_at_date,false); ?>
											<?php else: ?>
												<?php echo $notification_all->notification_create_at_date ?>
											<?php endif; ?>
											</span>
                                        <p><?php echo wp_trim_words( $notification_all->text_notification, 15, '...' ) ?></p>
										<a class="ums-link-show-notification" href="<?php echo home_url( ums_get_slug_user_panel() . '/' . ( new \classes\UMS_User_Panel_Menu() )->check_menu_exist( '[notifications]' ) . '/view/' . $notification_all->notification_code ) ?>"><?php _e('View notification','wp_ums'); ?></a>
                                    </li>
								<?php endif; ?>
							<?php endif; ?>
						<?php endforeach; ?>
					<?php else: ?>
                        <div class="notifications-empty">
							<?php _e( 'No notification has been sent to you', 'wp_ums' ) ?>
                        </div>
					<?php endif; ?>
                </ul>
            </div>
        </div>
        <div class="pagination-notification">
			<?php
			echo paginate_links( array(
				'base'      => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
				'format'    => '',
				'prev_text' => __( '&laquo;' ),
				'next_text' => __( '&raquo;' ),
				'total'     => ceil( $total / $items_per_page ),
				'current'   => $page
			) );
			?>
        </div>
    </div>
</div>


