/**
 * PersianJs v0.3.0
 * https://github.com/usablica/persian.js
 * MIT licensed
 *
 * Copyright (C) 2012 usabli.ca and other contributors
 */
(function(){var VERSION="0.4.0",hasModule=typeof module!=="undefined"&&module.exports;var arabicNumbers=["١","٢","٣","٤","٥","٦","٧","٨","٩","٠"],persianNumbers=["۱","۲","۳","۴","۵","۶","۷","۸","۹","۰"],englishNumbers=["1","2","3","4","5","6","7","8","9","0"];function PersianJs(str){this._str=str}function _arabicChar(value){if(!value){return}var arabicChars=["ي","ك","‍","دِ","بِ","زِ","ذِ","ِشِ","ِسِ","‌","ى"],persianChars=["ی","ک","","د","ب","ز","ذ","ش","س","","ی"];for(var i=0,charsLen=arabicChars.length;i<charsLen;i++){value=value.replace(new RegExp(arabicChars[i],"g"),persianChars[i])}this._str=value;return this}function _persianNumber(value){if(!value){return}for(var i=0,numbersLen=englishNumbers.length;i<numbersLen;i++){value=value.replace(new RegExp(persianNumbers[i],"g"),englishNumbers[i])}this._str=value;return this}function _arabicNumber(value){if(!value){return}value=value.toString();for(var i=0,numbersLen=arabicNumbers.length;i<numbersLen;i++){value=value.replace(new RegExp(arabicNumbers[i],"g"),persianNumbers[i])}this._str=value;return this}function _englishNumber(value){if(!value){return}value=value.toString();var englishNumbers=["1","2","3","4","5","6","7","8","9","0"],persianNumbers=["۱","۲","۳","۴","۵","۶","۷","۸","۹","۰"];for(var i=0,numbersLen=englishNumbers.length;i<numbersLen;i++){value=value.replace(new RegExp(englishNumbers[i],"g"),persianNumbers[i])}this._str=value;return this}function _toEnglishNumber(value){if(!value){return}for(var i=0,numbersLen=englishNumbers.length;i<numbersLen;i++){value=value.replace(new RegExp(persianNumbers[i],"g"),englishNumbers[i]).replace(new RegExp(arabicNumbers[i],"g"),englishNumbers[i])}this._str=value;return this}function _decodeURL(value){if(!value){return}var old="";while(old!=value){old=value;value=value.replace(/(http\S+?)\%20/g,"$1‌‌‌_‌‌‌")}value=value.replace(/(http\S+)/g,function(s,p){return decodeURI(p)});value=value.replace(/\u200c\u200c\u200c_\u200c\u200c\u200c/g,"%20");this._str=value;return this}function _switchKey(value){if(!value){return}var persianChar=["ض","ص","ث","ق","ف","غ","ع","ه","خ","ح","ج","چ","ش","س","ی","ب","ل","ا","ت","ن","م","ک","گ","ظ","ط","ز","ر","ذ","د","پ","و","؟"],englishChar=["q","w","e","r","t","y","u","i","o","p","[","]","a","s","d","f","g","h","j","k","l",";","'","z","x","c","v","b","n","m",",","?"];for(var i=0,charsLen=persianChar.length;i<charsLen;i++){value=value.replace(new RegExp(persianChar[i],"g"),englishChar[i])}this._str=value;return this}function _digitsToWords(value){var delimiter,digit,i,iThree,numbers,parts,result,resultThree,three;if(!isFinite(value)){return""}if(typeof value!=="string"){value=value.toString()}parts=["","هزار","میلیون","میلیارد","تریلیون","کوادریلیون","کویینتیلیون","سکستیلیون"];numbers={0:["","صد","دویصت","سیصد","چهارصد","پانصد","ششصد","هفتصد","هشتصد","نهصد"],1:["","ده","بیست","سی","چهل","پنجاه","شصت","هفتاد","هشتاد","نود"],2:["","یک","دو","سه","چهار","پنج","شش","هفت","هشت","نه"],two:["ده","یازده","دوازده","سیزده","چهارده","پانزده","شانزده","هفده","هجده","نوزده"],zero:"صفر"};delimiter=" و ";valueParts=value.split("").reverse().join("").replace(/\d{3}(?=\d)/g,"$&,").split("").reverse().join("").split(",").map(function(str){return Array(4-str.length).join("0")+str});result=function(){var _results;_results=[];for(iThree in valueParts){three=valueParts[iThree];resultThree=function(){var _i,_len,_results1;_results1=[];for(i=_i=0,_len=three.length;_i<_len;i=++_i){digit=three[i];if(i===1&&digit==="1"){_results1.push(numbers.two[three[2]])}else if((i!==2||three[1]!=="1")&&numbers[i][digit]!==""){_results1.push(numbers[i][digit])}else{continue}}return _results1}();resultThree=resultThree.join(delimiter);_results.push(resultThree+" "+parts[valueParts.length-iThree-1])}return _results}();result=result.filter(function(x){return x.trim()!==""});result=result.join(delimiter).trim();if(result===""){result=numbers.zero}this._str=result;return this}function _halfSpace(value){if(!value){return}var pattern;pattern=/((\s\u0645\u06CC)+( )+([\u0600-\u06EF]{1,}){1,})/g;value=value.replace(new RegExp(pattern),"$2‌$4");pattern=/(([\u0600-\u06EF]{1,})+( )+(ای|ایی|اند|ایم|اید|ام){1})/g;value=value.replace(new RegExp(pattern),"$2‌$4");this._str=value;return this}var persianJs=function(inputStr){if(!inputStr||inputStr===""){throw new Error("Input is null or empty.")}return new PersianJs(inputStr)};persianJs.version=VERSION;persianJs.fn=PersianJs.prototype={clone:function(){return persianJs(this)},value:function(){return this._str},toString:function(){return this._str.toString()},set:function(value){this._str=String(value);return this},arabicChar:function(){return _arabicChar.call(this,this._str)},persianNumber:function(){return _persianNumber.call(this,this._str)},arabicNumber:function(){return _arabicNumber.call(this,this._str)},englishNumber:function(){return _englishNumber.call(this,this._str)},toEnglishNumber:function(){return _toEnglishNumber.call(this,this._str)},fixURL:function(){return _decodeURL.call(this,this._str)},decodeURL:function(){return _decodeURL.call(this,this._str)},switchKey:function(){return _switchKey.call(this,this._str)},digitsToWords:function(){return _digitsToWords.call(this,this._str)},halfSpace:function(){return _halfSpace.call(this,this._str)}};if(hasModule){module.exports=persianJs}if(typeof ender==="undefined"){this["persianJs"]=persianJs}if(typeof define==="function"&&define.amd){define("persianJs",[],function(){return persianJs})}})();
//# sourceMappingURL=./persian-min.map
