<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

/**
 * Bargwp Ajax Cats class
 * @author Bargwp <info@bargwp.com>
 */
 
class Ajax_Cats_Tax {
	
	/**
     * Instance of this class. This is a singleton class
     */
	private static $instance = NULL;    
	
	/**
     * Getting instance. This Class is a singleton class
     * @return static
     */	
    public static function instance() {
        // Get an instance of Class
        if(!self::$instance) self::$instance = new self();
        
        // Return the instance
        return self::$instance;
	}
	
	public function ajax_post_cats() 
	{
		if (isset($_POST['post_type'])) 
		{
			$post_type = $_POST['post_type'];
			$object_taxonomies = get_object_taxonomies($post_type);
			if (!empty($object_taxonomies)) {
				$cats = get_categories(array(
					'hide_empty' => 0, 'taxonomy' => array_diff($object_taxonomies, array('post_tag')), 'type' => $post_type
				));
			} else {
				$cats = array();
			}
			$scrape_category = get_post_meta($_POST['post_id'], 'scrape_category', true);
			foreach ($cats as $c) {
				if( isset(get_taxonomy($c->taxonomy)->labels->name) ) {
					echo '<div class="checkbox"><label><input type="checkbox" name="scrape_category[]" value="' . $c->cat_ID . '"' . (!empty($scrape_category) && in_array($c->cat_ID, $scrape_category) ? " checked" : "") . '> ' . $c->name . '<small> (' . get_taxonomy($c->taxonomy)->labels->name . ')</small></label></div>';
				}
			}
			wp_die();
		}
	}
	
	public function ajax_post_tax() 
	{
		if (isset($_POST['post_type'])) 
		{
			$post_type = $_POST['post_type'];
			$object_taxonomies = get_object_taxonomies($post_type, "objects");
			unset($object_taxonomies['post_tag']);
			$scrape_categoryxpath_tax = get_post_meta($_POST['post_id'], 'scrape_categoryxpath_tax', true);
			foreach ($object_taxonomies as $tax) {
				echo "<option value='$tax->name'" . ($tax->name == $scrape_categoryxpath_tax ? " selected" : "") . " >" . $tax->labels->name . "</option>";
			}
			wp_die();
		}
	}	
}