<?php
// test.php - Simple test page for empty table
require_once 'config.php';

try {
    // Check if table exists and is empty
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM fuel_requests");
    $result = $stmt->fetch();
    $record_count = $result['count'];
    
    // Get table structure
    $stmt = $pdo->query("DESCRIBE fuel_requests");
    $table_structure = $stmt->fetchAll();
    
} catch (PDOException $e) {
    $error = $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بررسی وضعیت دیتابیس</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">وضعیت دیتابیس و جدول</h4>
            </div>
            <div class="card-body">
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger">
                        <h5>خطا در اتصال به دیتابیس:</h5>
                        <p><?= htmlspecialchars($error) ?></p>
                    </div>
                <?php else: ?>
                    <div class="alert alert-success">
                        <h5>اتصال به دیتابیس موفقیت‌آمیز بود</h5>
                        <p>تعداد رکوردهای موجود در جدول: <strong><?= $record_count ?></strong></p>
                    </div>
                    
                    <h5>ساختار جدول fuel_requests:</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Field</th>
                                    <th>Type</th>
                                    <th>Null</th>
                                    <th>Key</th>
                                    <th>Default</th>
                                    <th>Extra</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($table_structure as $column): ?>
                                <tr>
                                    <td><?= $column['Field'] ?></td>
                                    <td><?= $column['Type'] ?></td>
                                    <td><?= $column['Null'] ?></td>
                                    <td><?= $column['Key'] ?></td>
                                    <td><?= $column['Default'] ?></td>
                                    <td><?= $column['Extra'] ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        <a href="upload.php" class="btn btn-success">شروع آپلود فایل</a>
                        <a href="index.php" class="btn btn-primary">مشاهده داده‌ها</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>