<?php
// export.php
require_once 'config.php';
require_once 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// تابع برای مپینگ معکوس (از دیتابیس به اکسل)
function reverseColumnMapping($column_mapping) {
    $reverse_mapping = [];
    foreach ($column_mapping as $excel_header => $db_column) {
        $reverse_mapping[$db_column] = $excel_header;
    }
    return $reverse_mapping;
}

// دریافت پارامترهای فیلتر
$city_filter = isset($_GET['city_filter']) ? $_GET['city_filter'] : '';
$product_filter = isset($_GET['product_filter']) ? $_GET['product_filter'] : '';
$unique_id_filter = isset($_GET['unique_id_filter']) ? $_GET['unique_id_filter'] : '';
$sort_by = isset($_GET['sort_by']) ? $_GET['sort_by'] : 'شهرستان';
$sort_order = isset($_GET['sort_order']) ? $_GET['sort_order'] : 'ASC';

// ساخت شرط WHERE
$where_conditions = [];
$params = [];

if (!empty($city_filter)) {
    $where_conditions[] = "شهرستان LIKE ?";
    $params[] = "%$city_filter%";
}

if (!empty($product_filter)) {
    $where_conditions[] = "فراوده LIKE ?";
    $params[] = "%$product_filter%";
}

if (!empty($unique_id_filter)) {
    $where_conditions[] = "شناسه_یکتای_کاربرد LIKE ?";
    $params[] = "%$unique_id_filter%";
}

$where_sql = !empty($where_conditions) ? "WHERE " . implode(" AND ", $where_conditions) : "";

// دریافت داده‌ها برای خروجی
$sql = "SELECT * FROM fuel_requests $where_sql ORDER BY $sort_by $sort_order";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$records = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ایجاد فایل اکسل
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// تنظیم UTF-8 برای spreadsheet
$spreadsheet->getDefaultStyle()->getFont()->setName('Tahoma');
$spreadsheet->getDefaultStyle()->getFont()->setSize(10);

// مپینگ معکوس برای هدرهای اکسل
$reverse_mapping = reverseColumnMapping($column_mapping);

// تنظیم هدرها بر اساس مپینگ
$headers = [];
foreach ($reverse_mapping as $db_column => $excel_header) {
    $headers[] = $excel_header;
}

$sheet->fromArray($headers, NULL, 'A1');

// تنظیم جهت راست به چپ برای sheet
$sheet->setRightToLeft(true);

// افزودن داده‌ها
$row = 2;
foreach ($records as $record) {
    $rowData = [];
    foreach ($reverse_mapping as $db_column => $excel_header) {
        $value = $record[$db_column] ?? '';
        
        // تبدیل تاریخ‌های میلادی به شمسی برای نمایش بهتر
        if (in_array($db_column, ['تاریخ_ثبت_درخواست', 'شروع_بازه_مصرف', 'پایان_بازه_مصرف', 'تاریخ_تایید_درخواست_توسط_پخش']) && !empty($value)) {
            try {
                $carbon = \Carbon\Carbon::parse($value);
                $jalali = Jalalian::fromCarbon($carbon);
                $value = $jalali->format('Y/m/d');
            } catch (Exception $e) {
                // در صورت خطا در تبدیل، همان مقدار اصلی نمایش داده شود
            }
        }
        
        $rowData[] = $value;
    }
    $sheet->fromArray($rowData, NULL, 'A' . $row);
    $row++;
}

// تنظیم سایز خودکار ستون‌ها
for ($col = 'A'; $col <= 'AF'; $col++) {
    $sheet->getColumnDimension($col)->setAutoSize(true);
}

// تنظیم هدر برای دانلود
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8');
header('Content-Disposition: attachment;filename="درخواست_سوخت_' . date('Y-m-d') . '.xlsx"');
header('Cache-Control: max-age=0');
header('Pragma: public');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;