<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$downloads = WC()->customer->get_downloadable_products();
$has_downloads = (bool) $downloads;

do_action( 'woocommerce_before_account_downloads', $has_downloads ); ?>

<?php if ( $has_downloads ) : ?>

	<?php do_action( 'woocommerce_before_available_downloads' ); ?>

	<?php do_action( 'woocommerce_available_downloads', $downloads ); ?>

	<?php do_action( 'woocommerce_after_available_downloads' ); ?>

<?php else : ?>
    <div class="d-flex align-items-center flex-column justify-content-center" style="height: 440px;">
        <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 100 100" fill="none">
            <path d="M70.8333 70.8333H70.875M72.5 58.3333H75C78.8828 58.3333 80.8243 58.3333 82.3557 58.9677C84.3976 59.8134 86.0199 61.4357 86.8657 63.4776C87.5 65.0091 87.5 66.9505 87.5 70.8333C87.5 74.7162 87.5 76.6576 86.8657 78.189C86.0199 80.2309 84.3976 81.8532 82.3557 82.699C80.8243 83.3333 78.8828 83.3333 75 83.3333H25C21.1172 83.3333 19.1757 83.3333 17.6443 82.699C15.6024 81.8532 13.9801 80.2309 13.1343 78.189C12.5 76.6576 12.5 74.7162 12.5 70.8333C12.5 66.9505 12.5 65.0091 13.1343 63.4776C13.9801 61.4357 15.6024 59.8134 17.6443 58.9677C19.1757 58.3333 21.1172 58.3333 25 58.3333H27.5M50 62.5V16.6667M50 62.5L37.5 50M50 62.5L62.5 50" stroke="#E8E8E8" stroke-width="5" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
        <?php
			$wp_button_class = wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '';
			wc_print_notice( esc_html__( 'No downloads available yet.', 'woocommerce' ) . ' <a class="button wc-forward' . esc_attr( $wp_button_class ) . '" href="' . esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ) . '">' . esc_html__( 'Browse products', 'woocommerce' ) . '</a>', 'notice' ); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment 
			?>
    </div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_account_downloads', $has_downloads ); ?>