<?php
/**
 * Template part for displaying single post share box
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if( option_value('single-post-share-box') ) {
    ?>
    <div class="single-share-box-container">
        <?php
        $social = option_value('single-post-share-box-options');
        $share_summary = wp_strip_all_tags(get_the_excerpt());
        $share_url = get_permalink();
        $share_title = htmlspecialchars(get_the_title(), ENT_COMPAT, 'UTF-8');
        $share_media = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'full' );
        ?>
        <h4 class="title"><?php esc_html_e('Share Article', THEME_NAME); ?></h4>
        <?php if( $social['link'] ){ ?>
        <div class="share-box-link">
            <div class="form-content">
                <input type="text" name="url" value="<?php echo urldecode( get_the_permalink() ); ?>" class="share-link-text" readonly>
                <button type="submit" class="share-link-btn">
                    <i class="isax isax-share"></i>
                    <span class="copied-popup-text"><?php esc_html_e('Link Copied!', THEME_NAME) ?></span>
                </button>
            </div>
        </div>
        <?php } ?>
        <div class="single-share-box">
            <?php if( $social['telegram'] ){ ?>
                <a class="telegram" href="https://t.me/share/?url=<?php echo esc_url($share_url); ?>&text=<?php echo urlencode($share_title); ?>" target="_blank"><i class="fa-brands fa-telegram"></i></a>
            <?php } 
            if( $social['whatsapp'] ){ ?>
                <a class="whatsapp" href="https://api.whatsapp.com/send?text=<?php echo esc_url($share_url); ?>" target="_blank"><i class="fa-brands fa-whatsapp"></i></a>
            <?php }
            if( $social['twitter'] ){ ?>
                <a class="twitter"  href="https://twitter.com/intent/tweet?text=<?php echo urlencode($share_title); ?>&url=<?php echo esc_url($share_url); ?>" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
            <?php }
            if( $social['email'] ){ ?>
                <a class="email"  href="mailto:?subject=<?php echo urlencode($share_title); ?>&body=<?php echo esc_url($share_url); ?>" target="_blank"><i class="fa-regular fa-envelope"></i></a>
            <?php }
            if( $social['facebook'] ){ ?>
                <a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($share_url); ?>" target="_blank"><i class="fa-brands fa-facebook"></i></a>
            <?php }
            if( $social['linkedin'] ){ ?>
                <a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo esc_url($share_url); ?>&title=<?php echo urlencode($share_title); ?>" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a>
            <?php }
            if( $social['pinterest'] ){ ?>
                <a class="pinterest"  href="https://pinterest.com/pin/create/link/?url=<?php echo esc_url($share_url); ?>&media=<?php echo esc_url($share_media); ?>&description=<?php echo urlencode($share_title); ?>" target="_blank"><i class="fa-brands fa-pinterest"></i></a>
            <?php } ?>
        </div>
    </div>
    <?php
}