<?php
/**
 * Template part for displaying single post Audio hero content
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$position_to_content = option_value('single-format-audio-position'); // inside / outside
$position_to_meta = option_value('single-format-audio-position-to-meta'); // before / after
$audio_url = esc_url(get_post_meta( get_the_ID(), 'theme_single_audio_file', true));

$cls = ' ' . $position_to_meta . '-meta';

if($position_to_content == 'outside') {
    echo '<div class="container">';
    echo '<div class="row">';
    echo '<div class="col-12">';
}

echo '<div class="single-hero-audio">';

if($position_to_meta == 'after') {
    get_template_part('template-parts/post/hero/title-section-1');
}

?>

    <div class="single-hero-audio-container<?php echo esc_html($cls); ?>">
        <?php if ( $audio_url ) : ?>
            <audio class="plyr" controls>
                <source src="<?php echo esc_url( $audio_url ); ?>" type="audio/mpeg">
                Your browser does not support the audio element.
            </audio>
        <?php endif; ?>
    </div>

<?php
if($position_to_meta == 'before') {
    get_template_part('template-parts/post/hero/title-section-1');
}

echo '</div>'; // .single-hero-audio

if($position_to_content == 'outside') {
    echo '</div>';
    echo '</div>';
    echo '</div>'; // .container
}