<?php
/**
 * Template part for displaying header
 */
// Check if maintenance mode is enabled
if (intval(option_value('enable-maitanance-mode')) && !current_user_can('administrator')) {
	if ( ! is_page( 'login' ) ) {
        get_template_part('template-parts/maintenance');
        exit;
	}
}

?>
<header id="site-header">
<?php
// Singular Custom Header
$header_id = get_layout('header');

$header_template = get_post_meta( get_the_ID(), 'page-header', true);
$header = show_template($header_id);
if($header_template){
    $header_id = show_template($header_template);
}
if (! $header ) {
	$header_id = intval( option_value( 'site-header' ) );
    $header = show_template( $header_id );

}
if (is_404()){
    if(option_value('enable-header-404')) {
        if($header) {
            echo ($header);
        }
        else { // Default header
            get_template_part('template-parts/header/header-default');
        }
    }
}
else{
    if($header) {
        echo ($header);
    }
    elseif (get_post_type(get_the_ID()) == 'theme-header') {

    }
    else { // Default header
        get_template_part('template-parts/header/header-default');
    }
}
?>
</header>
