<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class theme_mega_menu extends Walker_Nav_Menu {

    function __construct() {
        
        add_action('wp_nav_menu_item_custom_fields', array( $this, 'add_meta_admin_menu_item' ), 10, 3 );
        add_action('wp_update_nav_menu_item', array( $this, 'update_meta_admin_menu_item' ), 10, 2 );
        add_action('wp_nav_menu_objects', array( $this, 'remove_default_submenu' ), 10, 2 );
        add_action('walker_nav_menu_start_el', array( $this, 'add_mega_menu_content' ), 10, 4 );
        add_action('nav_menu_css_class', array( $this, 'add_class_mega_menu_li' ), 10, 4 );
    }

    // Add meta to admin menu item
    function add_meta_admin_menu_item ($item_id, $item, $depth) {
        if( $depth != 0 )
            return;

        $current_template = get_post_meta($item_id, 'theme_mega_menu', true);
        $templates = get_all_header_template();

        $templates_default = [0 => $templates[0]]; // 0 => Default
        unset($templates[0]);// remove 0 => Default

        $templates = $templates_default + $templates;

        ?>
        <p class="description description-wide">
            <label for="theme_mega_menu-<?php echo esc_html($item_id); ?>" >
                <?php esc_html_e('Mega Menu Template', THEME_NAME); ?>
            </label><br>
            <select name="theme_mega_menu[<?php echo esc_html($item_id); ?>]" id="theme_mega_menu-<?php echo esc_html($item_id); ?>">
                <?php
                foreach ($templates as $id => $name) {
                    echo '<option value="' . $id . '" ' . selected($id, $current_template, false) . '>' . esc_html($name) . '</option>';
                }
                ?>
            </select>
        </p>
        <?php
    }

    // Update meta to admin menu item
    function update_meta_admin_menu_item ($menu_id, $menu_item_db_id) {
        $mega_menu_template_id = isset($_POST['theme_mega_menu'][$menu_item_db_id])? esc_html($_POST['theme_mega_menu'][$menu_item_db_id]) : 0;
        if( $mega_menu_template_id ) {
            update_post_meta($menu_item_db_id, 'theme_mega_menu', $mega_menu_template_id );
        }
        else {
            delete_post_meta($menu_item_db_id, 'theme_mega_menu');
        }
    }

    // Remove default sub-menu items from mega menu
    function remove_default_submenu ($sorted_menu_items, $args) {
        if($args->menu_class == 'theme-header-nav') {
            $new_items = array();
            $new_items[0] = 0; // $sorted_menu_items start from 0. So we changed $new_items index start from 0
            for($i=1; $i <= count($sorted_menu_items); $i++) {
                if($sorted_menu_items[$i]->menu_item_parent == 0) {
                    $new_items[] = $sorted_menu_items[$i];
                    $has_mega_menu = get_post_meta($sorted_menu_items[$i]->ID, 'theme_mega_menu', true);
                    if(intval($has_mega_menu)) {
                        while(isset($sorted_menu_items[$i+1]) && $sorted_menu_items[$i+1]-> menu_item_parent) {
                            $i++;
                        }
                    }
                }
                else {
                    $new_items[] = $sorted_menu_items[$i];
                }

            }

            unset($new_items[0]);

            return $new_items;
        }

        return $sorted_menu_items;
    }

    // Add mega Menu Content
    function add_mega_menu_content($item_output, $item, $depth, $args) {
        if($args->menu_class == 'theme-header-nav' && $depth == 0 ) {
            $mega_menu_template = intval(get_post_meta($item->ID, 'theme_mega_menu', true));
            if($mega_menu_template) { // Skip theme-mega-menu-3-col, theme-mega-menu-4-col
                $mega_menu_template_content = show_template($mega_menu_template);
                if($mega_menu_template_content) {
                    $item_output .= '<div class="sub-menu mega-menu-content">';
                    $item_output .= $mega_menu_template_content;
                    $item_output .= '</div>';
                }
            }
        }

        return $item_output;
    }

    // Add class to li
    function add_class_mega_menu_li($classes, $item, $args, $depth) {
        if($args->menu_class == 'theme-header-nav' && $depth == 0 ) {
            $mega_menu_template = get_post_meta($item->ID, 'theme_mega_menu', true);
            if($mega_menu_template) { // theme template
                $classes[] = 'theme-mega-menu-item';
            }
        }
        return $classes;
    }
}

// Call theme_Mega_menu
new theme_mega_menu();