<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_shop_sort extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_shop_sort';
    }

    public function get_title() {
        return esc_html__('shop sort', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_shop_sort';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section('section_style_image',
		    [
			    'label' => esc_html__('style', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
        $this->register_container_style('sort', 'select');
        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

   protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();

        $orderby_options = [
            'menu_order' => __('Default', THEME_NAME),
            'popularity' => __('popularity', THEME_NAME),
            'rating'     => __('rating', THEME_NAME),
            'date'       => __('date', THEME_NAME),
            'price'      => __('price', THEME_NAME),
            'price-desc' => __('pricedesc', THEME_NAME),
        ];

        ?>
        <select id="orderby-select">
            <?php foreach ($orderby_options as $orderby => $label) : ?>
                <option value="<?php echo esc_attr($orderby); ?>"><?php echo esc_html($label); ?></option>
            <?php endforeach; ?>
        </select>

        <script>
            (function($) {
                $(document).ready(function() {
                    $('#orderby-select').on('change', function() {
                        var orderby = $(this).val();
                        var currentUrl = window.location.href;
                        var newUrl;

                        if (currentUrl.indexOf('?') !== -1) {
                            var urlParts = currentUrl.split('?');
                            var baseUrl = urlParts[0];
                            var queryParams = urlParts[1].split('&');
                            var newQueryParams = queryParams.filter(function(param) {
                                return param.indexOf('orderby=') === -1;
                            });
                            newUrl = baseUrl + '?' + newQueryParams.join('&') + '&orderby=' + orderby;
                        } else {
                            newUrl = currentUrl + '?orderby=' + orderby;
                        }
                        window.location.href = newUrl;
                    });
                });
            })(jQuery);
        </script>

        <?php
    }

}