<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_sale_price extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_sale_price';
    }

    public function get_title() {
        return esc_html__('product sale price', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_sale_price';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'product price', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('theme_product_price',  'del bdi', $algin = false);
        
        $this->add_control(
		    'price_unit',
		    [
			    'label'     => esc_html__( 'unit', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('theme_product_price_unit',  'del bdi span', $algin = false);

        $this->end_controls_section();

    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'product_sale_price_style_section',
            [
                'label' => esc_html__( 'product off price', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_text_style('theme_product_sale_price',  'ins bdi', $algin = false);

        $this->add_control(
		    'off_price_unit',
		    [
			    'label'     => esc_html__( 'unit', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );


        $this->register_text_style('theme_product_sale_price_unit',  'ins bdi span', $algin = false);


        $this->end_controls_section();
    }

	


	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
    }

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		$settings = $this->get_settings_for_display();

		if ( $this->theme_is_edit_mode() ) {
			$first_product_id = get_posts( array(
				'post_type' => 'product',
				'posts_per_page' => 1,
				'orderby' => 'ID',
				'order' => 'ASC',
				'fields' => 'ids',
			) );
			$first_product = wc_get_product( $first_product_id[0] );
			$product_price = $first_product->get_price();

			if ( $product_price == 0 ) {
				echo '<p class="theme-product-price">Free</p>';
			} else {
				$product_price_html = $first_product->get_price_html();
				echo '<p class="theme-product-price">' . $product_price_html . '</p>';
			}

		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );

			if ( $product ) {
				$product_price = $product->get_price();

				if ( $product_price == 0 ) {
					echo '<p class="theme-product-price">' . __('Free', THEME_NAME) . '</p>';
				} else {
					$product_price_html = $product->get_price_html();
					echo '<p class="theme-product-price">' . $product_price_html . '</p>';
				}
			}
		}
	}


}