<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_publish_date extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_publish_date';
    }

    public function get_title() {
        return esc_html__('product publish date', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_publish_date';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'publish date', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.product-dates');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            echo '<p class="product-dates">';
			echo convert_date( get_the_date(), 'j F Y' );
            echo '</p>';
        } else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );

            if ($product) {
                echo '<p class="product-dates">'; 
                $current_locale = get_locale();
				echo convert_date( get_the_date(), 'j F Y' );
                echo'</p>';                
            }
        }
    }


}