<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_image extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_image';
    }

    public function get_title() {
        return esc_html__('product image', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_image';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section('section_style_image',
		    [
			    'label' => esc_html__('Image', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_image_style('product_image', '.theme-product-image');
        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
        if($this->theme_is_edit_mode()){
            $first_product_id = get_posts( array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ) );
            $first_product = wc_get_product( $first_product_id[0] );
            $product_image_id = $first_product->get_image_id();
            if ( $product_image_id ) {
                $product_image_url = wp_get_attachment_image_src( $product_image_id, 'full' );

                echo '<img  src="' . esc_url( $product_image_url[0] ) . '" alt="' . esc_attr( $first_product->get_name() ) . '" class="theme-product-image" />';
                return;
            }
            else{

                $html  = '<div class="woocommerce-product-gallery__image--placeholder">';
                $html .= sprintf( '<img src="%s" alt="%s" class="theme-product-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
                $html .= '</div>';
                echo $html;
            }
            return;
        }
        global $post;
        $product_id = get_the_ID();
        $product = wc_get_product( $product_id );
        if( $product != null ){
            $product_image_id = get_post_thumbnail_id( $product->ID );
            if ( $product_image_id ) {
                $product_image_url = wp_get_attachment_image_url( $product_image_id, 'full' );
                echo '<img class="theme-product-image" src="' . esc_url( $product_image_url ) . '" alt="' . esc_attr( get_the_title( $product->ID ) ) . '" />';
            } else {
                $html  = '<div class="woocommerce-product-gallery__image--placeholder">';
                $html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
                $html .= '</div>';
                echo $html;
            }
        }
        else{
            ?>
            <p><?php echo esc_html__( 'use this widget on woocommerce page only', THEME_NAME ) ?></p>
            <?php
        }
        
    }
}