<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_breadcrumb extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_breadcrumb';
    }

    public function get_title() {
        return esc_html__('product breadcrumb', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_breadcrumb';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'category', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.woocommerce-breadcrumb');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ($this->theme_is_edit_mode()) {
            echo '<p class="woocommerce-breadcrumb">'. __("home / category 1 / product name ", THEME_NAME).'</p>';
        } else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
            
            woocommerce_breadcrumb();
        }
    }


}