<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_checkout_total extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_checkout_total';
    }

    public function get_title() {
        return esc_html__('checkout total', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_checkout_total';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'cart_table',
		    [
			    'label' => esc_html__('table', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_table_style('cart_table', '.shop_table');
        $this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'produt-name',
			[ 
				'label' => esc_html__( 'produt', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'produt-name', '.product-name', $align = false );

		$this->add_control(
			'product-price-sep',
			[ 
				'label' => esc_html__( 'product total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'produt-total', '.product-total', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'order-sub-total',
			[ 
				'label' => esc_html__( 'order sub total', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'order-sub-total', '.cart-subtotal th', $align = false );

		$this->add_control(
			'product-sub-total-sep',
			[ 
				'label' => esc_html__( 'total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'price-sub-total', '.cart-subtotal td', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_4() {
		$this->start_controls_section(
			'order-shipping',
			[ 
				'label' => esc_html__( 'order shipping', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'woocommerce-shipping-totals-th', '.woocommerce-shipping-totals th', $align = false );

		$this->add_control(
			'woocommerce-shipping-totals-sep',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-shipping-totals-items', '.woocommerce-shipping-totals td li', $align = false );

		$this->end_controls_section();
	}

    protected function register_style_section_5() {
        $this->start_controls_section(
            'order_total',
		    [
			    'label' => esc_html__('order total', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

		$this->add_control(
			'product-total-label-sep',
			[ 
				'label' => esc_html__( 'label', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('total_price_name', '.order-total th', $align = false);

		$this->add_control(
			'product-total-sep',
			[ 
				'label' => esc_html__( 'total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'total_price_value', '.order-total td', $align = false );

        $this->end_controls_section();
    }
    
	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
		$this->register_style_section_5();
    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ( $this->theme_is_edit_mode()) {
            ?>
            <table class="shop_table woocommerce-checkout-review-order-table">
                <thead>
                    <tr>
                        <th class="product-name">محصول</th>
                        <th class="product-total">جمع جزء</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="cart_item">
                        <td class="product-name">
                            دوره تارگتینگ&nbsp;	
                            <strong class="product-quantity">×&nbsp;3</strong>	
                        </td>
                        <td class="product-total">
                            <span class="woocommerce-Price-amount amount"><bdi>12،000،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi></span>
                        </td>
                    </tr>
                    <tr class="cart_item">
                        <td class="product-name">
                            برند سازی&nbsp;<strong class="product-quantity">×&nbsp;1</strong>
                        </td>
                        <td class="product-total">
                            <span class="woocommerce-Price-amount amount">
                                <bdi>1،200،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                            </span>	
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr class="cart-subtotal">
                        <th>جمع جزء</th>
                        <td>
                            <span class="woocommerce-Price-amount amount"><bdi>13،200،000&nbsp;
                            <span class="woocommerce-Price-currencySymbol">تومان</span></bdi></span>
                        </td>
                    </tr>
                    <tr class="woocommerce-shipping-totals shipping">
                        <th>حمل و نقل</th>
                        <td data-title="حمل و نقل">
                            <ul id="shipping_method" class="woocommerce-shipping-methods">
                                <li>
                                    <input type="radio" name="shipping_method[0]" data-index="0" id="shipping_method_0_free_shipping1" value="free_shipping:1" class="shipping_method" checked="checked" />
                                    <label for="shipping_method_0_free_shipping1">حمل و نقل رایگان</label>
                                </li>
                                <li>
                                    <input type="radio" name="shipping_method[0]" data-index="0" id="shipping_method_0_flat_rate2" value="flat_rate:2" class="shipping_method" />
                                    <label for="shipping_method_0_flat_rate2">
                                        نرخ ثابت:
                                        <span class="woocommerce-Price-amount amount">
                                            <bdi>50،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                                        </span>
                                    </label>
                                </li>
                                <li><input type="radio" name="shipping_method[0]" data-index="0" id="shipping_method_0_local_pickup3" value="local_pickup:3" class="shipping_method" /><label for="shipping_method_0_local_pickup3">تحویل محلی</label></li>
                            </ul>
                        </td>
                    </tr>

                    <tr class="order-total">
                        <th>مجموع</th>
                        <td>
                            <strong><span class="woocommerce-Price-amount amount"><bdi>13،200،000&nbsp;
                            <span class="woocommerce-Price-currencySymbol">تومان</span></bdi></span></strong>
                        </td>
                    </tr>
                </tfoot>
            </table>
            <?php
        }
        else{
			if ( isset( $_GET['key'] ) ) {
				$order_id = wc_get_order_id_by_order_key( $_GET['key'] );
				$order = wc_get_order( $order_id );
			} else {
				?>
			<table class="shop_table woocommerce-checkout-review-order-table">
				<thead>
					<tr>
						<th class="product-name"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
						<th class="product-total"><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php
					do_action( 'woocommerce_review_order_before_cart_contents' );

					foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
						$_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );

						if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
							?>
									<tr
										class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
										<td class="product-name">
											<?php echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) ) . '&nbsp;'; ?>
											<?php echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( '&times;&nbsp;%s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
											<?php echo wc_get_formatted_cart_item_data( $cart_item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
										</td>
										<td class="product-total">
											<?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
										</td>
									</tr>
									<?php
						}
					}

					do_action( 'woocommerce_review_order_after_cart_contents' );
					?>
				</tbody>
				<tfoot>
			
					<tr class="cart-subtotal">
						<th><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
						<td><?php wc_cart_totals_subtotal_html(); ?></td>
					</tr>
			
					<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
							<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
								<th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
								<td><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
							</tr>
					<?php endforeach; ?>
			
					<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
			
							<?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
			
							<?php wc_cart_totals_shipping_html(); ?>
			
							<?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
			
					<?php endif; ?>
			
					<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
							<tr class="fee">
								<th><?php echo esc_html( $fee->name ); ?></th>
								<td><?php wc_cart_totals_fee_html( $fee ); ?></td>
							</tr>
					<?php endforeach; ?>
			
					<?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
							<?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
									<?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited ?>
											<tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
												<th><?php echo esc_html( $tax->label ); ?></th>
												<td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
											</tr>
									<?php endforeach; ?>
							<?php else : ?>
									<tr class="tax-total">
										<th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
										<td><?php wc_cart_totals_taxes_total_html(); ?></td>
									</tr>
							<?php endif; ?>
					<?php endif; ?>
			
					<?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
			
					<tr class="order-total">
						<th><?php esc_html_e( 'Total', 'woocommerce' ); ?></th>
						<td><?php wc_cart_totals_order_total_html(); ?></td>
					</tr>
			
					<?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
			
				</tfoot>
			</table>
			<script>
				jQuery( document ).ready( function ( $ )
				{
					// Add checked attribute to input when label is clicked
					$( document ).on( 'click', 'tfoot label', function ()
					{
						// Find the input associated with the clicked label
						var $input = $( this ).prev( 'input[type="radio"]' );

						// Check if the input exists and is a radio button
						if ( $input.length && $input.is( ':radio' ) )
						{
							// Add checked attribute to the input
							$input.attr( 'checked', 'checked' );
							$input.trigger( 'change' );
						}
					} );
					$( document ).on( 'click', 'tfoot input[type="radio"]', function ()
					{
						console.log( this );
						$( this ).attr( 'checked', 'checked' );
						$( this ).trigger( 'change' );
					} );
				} );
			</script>
			<?php
			}
            
        }        
	}
}